/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsHierarchicalKeyring_Compile;

import Actions_Compile.Action;
import Actions_Compile.ActionWithResult;
import AwsKmsHierarchicalKeyring_Compile.HierarchyUnwrapInfo;
import AwsKmsHierarchicalKeyring_Compile.KmsHierarchyUnwrapKeyMaterial;
import AwsKmsHierarchicalKeyring_Compile.__default;
import BoundedInts_Compile.uint8;
import EdkWrapping_Compile.UnwrapEdkMaterialOutput;
import Materials_Compile.SealedDecryptionMaterials;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.Tuple0;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials;
import software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionInput;
import software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionOutput;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache;
import software.amazon.cryptography.materialproviders.internaldafny.types.Materials;
import software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.DigestInput;
import software.amazon.cryptography.primitives.internaldafny.types.Error;

public class DecryptSingleEncryptedDataKey
implements ActionWithResult<EncryptedDataKey, DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>,
Action<EncryptedDataKey, Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>> {
    public DecryptionMaterials _materials = null;
    public IKeyStoreClient _keyStore = null;
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public DafnySequence<? extends Character> _branchKeyId = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public long _ttlSeconds = 0L;
    public ICryptographicMaterialsCache _cache = null;
    private static final TypeDescriptor<DecryptSingleEncryptedDataKey> _TYPE = TypeDescriptor.referenceWithInitializer(DecryptSingleEncryptedDataKey.class, () -> null);

    public void __ctor(DecryptionMaterials materials, IKeyStoreClient keyStore, AtomicPrimitivesClient cryptoPrimitives, DafnySequence<? extends Character> branchKeyId, long ttlSeconds, ICryptographicMaterialsCache cache) {
        this._materials = materials;
        this._keyStore = keyStore;
        this._cryptoPrimitives = cryptoPrimitives;
        this._branchKeyId = branchKeyId;
        this._ttlSeconds = ttlSeconds;
        this._cache = cache;
    }

    @Override
    public Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> Invoke(EncryptedDataKey edk) {
        Result<UnwrapEdkMaterialOutput<HierarchyUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out167;
        Result<AtomicPrimitivesClient, Error> _out166;
        Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = null;
        Outcome<Object> _894_valueOrError0 = Outcome.Default();
        _894_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UTF8.__default.ValidUTF8Seq(edk.dtor_keyProviderInfo()), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Received invalid EDK provider info for Hierarchical Keyring")));
        if (_894_valueOrError0.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _894_valueOrError0.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        AlgorithmSuiteInfo _895_suite = this.materials().dtor_algorithmSuite();
        DafnySequence<? extends Byte> _896_keyProviderId = edk.dtor_keyProviderId();
        DafnySequence<? extends Byte> _897_branchKeyIdUtf8 = edk.dtor_keyProviderInfo();
        DafnySequence<? extends Byte> _898_ciphertext = edk.dtor_ciphertext();
        Result<Object, Object> _900_valueOrError1 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _900_valueOrError1 = EdkWrapping_Compile.__default.GetProviderWrappedMaterial(_898_ciphertext, _895_suite);
        if (_900_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _900_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _899_providerWrappedMaterial = (DafnySequence)_900_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Outcome<Object> _901_valueOrError2 = Outcome.Default();
        _901_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BigInteger.valueOf(_899_providerWrappedMaterial.length()).compareTo(BigInteger.valueOf(__default.EDK__CIPHERTEXT__VERSION__INDEX())) >= 0, software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Received EDK Ciphertext of incorrect length.")));
        if (_901_valueOrError2.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _901_valueOrError2.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _902_branchKeyVersionUuid = _899_providerWrappedMaterial.subsequence(__default.EDK__CIPHERTEXT__BRANCH__KEY__VERSION__INDEX(), __default.EDK__CIPHERTEXT__VERSION__INDEX());
        Result<Object, Object> _904_valueOrError3 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        _904_valueOrError3 = UUID.__default.FromByteArray((DafnySequence<? extends Byte>)_902_branchKeyVersionUuid).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_904_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _904_valueOrError3.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _903_version = (DafnySequence)_904_valueOrError3.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<Object, Object> _906_valueOrError4 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out164 = this.GetVersionCacheId(_897_branchKeyIdUtf8, (DafnySequence<? extends Character>)_903_version, this.cryptoPrimitives());
        _906_valueOrError4 = _out164;
        if (_906_valueOrError4.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _906_valueOrError4.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _905_cacheId = (DafnySequence)_906_valueOrError4.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<BranchKeyMaterials, Object> _908_valueOrError5 = Result.Default(BranchKeyMaterials.Default());
        Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out165 = this.GetHierarchicalMaterialsVersion(this.branchKeyId(), _897_branchKeyIdUtf8, (DafnySequence<? extends Character>)_903_version, (DafnySequence<? extends Byte>)_905_cacheId);
        _908_valueOrError5 = _out165;
        if (_908_valueOrError5.IsFailure(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _908_valueOrError5.PropagateFailure(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        BranchKeyMaterials _907_hierarchicalMaterials = _908_valueOrError5.Extract(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        DafnySequence<? extends Byte> _909_branchKey = _907_hierarchicalMaterials.dtor_branchKey();
        DafnySequence<? extends Byte> _910_branchKeyVersion = _907_hierarchicalMaterials.dtor_branchKeyVersion();
        Result<Object, Object> _912_valueOrError6 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        _912_valueOrError6 = UTF8.__default.Decode(_910_branchKeyVersion).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_912_valueOrError6.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _912_valueOrError6.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _911_branchKeyVersionAsString = (DafnySequence)_912_valueOrError6.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<Object, Object> _914_valueOrError7 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _914_valueOrError7 = UUID.__default.ToByteArray((DafnySequence<? extends Character>)_911_branchKeyVersionAsString).MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_914_valueOrError7.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _914_valueOrError7.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _913_branchKeyVersionAsBytes = (DafnySequence)_914_valueOrError7.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<AtomicPrimitivesClient, Error> _915_maybeCrypto = _out166 = software.amazon.cryptography.primitives.internaldafny.__default.AtomicPrimitives(software.amazon.cryptography.primitives.internaldafny.__default.DefaultCryptoConfig());
        Result<AtomicPrimitivesClient, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _917_valueOrError8 = null;
        _917_valueOrError8 = _915_maybeCrypto.MapFailure(AtomicPrimitivesClient._typeDescriptor(), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _918_e_boxed0 -> {
            Error _918_e = _918_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_918_e);
        });
        if (_917_valueOrError8.IsFailure(AtomicPrimitivesClient._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _917_valueOrError8.PropagateFailure(AtomicPrimitivesClient._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        AtomicPrimitivesClient _916_crypto = _917_valueOrError8.Extract(AtomicPrimitivesClient._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        KmsHierarchyUnwrapKeyMaterial _nw37 = new KmsHierarchyUnwrapKeyMaterial();
        _nw37.__ctor(_909_branchKey, _897_branchKeyIdUtf8, (DafnySequence<? extends Byte>)_913_branchKeyVersionAsBytes, _916_crypto);
        KmsHierarchyUnwrapKeyMaterial _919_kmsHierarchyUnwrap = _nw37;
        Result<UnwrapEdkMaterialOutput<HierarchyUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _920_unwrapOutputRes = _out167 = EdkWrapping_Compile.__default.UnwrapEdkMaterial(HierarchyUnwrapInfo._typeDescriptor(), edk.dtor_ciphertext(), this.materials(), _919_kmsHierarchyUnwrap);
        Result<UnwrapEdkMaterialOutput<HierarchyUnwrapInfo>, Object> _922_valueOrError9 = Result.Default(UnwrapEdkMaterialOutput.Default(HierarchyUnwrapInfo.Default()));
        _922_valueOrError9 = _920_unwrapOutputRes;
        if (_922_valueOrError9.IsFailure(UnwrapEdkMaterialOutput._typeDescriptor(HierarchyUnwrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _922_valueOrError9.PropagateFailure(UnwrapEdkMaterialOutput._typeDescriptor(HierarchyUnwrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        UnwrapEdkMaterialOutput<HierarchyUnwrapInfo> _921_unwrapOutput = _922_valueOrError9.Extract(UnwrapEdkMaterialOutput._typeDescriptor(HierarchyUnwrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _924_valueOrError10 = null;
        _924_valueOrError10 = Materials_Compile.__default.DecryptionMaterialsAddDataKey(this.materials(), _921_unwrapOutput.dtor_plaintextDataKey(), _921_unwrapOutput.dtor_symmetricSigningKey());
        if (_924_valueOrError10.IsFailure(DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _924_valueOrError10.PropagateFailure(DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DecryptionMaterials _923_result = _924_valueOrError10.Extract(DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        res = Result.create_Success(_923_result);
        return res;
    }

    public Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetVersionCacheId(DafnySequence<? extends Byte> branchKeyIdUtf8, DafnySequence<? extends Character> branchKeyVersion, AtomicPrimitivesClient cryptoPrimitives) {
        Result<DafnySequence<? extends Byte>, Error> _out168;
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> cacheId = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Outcome<Object> _925_valueOrError0 = Outcome.Default();
        _925_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UTF8.__default.Decode(branchKeyIdUtf8).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError).is_Success() && (Boolean)Helpers.Let(UTF8.__default.Decode(branchKeyIdUtf8).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError).dtor_value(), boxed40 -> {
            DafnySequence _pat_let20_0 = boxed40;
            return (boolean)((Boolean)Helpers.Let((Object)_pat_let20_0, boxed41 -> {
                DafnySequence _926_branchKeyId = boxed41;
                return BigInteger.valueOf(_926_branchKeyId.length()).signum() != -1 && BigInteger.valueOf(_926_branchKeyId.length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT32__LIMIT()) < 0;
            }));
        }) != false, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Branch Key ID Length")));
        if (_925_valueOrError0.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _925_valueOrError0.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence<? extends Character> _927_branchKeyId = UTF8.__default.Decode(branchKeyIdUtf8).dtor_value();
        DafnySequence<? extends Byte> _928_lenBranchKey = StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(_927_branchKeyId.cardinalityInt());
        Outcome<Object> _929_valueOrError1 = Outcome.Default();
        _929_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UTF8.__default.IsASCIIString(branchKeyVersion), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unable to represent as an ASCII string.")));
        if (_929_valueOrError1.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _929_valueOrError1.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence<? extends Byte> _930_versionBytes = UTF8.__default.EncodeAscii(branchKeyVersion);
        DafnySequence _931_identifier = DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(_928_lenBranchKey, branchKeyIdUtf8), (DafnySequence)DafnySequence.of((byte[])new byte[]{0})), _930_versionBytes);
        DigestInput _932_identifierDigestInput = DigestInput.create(DigestAlgorithm.create_SHA__512(), (DafnySequence<? extends Byte>)_931_identifier);
        Result<DafnySequence<? extends Byte>, Error> _933_maybeCacheDigest = _out168 = Digest_Compile.__default.Digest(_932_identifierDigestInput);
        Result<Object, Object> _935_valueOrError2 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _935_valueOrError2 = _933_maybeCacheDigest.MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _936_e_boxed0 -> {
            Error _936_e = _936_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_936_e);
        });
        if (_935_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _935_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence _934_cacheDigest = (DafnySequence)_935_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        cacheId = Result.create_Success(_934_cacheDigest.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)BigInteger.valueOf(32L))));
        return cacheId;
    }

    public Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetHierarchicalMaterialsVersion(DafnySequence<? extends Character> branchKeyId, DafnySequence<? extends Byte> branchKeyIdUtf8, DafnySequence<? extends Character> version, DafnySequence<? extends Byte> cacheId) {
        Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> material = Result.Default(BranchKeyMaterials.Default());
        GetCacheEntryInput _937_getCacheInput = GetCacheEntryInput.create(cacheId, Option.create_None());
        Result<GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out169 = __default.getEntry(this.cache(), _937_getCacheInput);
        Result<GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _938_getCacheOutput = _out169;
        if (_938_getCacheOutput.is_Failure()) {
            long _out171;
            Result<GetBranchKeyVersionOutput, software.amazon.cryptography.keystore.internaldafny.types.Error> _out170;
            Result<GetBranchKeyVersionOutput, software.amazon.cryptography.keystore.internaldafny.types.Error> _939_maybeGetBranchKeyVersionOutput = _out170 = this.keyStore().GetBranchKeyVersion(GetBranchKeyVersionInput.create(branchKeyId, version));
            Result<GetBranchKeyVersionOutput, Object> _941_valueOrError0 = Result.Default(GetBranchKeyVersionOutput.Default());
            _941_valueOrError0 = _939_maybeGetBranchKeyVersionOutput.MapFailure(GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _942_e_boxed0 -> {
                software.amazon.cryptography.keystore.internaldafny.types.Error _942_e = _942_e_boxed0;
                return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyKeyStore(_942_e);
            });
            if (_941_valueOrError0.IsFailure(GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _941_valueOrError0.PropagateFailure(GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            GetBranchKeyVersionOutput _940_getBranchKeyVersionOutput = _941_valueOrError0.Extract(GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            BranchKeyMaterials _943_branchKeyMaterials = _940_getBranchKeyVersionOutput.dtor_branchKeyMaterials();
            long _944_now = _out171 = Time.__default.CurrentRelativeTime().longValue();
            Outcome<Object> _945_valueOrError1 = Outcome.Default();
            _945_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BigInteger.valueOf(_944_now).add(BigInteger.valueOf(this.ttlSeconds())).compareTo(StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT()) < 0, software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"INT64 Overflow when putting cache entry.")));
            if (_945_valueOrError1.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _945_valueOrError1.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            PutCacheEntryInput _946_putCacheEntryInput = PutCacheEntryInput.create(cacheId, Materials.create_BranchKey(_943_branchKeyMaterials), _944_now, this.ttlSeconds() + _944_now, Option.create_None(), Option.create_None());
            Result<Tuple0, Object> _948_valueOrError2 = Result.Default(Tuple0.Default());
            Result<Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out172 = __default.putEntry(this.cache(), _946_putCacheEntryInput);
            _948_valueOrError2 = _out172;
            if (_948_valueOrError2.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _948_valueOrError2.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            Tuple0 _947___v1 = _948_valueOrError2.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            material = Result.create_Success(_943_branchKeyMaterials);
            return material;
        }
        Outcome<Object> _949_valueOrError3 = Outcome.Default();
        _949_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _938_getCacheOutput.dtor_value().dtor_materials().is_BranchKey() && Objects.equals(_938_getCacheOutput.dtor_value().dtor_materials(), Materials.create_BranchKey(_938_getCacheOutput.dtor_value().dtor_materials().dtor_BranchKey())), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Material Type.")));
        if (_949_valueOrError3.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            material = _949_valueOrError3.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
            return material;
        }
        material = Result.create_Success(_938_getCacheOutput.dtor_value().dtor_materials().dtor_BranchKey());
        return material;
    }

    public DecryptionMaterials materials() {
        return this._materials;
    }

    public IKeyStoreClient keyStore() {
        return this._keyStore;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public DafnySequence<? extends Character> branchKeyId() {
        return this._branchKeyId;
    }

    public long ttlSeconds() {
        return this._ttlSeconds;
    }

    public ICryptographicMaterialsCache cache() {
        return this._cache;
    }

    public static TypeDescriptor<DecryptSingleEncryptedDataKey> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsHierarchicalKeyring.DecryptSingleEncryptedDataKey";
    }
}

