/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.services.kms.internaldafny.types;

import dafny.TypeDescriptor;
import java.util.ArrayList;
import software.amazon.cryptography.services.kms.internaldafny.types.DataKeyPairSpec_ECC__NIST__P256;
import software.amazon.cryptography.services.kms.internaldafny.types.DataKeyPairSpec_ECC__NIST__P384;
import software.amazon.cryptography.services.kms.internaldafny.types.DataKeyPairSpec_ECC__NIST__P521;
import software.amazon.cryptography.services.kms.internaldafny.types.DataKeyPairSpec_ECC__SECG__P256K1;
import software.amazon.cryptography.services.kms.internaldafny.types.DataKeyPairSpec_RSA__2048;
import software.amazon.cryptography.services.kms.internaldafny.types.DataKeyPairSpec_RSA__3072;
import software.amazon.cryptography.services.kms.internaldafny.types.DataKeyPairSpec_RSA__4096;

public abstract class DataKeyPairSpec {
    private static final DataKeyPairSpec theDefault = DataKeyPairSpec.create_RSA__2048();
    private static final TypeDescriptor<DataKeyPairSpec> _TYPE = TypeDescriptor.referenceWithInitializer(DataKeyPairSpec.class, () -> DataKeyPairSpec.Default());

    public static DataKeyPairSpec Default() {
        return theDefault;
    }

    public static TypeDescriptor<DataKeyPairSpec> _typeDescriptor() {
        return _TYPE;
    }

    public static DataKeyPairSpec create_RSA__2048() {
        return new DataKeyPairSpec_RSA__2048();
    }

    public static DataKeyPairSpec create_RSA__3072() {
        return new DataKeyPairSpec_RSA__3072();
    }

    public static DataKeyPairSpec create_RSA__4096() {
        return new DataKeyPairSpec_RSA__4096();
    }

    public static DataKeyPairSpec create_ECC__NIST__P256() {
        return new DataKeyPairSpec_ECC__NIST__P256();
    }

    public static DataKeyPairSpec create_ECC__NIST__P384() {
        return new DataKeyPairSpec_ECC__NIST__P384();
    }

    public static DataKeyPairSpec create_ECC__NIST__P521() {
        return new DataKeyPairSpec_ECC__NIST__P521();
    }

    public static DataKeyPairSpec create_ECC__SECG__P256K1() {
        return new DataKeyPairSpec_ECC__SECG__P256K1();
    }

    public boolean is_RSA__2048() {
        return this instanceof DataKeyPairSpec_RSA__2048;
    }

    public boolean is_RSA__3072() {
        return this instanceof DataKeyPairSpec_RSA__3072;
    }

    public boolean is_RSA__4096() {
        return this instanceof DataKeyPairSpec_RSA__4096;
    }

    public boolean is_ECC__NIST__P256() {
        return this instanceof DataKeyPairSpec_ECC__NIST__P256;
    }

    public boolean is_ECC__NIST__P384() {
        return this instanceof DataKeyPairSpec_ECC__NIST__P384;
    }

    public boolean is_ECC__NIST__P521() {
        return this instanceof DataKeyPairSpec_ECC__NIST__P521;
    }

    public boolean is_ECC__SECG__P256K1() {
        return this instanceof DataKeyPairSpec_ECC__SECG__P256K1;
    }

    public static ArrayList<DataKeyPairSpec> AllSingletonConstructors() {
        ArrayList<DataKeyPairSpec> singleton_iterator = new ArrayList<DataKeyPairSpec>();
        singleton_iterator.add(new DataKeyPairSpec_RSA__2048());
        singleton_iterator.add(new DataKeyPairSpec_RSA__3072());
        singleton_iterator.add(new DataKeyPairSpec_RSA__4096());
        singleton_iterator.add(new DataKeyPairSpec_ECC__NIST__P256());
        singleton_iterator.add(new DataKeyPairSpec_ECC__NIST__P384());
        singleton_iterator.add(new DataKeyPairSpec_ECC__NIST__P521());
        singleton_iterator.add(new DataKeyPairSpec_ECC__SECG__P256K1());
        return singleton_iterator;
    }
}

