/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.services.dynamodb.internaldafny;

import Wrappers_Compile.Option;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.cryptography.services.dynamodb.internaldafny.Shim;
import software.amazon.cryptography.services.dynamodb.internaldafny._ExternBase___default;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.Error;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.IDynamoDBClient;
import software.amazon.smithy.dafny.conversion.ToDafny;

public class __default
extends _ExternBase___default {
    public static Result<IDynamoDBClient, Error> DynamoDBClient() {
        try {
            Region region = new DefaultAwsRegionProviderChain().getRegion();
            DynamoDbClient ddbClient = (DynamoDbClient)((DynamoDbClientBuilder)DynamoDbClient.builder().region(region)).build();
            Shim shim = new Shim(ddbClient, region.toString());
            return Result.create_Success(shim);
        }
        catch (Exception e) {
            Error dafny_error = Error.create_InternalServerError(Option.create_Some(ToDafny.Simple.CharacterSequence((String)e.getMessage())));
            return Result.create_Failure(dafny_error);
        }
    }

    public static Result<IDynamoDBClient, Error> DDBClientForRegion(DafnySequence<? extends Character> region) {
        try {
            String regionString = new String((char[])region.toArray().unwrap());
            DynamoDbClient ddbClient = (DynamoDbClient)((DynamoDbClientBuilder)DynamoDbClient.builder().region(Region.of((String)regionString))).build();
            Shim shim = new Shim(ddbClient, regionString);
            return Result.create_Success(shim);
        }
        catch (Exception e) {
            Error dafny_error = Error.create_InternalServerError(Option.create_Some(ToDafny.Simple.CharacterSequence((String)e.getMessage())));
            return Result.create_Failure(dafny_error);
        }
    }
}

