/*
 * Decompiled with CFR 0.152.
 */
package StandardLibrary_mUInt_Compile;

import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;

public class __default {
    public static boolean UInt8Less(byte a, byte b) {
        return Integer.compareUnsigned(a, b) < 0;
    }

    public static <__T> boolean HasUint16Len(TypeDescriptor<__T> _td___T, DafnySequence<? extends __T> s) {
        return BigInteger.valueOf(s.length()).compareTo(__default.UINT16__LIMIT()) < 0;
    }

    public static <__T> boolean HasUint32Len(TypeDescriptor<__T> _td___T, DafnySequence<? extends __T> s) {
        return BigInteger.valueOf(s.length()).compareTo(__default.UINT32__LIMIT()) < 0;
    }

    public static <__T> boolean HasUint64Len(TypeDescriptor<__T> _td___T, DafnySequence<? extends __T> s) {
        return BigInteger.valueOf(s.length()).compareTo(__default.UINT64__LIMIT()) < 0;
    }

    public static DafnySequence<? extends Byte> UInt16ToSeq(short x) {
        byte _176_b0 = (byte)Helpers.divideUnsignedShort((short)x, (short)256);
        byte _177_b1 = (byte)Helpers.remainderUnsignedShort((short)x, (short)256);
        return DafnySequence.of((byte[])new byte[]{_176_b0, _177_b1});
    }

    public static short SeqToUInt16(DafnySequence<? extends Byte> s) {
        short _178_x0 = (short)((short)Byte.toUnsignedInt((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO))) * 256);
        return (short)(_178_x0 + (short)Byte.toUnsignedInt((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.ONE))));
    }

    public static DafnySequence<? extends Byte> UInt32ToSeq(int x) {
        byte _179_b0 = (byte)Integer.divideUnsigned(x, 0x1000000);
        int _180_x0 = x - Byte.toUnsignedInt(_179_b0) * 0x1000000;
        byte _181_b1 = (byte)Integer.divideUnsigned(_180_x0, 65536);
        int _182_x1 = _180_x0 - Byte.toUnsignedInt(_181_b1) * 65536;
        byte _183_b2 = (byte)Integer.divideUnsigned(_182_x1, 256);
        byte _184_b3 = (byte)Integer.remainderUnsigned(_182_x1, 256);
        return DafnySequence.of((byte[])new byte[]{_179_b0, _181_b1, _183_b2, _184_b3});
    }

    public static int SeqToUInt32(DafnySequence<? extends Byte> s) {
        int _185_x0 = Byte.toUnsignedInt((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO))) * 0x1000000;
        int _186_x1 = _185_x0 + Byte.toUnsignedInt((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.ONE))) * 65536;
        int _187_x2 = _186_x1 + Byte.toUnsignedInt((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)))) * 256;
        return _187_x2 + Byte.toUnsignedInt((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(3L))));
    }

    public static DafnySequence<? extends Byte> UInt64ToSeq(long x) {
        byte _188_b0 = (byte)Long.divideUnsigned(x, 0x100000000000000L);
        long _189_x0 = x - Byte.toUnsignedLong(_188_b0) * 0x100000000000000L;
        byte _190_b1 = (byte)Long.divideUnsigned(_189_x0, 0x1000000000000L);
        long _191_x1 = _189_x0 - Byte.toUnsignedLong(_190_b1) * 0x1000000000000L;
        byte _192_b2 = (byte)Long.divideUnsigned(_191_x1, 0x10000000000L);
        long _193_x2 = _191_x1 - Byte.toUnsignedLong(_192_b2) * 0x10000000000L;
        byte _194_b3 = (byte)Long.divideUnsigned(_193_x2, 0x100000000L);
        long _195_x3 = _193_x2 - Byte.toUnsignedLong(_194_b3) * 0x100000000L;
        byte _196_b4 = (byte)Long.divideUnsigned(_195_x3, 0x1000000L);
        long _197_x4 = _195_x3 - Byte.toUnsignedLong(_196_b4) * 0x1000000L;
        byte _198_b5 = (byte)Long.divideUnsigned(_197_x4, 65536L);
        long _199_x5 = _197_x4 - Byte.toUnsignedLong(_198_b5) * 65536L;
        byte _200_b6 = (byte)Long.divideUnsigned(_199_x5, 256L);
        byte _201_b7 = (byte)Long.remainderUnsigned(_199_x5, 256L);
        return DafnySequence.of((byte[])new byte[]{_188_b0, _190_b1, _192_b2, _194_b3, _196_b4, _198_b5, _200_b6, _201_b7});
    }

    public static long SeqToUInt64(DafnySequence<? extends Byte> s) {
        long _202_x0 = Byte.toUnsignedLong((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.ZERO))) * 0x100000000000000L;
        long _203_x1 = _202_x0 + Byte.toUnsignedLong((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.ONE))) * 0x1000000000000L;
        long _204_x2 = _203_x1 + Byte.toUnsignedLong((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(2L)))) * 0x10000000000L;
        long _205_x3 = _204_x2 + Byte.toUnsignedLong((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(3L)))) * 0x100000000L;
        long _206_x4 = _205_x3 + Byte.toUnsignedLong((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(4L)))) * 0x1000000L;
        long _207_x5 = _206_x4 + Byte.toUnsignedLong((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(5L)))) * 65536L;
        long _208_x6 = _207_x5 + Byte.toUnsignedLong((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(6L)))) * 256L;
        long _209_x = _208_x6 + Byte.toUnsignedLong((Byte)s.select(Helpers.toInt((BigInteger)BigInteger.valueOf(7L))));
        return _209_x;
    }

    public static BigInteger UINT16__LIMIT() {
        return BigInteger.valueOf(Short.toUnsignedLong(BoundedInts_Compile.__default.UINT16__MAX())).add(BigInteger.ONE);
    }

    public static BigInteger UINT32__LIMIT() {
        return BigInteger.valueOf(Integer.toUnsignedLong(BoundedInts_Compile.__default.UINT32__MAX())).add(BigInteger.ONE);
    }

    public static BigInteger UINT64__LIMIT() {
        return Helpers.unsignedLongToBigInteger((long)BoundedInts_Compile.__default.UINT64__MAX()).add(BigInteger.ONE);
    }

    public static BigInteger INT32__MAX__LIMIT() {
        return BigInteger.valueOf(BoundedInts_Compile.__default.INT32__MAX());
    }

    public static BigInteger INT64__MAX__LIMIT() {
        return BigInteger.valueOf(BoundedInts_Compile.__default.INT64__MAX());
    }

    public String toString() {
        return "StandardLibrary.UInt._default";
    }
}

