/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.internaldafny.types;

import BoundedInts_Compile.uint8;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.primitives.internaldafny.types.RSAPaddingMode;

public class RSAEncryptInput {
    public RSAPaddingMode _padding;
    public DafnySequence<? extends Byte> _publicKey;
    public DafnySequence<? extends Byte> _plaintext;
    private static final RSAEncryptInput theDefault = RSAEncryptInput.create(RSAPaddingMode.Default(), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()));
    private static final TypeDescriptor<RSAEncryptInput> _TYPE = TypeDescriptor.referenceWithInitializer(RSAEncryptInput.class, () -> RSAEncryptInput.Default());

    public RSAEncryptInput(RSAPaddingMode padding, DafnySequence<? extends Byte> publicKey, DafnySequence<? extends Byte> plaintext) {
        this._padding = padding;
        this._publicKey = publicKey;
        this._plaintext = plaintext;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        RSAEncryptInput o = (RSAEncryptInput)other;
        return Objects.equals(this._padding, o._padding) && Objects.equals(this._publicKey, o._publicKey) && Objects.equals(this._plaintext, o._plaintext);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._padding);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._publicKey);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._plaintext);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("software.amazon.cryptography.primitives.internaldafny.types_Compile.RSAEncryptInput.RSAEncryptInput");
        s.append("(");
        s.append(Helpers.toString((Object)this._padding));
        s.append(", ");
        s.append(Helpers.toString(this._publicKey));
        s.append(", ");
        s.append(Helpers.toString(this._plaintext));
        s.append(")");
        return s.toString();
    }

    public static RSAEncryptInput Default() {
        return theDefault;
    }

    public static TypeDescriptor<RSAEncryptInput> _typeDescriptor() {
        return _TYPE;
    }

    public static RSAEncryptInput create(RSAPaddingMode padding, DafnySequence<? extends Byte> publicKey, DafnySequence<? extends Byte> plaintext) {
        return new RSAEncryptInput(padding, publicKey, plaintext);
    }

    public static RSAEncryptInput create_RSAEncryptInput(RSAPaddingMode padding, DafnySequence<? extends Byte> publicKey, DafnySequence<? extends Byte> plaintext) {
        return RSAEncryptInput.create(padding, publicKey, plaintext);
    }

    public boolean is_RSAEncryptInput() {
        return true;
    }

    public RSAPaddingMode dtor_padding() {
        return this._padding;
    }

    public DafnySequence<? extends Byte> dtor_publicKey() {
        return this._publicKey;
    }

    public DafnySequence<? extends Byte> dtor_plaintext() {
        return this._plaintext;
    }
}

