/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.internaldafny.types;

import BoundedInts_Compile.uint8;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;

public class DigestInput {
    public DigestAlgorithm _digestAlgorithm;
    public DafnySequence<? extends Byte> _message;
    private static final DigestInput theDefault = DigestInput.create(DigestAlgorithm.Default(), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()));
    private static final TypeDescriptor<DigestInput> _TYPE = TypeDescriptor.referenceWithInitializer(DigestInput.class, () -> DigestInput.Default());

    public DigestInput(DigestAlgorithm digestAlgorithm, DafnySequence<? extends Byte> message) {
        this._digestAlgorithm = digestAlgorithm;
        this._message = message;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        DigestInput o = (DigestInput)other;
        return Objects.equals(this._digestAlgorithm, o._digestAlgorithm) && Objects.equals(this._message, o._message);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._digestAlgorithm);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._message);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("software.amazon.cryptography.primitives.internaldafny.types_Compile.DigestInput.DigestInput");
        s.append("(");
        s.append(Helpers.toString((Object)this._digestAlgorithm));
        s.append(", ");
        s.append(Helpers.toString(this._message));
        s.append(")");
        return s.toString();
    }

    public static DigestInput Default() {
        return theDefault;
    }

    public static TypeDescriptor<DigestInput> _typeDescriptor() {
        return _TYPE;
    }

    public static DigestInput create(DigestAlgorithm digestAlgorithm, DafnySequence<? extends Byte> message) {
        return new DigestInput(digestAlgorithm, message);
    }

    public static DigestInput create_DigestInput(DigestAlgorithm digestAlgorithm, DafnySequence<? extends Byte> message) {
        return DigestInput.create(digestAlgorithm, message);
    }

    public boolean is_DigestInput() {
        return true;
    }

    public DigestAlgorithm dtor_digestAlgorithm() {
        return this._digestAlgorithm;
    }

    public DafnySequence<? extends Byte> dtor_message() {
        return this._message;
    }
}

