/*
 * Decompiled with CFR 0.152.
 */
package StormTracker_Compile;

import BoundedInts_Compile.uint8;
import DafnyLibraries.MutableMap;
import LocalCMC_Compile.LocalCMC;
import StormTracker_Compile.CacheState;
import Time.__default;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.DafnySet;
import dafny.Helpers;
import dafny.Tuple0;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.CountingNumber;
import software.amazon.cryptography.materialproviders.internaldafny.types.DeleteCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.PositiveLong;
import software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.StormTrackingCache;
import software.amazon.cryptography.materialproviders.internaldafny.types.UpdateUsageMetadataInput;

public class StormTracker {
    public LocalCMC wrapped = null;
    public MutableMap<DafnySequence<? extends Byte>, Long> inFlight = null;
    public long gracePeriod = 0L;
    public long graceInterval = 0L;
    public long fanOut = 0L;
    public long inFlightTTL = 0L;
    public long lastPrune = 0L;
    public long sleepMilli = 0L;
    private static final TypeDescriptor<StormTracker> _TYPE = TypeDescriptor.referenceWithInitializer(StormTracker.class, () -> null);

    public void __ctor(StormTrackingCache cache) {
        LocalCMC _nw30 = new LocalCMC();
        _nw30.__ctor(BigInteger.valueOf(cache.dtor_entryCapacity()), BigInteger.valueOf(cache.dtor_entryPruningTailSize().UnwrapOr(CountingNumber._typeDescriptor(), 1).intValue()));
        this.wrapped = _nw30;
        MutableMap _nw31 = new MutableMap(DafnySequence._typeDescriptor(uint8._typeDescriptor()), PositiveLong._typeDescriptor());
        this.inFlight = _nw31;
        this.gracePeriod = cache.dtor_gracePeriod();
        this.graceInterval = cache.dtor_graceInterval();
        this.fanOut = cache.dtor_fanOut();
        this.inFlightTTL = cache.dtor_inFlightTTL();
        this.sleepMilli = cache.dtor_sleepMilli();
        this.lastPrune = 0L;
    }

    public long InFlightSize() {
        BigInteger _600_x = this.inFlight.Size();
        if (_600_x.compareTo(StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT()) <= 0) {
            return _600_x.longValue();
        }
        return StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT().longValue();
    }

    public boolean FanOutReached(long now) {
        boolean res = false;
        this.PruneInFlight(now);
        res = this.fanOut <= this.InFlightSize();
        return res;
    }

    public long AddLong(long x, long y) {
        if (x < StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT().longValue() - y) {
            return x + y;
        }
        return StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT().longValue();
    }

    public CacheState CheckInFlight(DafnySequence<? extends Byte> identifier, GetCacheEntryOutput result, long now) {
        CacheState _out86;
        CacheState output = CacheState.Default();
        boolean _out85 = this.FanOutReached(now);
        boolean _601_fanOutReached = _out85;
        if (_601_fanOutReached) {
            output = CacheState.create_Full(result);
            return output;
        }
        if (result.dtor_expiryTime() > now) {
            long _602_entry;
            if (now < result.dtor_expiryTime() - this.gracePeriod) {
                output = CacheState.create_Full(result);
                return output;
            }
            if (this.inFlight.HasKey(identifier) && this.AddLong(_602_entry = this.inFlight.Select(identifier).longValue(), this.graceInterval) > now) {
                output = CacheState.create_Full(result);
                return output;
            }
            this.inFlight.Put(identifier, now);
            output = CacheState.create_EmptyFetch();
            return output;
        }
        output = _out86 = this.CheckNewEntry(identifier, now);
        return output;
    }

    public void PruneInFlight(long now) {
        if (this.fanOut > this.InFlightSize()) {
            return;
        }
        if (this.lastPrune == now) {
            return;
        }
        this.lastPrune = now;
        DafnySet<DafnySequence<? extends Byte>> _603_keySet = this.inFlight.Keys();
        DafnySequence<DafnySequence<? extends Byte>> _604_keys = SortedSets.__default.SetToSequence(DafnySequence._typeDescriptor(uint8._typeDescriptor()), _603_keySet);
        BigInteger _hi7 = BigInteger.valueOf(_604_keys.length());
        BigInteger _605_i = BigInteger.ZERO;
        while (_605_i.compareTo(_hi7) < 0) {
            long _606_v = this.inFlight.Select((DafnySequence<? extends Byte>)((DafnySequence)_604_keys.select(Helpers.toInt((BigInteger)_605_i))));
            if (now >= this.AddLong(_606_v, this.inFlightTTL)) {
                this.inFlight.Remove((DafnySequence<? extends Byte>)((DafnySequence)_604_keys.select(Helpers.toInt((BigInteger)_605_i))));
            }
            _605_i = _605_i.add(BigInteger.ONE);
        }
    }

    public CacheState CheckNewEntry(DafnySequence<? extends Byte> identifier, long now) {
        long _608_entry;
        CacheState output = CacheState.Default();
        boolean _out87 = this.FanOutReached(now);
        boolean _607_fanOutReached = _out87;
        if (_607_fanOutReached) {
            output = CacheState.create_EmptyWait();
            return output;
        }
        if (this.inFlight.HasKey(identifier) && this.AddLong(_608_entry = this.inFlight.Select(identifier).longValue(), this.graceInterval) > now) {
            output = CacheState.create_EmptyWait();
            return output;
        }
        this.inFlight.Put(identifier, now);
        output = CacheState.create_EmptyFetch();
        return output;
    }

    public Result<CacheState, Error> GetFromCacheWithTime(GetCacheEntryInput input, long now) {
        Result<CacheState, Error> output = Result.Default(CacheState.Default());
        Result<GetCacheEntryOutput, Error> _out88 = this.wrapped.GetCacheEntryWithTime(input, now);
        Result<GetCacheEntryOutput, Error> _609_result = _out88;
        if (_609_result.is_Success()) {
            CacheState _out89;
            CacheState _610_newResult = _out89 = this.CheckInFlight(input.dtor_identifier(), _609_result.dtor_value(), now);
            output = Result.create_Success(_610_newResult);
            return output;
        }
        if (_609_result.dtor_error().is_EntryDoesNotExist()) {
            CacheState _out90;
            CacheState _611_newResult = _out90 = this.CheckNewEntry(input.dtor_identifier(), now);
            output = Result.create_Success(_611_newResult);
            return output;
        }
        output = Result.create_Failure(_609_result.dtor_error());
        return output;
    }

    public Result<CacheState, Error> GetFromCache(GetCacheEntryInput input) {
        long _out91;
        Result<CacheState, Error> output = Result.Default(CacheState.Default());
        long _612_now = _out91 = __default.CurrentRelativeTime().longValue();
        Result<CacheState, Error> _out92 = this.GetFromCacheWithTime(input, _612_now);
        output = _out92;
        return output;
    }

    public Result<GetCacheEntryOutput, Error> GetCacheEntry(GetCacheEntryInput input) {
        Result<GetCacheEntryOutput, Error> output = null;
        Result<CacheState, Error> _out93 = this.GetFromCache(input);
        Result<CacheState, Error> _613_result = _out93;
        if (_613_result.is_Failure()) {
            output = Result.create_Failure(_613_result.dtor_error());
            return output;
        }
        if (_613_result.dtor_value().is_Full()) {
            output = Result.create_Success(_613_result.dtor_value().dtor_data());
            return output;
        }
        output = Result.create_Failure(Error.create_EntryDoesNotExist((DafnySequence<? extends Character>)DafnySequence.asString((String)"Entry does not exist")));
        return output;
    }

    public Result<Tuple0, Error> PutCacheEntry(PutCacheEntryInput input) {
        Result<Tuple0, Error> output = Result.Default(Tuple0.Default());
        this.inFlight.Remove(input.dtor_identifier());
        Result<Tuple0, Error> _out94 = this.wrapped.PutCacheEntry_k(input);
        output = _out94;
        return output;
    }

    public Result<Tuple0, Error> DeleteCacheEntry(DeleteCacheEntryInput input) {
        Result<Tuple0, Error> output = Result.Default(Tuple0.Default());
        this.inFlight.Remove(input.dtor_identifier());
        Result<Tuple0, Error> _out95 = this.wrapped.DeleteCacheEntry_k(input);
        output = _out95;
        return output;
    }

    public Result<Tuple0, Error> UpdateUsageMetadata(UpdateUsageMetadataInput input) {
        Result<Tuple0, Error> output = Result.Default(Tuple0.Default());
        Result<Tuple0, Error> _out96 = this.wrapped.UpdateUsageMetadata_k(input);
        output = _out96;
        return output;
    }

    public static TypeDescriptor<StormTracker> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "StormTracker_Compile.StormTracker";
    }
}

