/*
 * Decompiled with CFR 0.152.
 */
package Materials_Compile;

import BoundedInts_Compile.uint8;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.DafnySet;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import java.util.function.Function;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.ECDSA;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.InitializeDecryptionMaterialsInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.InitializeEncryptionMaterialsInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.None;
import software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm;
import software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm_ECDSA;
import software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm_None;

public class __default {
    private static final TypeDescriptor<__default> _TYPE = TypeDescriptor.referenceWithInitializer(__default.class, () -> null);

    public static Result<EncryptionMaterials, Error> InitializeEncryptionMaterials(InitializeEncryptionMaterialsInput input) {
        InitializeEncryptionMaterialsInput _pat_let_tv0 = input;
        InitializeEncryptionMaterialsInput _pat_let_tv1 = input;
        InitializeEncryptionMaterialsInput _pat_let_tv2 = input;
        Outcome<Error> _13_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), !input.dtor_encryptionContext().contains(__default.EC__PUBLIC__KEY__FIELD()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Encryption Context ")));
        if (_13_valueOrError0.IsFailure(Error._typeDescriptor())) {
            return _13_valueOrError0.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _14_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), ((Function<InitializeEncryptionMaterialsInput, Boolean>)_15_input -> Helpers.Quantifier((Iterable)_15_input.dtor_requiredEncryptionContextKeys().UniqueElements(), (boolean)true, _forall_var_0_boxed0 -> {
            DafnySequence _forall_var_0;
            DafnySequence _16_key = _forall_var_0 = _forall_var_0_boxed0;
            return !_15_input.dtor_requiredEncryptionContextKeys().contains((Object)_16_key) || _15_input.dtor_encryptionContext().contains((Object)_16_key);
        })).apply(input), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Required encryption context keys do not exist in provided encryption context.")));
        if (_14_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _14_valueOrError1.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        AlgorithmSuiteInfo _17_suite = AlgorithmSuites_Compile.__default.GetSuite(input.dtor_algorithmSuiteId());
        Outcome<Error> _18_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _17_suite.dtor_signature().is_ECDSA() == (input.dtor_signingKey().is_Some() && input.dtor_verificationKey().is_Some()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Missing signature key for signed suite.")));
        if (_18_valueOrError2.IsFailure(Error._typeDescriptor())) {
            return _18_valueOrError2.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _19_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _17_suite.dtor_signature().is_None() == (input.dtor_signingKey().is_None() && input.dtor_verificationKey().is_None()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Signature key not allowed for non-signed suites.")));
        if (_19_valueOrError3.IsFailure(Error._typeDescriptor())) {
            return _19_valueOrError3.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Result _20_valueOrError4 = ((Function<SignatureAlgorithm, Result>)_source7_boxed0 -> {
            SignatureAlgorithm _source7 = _source7_boxed0;
            if (_source7.is_ECDSA()) {
                ECDSA _21___mcc_h0 = ((SignatureAlgorithm_ECDSA)_source7)._ECDSA;
                return (Result)Helpers.Let((Object)_21___mcc_h0, boxed0 -> {
                    ECDSA _pat_let0_0 = boxed0;
                    return (Result)Helpers.Let((Object)_pat_let0_0, boxed1 -> {
                        ECDSA _22_curve = boxed1;
                        return (Result)Helpers.Let(UTF8.__default.Encode(Base64_Compile.__default.Encode(_pat_let_tv0.dtor_verificationKey().dtor_value())).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _23_e_boxed0 -> {
                            DafnySequence _23_e = _23_e_boxed0;
                            return Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_23_e);
                        }), boxed2 -> {
                            Result _pat_let1_0 = boxed2;
                            return (Result)Helpers.Let((Object)_pat_let1_0, boxed3 -> {
                                Result _24_valueOrError5 = boxed3;
                                return _24_valueOrError5.IsFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor()) ? _24_valueOrError5.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor(), DafnyMap._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor())) : (Result)Helpers.Let(_24_valueOrError5.Extract(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor()), boxed4 -> {
                                    DafnySequence _pat_let2_0 = boxed4;
                                    return (Result)Helpers.Let((Object)_pat_let2_0, boxed5 -> {
                                        DafnySequence _25_enc__vk = boxed5;
                                        return Result.create_Success(DafnyMap.update(_pat_let_tv1.dtor_encryptionContext(), __default.EC__PUBLIC__KEY__FIELD(), (Object)_25_enc__vk));
                                    });
                                });
                            });
                        });
                    });
                });
            }
            None _26___mcc_h2 = ((SignatureAlgorithm_None)_source7)._None;
            return (Result)Helpers.Let((Object)_17_suite.dtor_signature(), boxed6 -> {
                SignatureAlgorithm _pat_let3_0 = boxed6;
                return (Result)Helpers.Let((Object)_pat_let3_0, boxed7 -> {
                    SignatureAlgorithm _27_None = boxed7;
                    return Result.create_Success(_pat_let_tv2.dtor_encryptionContext());
                });
            });
        }).apply(_17_suite.dtor_signature());
        if (_20_valueOrError4.IsFailure(DafnyMap._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()), Error._typeDescriptor())) {
            return _20_valueOrError4.PropagateFailure(DafnyMap._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()), Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        DafnyMap _28_encryptionContext = (DafnyMap)_20_valueOrError4.Extract(DafnyMap._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()), Error._typeDescriptor());
        return Result.create_Success(EncryptionMaterials.create(_17_suite, (DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>)_28_encryptionContext, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.empty(EncryptedDataKey._typeDescriptor()), input.dtor_requiredEncryptionContextKeys(), Option.create_None(), input.dtor_signingKey(), _17_suite.dtor_symmetricSignature().is_None() ? Option.create_None() : Option.create_Some(DafnySequence.empty((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor())))));
    }

    public static Result<DecryptionMaterials, Error> InitializeDecryptionMaterials(InitializeDecryptionMaterialsInput input) {
        Outcome<Error> _29_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), ((Function<InitializeDecryptionMaterialsInput, Boolean>)_30_input -> Helpers.Quantifier((Iterable)_30_input.dtor_requiredEncryptionContextKeys().UniqueElements(), (boolean)true, _forall_var_1_boxed0 -> {
            DafnySequence _forall_var_1;
            DafnySequence _31_key = _forall_var_1 = _forall_var_1_boxed0;
            return !_30_input.dtor_requiredEncryptionContextKeys().contains((Object)_31_key) || _30_input.dtor_encryptionContext().contains((Object)_31_key);
        })).apply(input), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Reporoduced encryption context key did not exist in provided encryption context.")));
        if (_29_valueOrError0.IsFailure(Error._typeDescriptor())) {
            return _29_valueOrError0.PropagateFailure(Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        AlgorithmSuiteInfo _32_suite = AlgorithmSuites_Compile.__default.GetSuite(input.dtor_algorithmSuiteId());
        Outcome<Error> _33_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _32_suite.dtor_signature().is_ECDSA() == input.dtor_encryptionContext().contains(__default.EC__PUBLIC__KEY__FIELD()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Encryption Context missing verification key.")));
        if (_33_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _33_valueOrError1.PropagateFailure(Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _34_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _32_suite.dtor_signature().is_None() == !input.dtor_encryptionContext().contains(__default.EC__PUBLIC__KEY__FIELD()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Verification key can not exist in non-signed Algorithm Suites.")));
        if (_34_valueOrError2.IsFailure(Error._typeDescriptor())) {
            return _34_valueOrError2.PropagateFailure(Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        Result<Option<DafnySequence<? extends Byte>>, Error> _35_valueOrError3 = __default.DecodeVerificationKey(input.dtor_encryptionContext());
        if (_35_valueOrError3.IsFailure(Option._typeDescriptor(DafnySequence._typeDescriptor(uint8._typeDescriptor())), Error._typeDescriptor())) {
            return _35_valueOrError3.PropagateFailure(Option._typeDescriptor(DafnySequence._typeDescriptor(uint8._typeDescriptor())), Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        Option<DafnySequence<? extends Byte>> _36_verificationKey = _35_valueOrError3.Extract(Option._typeDescriptor(DafnySequence._typeDescriptor(uint8._typeDescriptor())), Error._typeDescriptor());
        return Result.create_Success(DecryptionMaterials.create(_32_suite, input.dtor_encryptionContext(), input.dtor_requiredEncryptionContextKeys(), Option.create_None(), _36_verificationKey, Option.create_None()));
    }

    public static Result<Option<DafnySequence<? extends Byte>>, Error> DecodeVerificationKey(DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> encryptionContext) {
        if (encryptionContext.contains(__default.EC__PUBLIC__KEY__FIELD())) {
            DafnySequence _37_utf8Key = (DafnySequence)encryptionContext.get(__default.EC__PUBLIC__KEY__FIELD());
            Result<DafnySequence<? extends Character>, Error> _38_valueOrError0 = UTF8.__default.Decode((DafnySequence<? extends Byte>)_37_utf8Key).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _39_e_boxed0 -> {
                DafnySequence _39_e = _39_e_boxed0;
                return Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_39_e);
            });
            if (_38_valueOrError0.IsFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                return _38_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), Option._typeDescriptor(DafnySequence._typeDescriptor(uint8._typeDescriptor())));
            }
            DafnySequence<? extends Character> _40_base64Key = _38_valueOrError0.Extract((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
            Result<DafnySequence<? extends Byte>, Error> _41_valueOrError1 = Base64_Compile.__default.Decode(_40_base64Key).MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _42_e_boxed0 -> {
                DafnySequence _42_e = _42_e_boxed0;
                return Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_42_e);
            });
            if (_41_valueOrError1.IsFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
                return _41_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), Option._typeDescriptor(DafnySequence._typeDescriptor(uint8._typeDescriptor())));
            }
            DafnySequence<? extends Byte> _43_key = _41_valueOrError1.Extract((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
            return Result.create_Success(Option.create_Some(_43_key));
        }
        return Result.create_Success(Option.create_None());
    }

    public static boolean ValidEncryptionMaterialsTransition(EncryptionMaterials oldMat, EncryptionMaterials newMat) {
        return Objects.equals(newMat.dtor_algorithmSuite(), oldMat.dtor_algorithmSuite()) && newMat.dtor_encryptionContext().equals(oldMat.dtor_encryptionContext()) && newMat.dtor_requiredEncryptionContextKeys().equals(oldMat.dtor_requiredEncryptionContextKeys()) && Objects.equals(newMat.dtor_signingKey(), oldMat.dtor_signingKey()) && (oldMat.dtor_plaintextDataKey().is_None() && newMat.dtor_plaintextDataKey().is_Some() || Objects.equals(oldMat.dtor_plaintextDataKey(), newMat.dtor_plaintextDataKey())) && newMat.dtor_plaintextDataKey().is_Some() && BigInteger.valueOf(oldMat.dtor_encryptedDataKeys().length()).compareTo(BigInteger.valueOf(newMat.dtor_encryptedDataKeys().length())) <= 0 && oldMat.dtor_encryptedDataKeys().asDafnyMultiset().isSubsetOf(newMat.dtor_encryptedDataKeys().asDafnyMultiset()) && (oldMat.dtor_algorithmSuite().dtor_symmetricSignature().is_None() || newMat.dtor_symmetricSigningKeys().is_Some() && oldMat.dtor_symmetricSigningKeys().is_Some() && oldMat.dtor_symmetricSigningKeys().dtor_value().asDafnyMultiset().isSubsetOf(newMat.dtor_symmetricSigningKeys().dtor_value().asDafnyMultiset())) && __default.ValidEncryptionMaterials(oldMat) && __default.ValidEncryptionMaterials(newMat);
    }

    public static boolean ValidEncryptionMaterials(EncryptionMaterials encryptionMaterials) {
        EncryptionMaterials _pat_let_tv3 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv4 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv5 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv6 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv7 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv8 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv9 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv10 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv11 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv12 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv13 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv14 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv15 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv16 = encryptionMaterials;
        return AlgorithmSuites_Compile.__default.AlgorithmSuite_q(encryptionMaterials.dtor_algorithmSuite()) && (Boolean)Helpers.Let((Object)encryptionMaterials.dtor_algorithmSuite(), boxed8 -> {
            AlgorithmSuiteInfo _pat_let4_0 = boxed8;
            return (boolean)((Boolean)Helpers.Let((Object)_pat_let4_0, boxed9 -> {
                AlgorithmSuiteInfo _44_suite = boxed9;
                return !(_44_suite.dtor_signature().is_None() != _pat_let_tv3.dtor_signingKey().is_None() || _pat_let_tv4.dtor_plaintextDataKey().is_Some() && !Objects.equals(BigInteger.valueOf(AlgorithmSuites_Compile.__default.GetEncryptKeyLength(_44_suite)), BigInteger.valueOf(_pat_let_tv5.dtor_plaintextDataKey().dtor_value().length())) || _pat_let_tv6.dtor_plaintextDataKey().is_None() && BigInteger.valueOf(_pat_let_tv7.dtor_encryptedDataKeys().length()).signum() != 0 || !_44_suite.dtor_signature().is_None() != _pat_let_tv8.dtor_encryptionContext().contains(__default.EC__PUBLIC__KEY__FIELD()) || _44_suite.dtor_signature().is_ECDSA() != _pat_let_tv9.dtor_signingKey().is_Some() || !_44_suite.dtor_signature().is_None() != _pat_let_tv10.dtor_encryptionContext().contains(__default.EC__PUBLIC__KEY__FIELD()) || _44_suite.dtor_symmetricSignature().is_HMAC() && _pat_let_tv11.dtor_symmetricSigningKeys().is_Some() && !Objects.equals(BigInteger.valueOf(_pat_let_tv12.dtor_symmetricSigningKeys().dtor_value().length()), BigInteger.valueOf(_pat_let_tv13.dtor_encryptedDataKeys().length())) || _44_suite.dtor_symmetricSignature().is_HMAC() && !_pat_let_tv14.dtor_symmetricSigningKeys().is_Some() || _44_suite.dtor_symmetricSignature().is_None() && !_pat_let_tv15.dtor_symmetricSigningKeys().is_None() || ((Function<EncryptionMaterials, Boolean>)_45_encryptionMaterials -> Helpers.Quantifier((Iterable)_45_encryptionMaterials.dtor_requiredEncryptionContextKeys().UniqueElements(), (boolean)true, _forall_var_2_boxed0 -> {
                    DafnySequence _forall_var_2;
                    DafnySequence _46_key = _forall_var_2 = _forall_var_2_boxed0;
                    return !_45_encryptionMaterials.dtor_requiredEncryptionContextKeys().contains((Object)_46_key) || _45_encryptionMaterials.dtor_encryptionContext().contains((Object)_46_key);
                })).apply(_pat_let_tv16) == false);
            }));
        }) != false;
    }

    public static boolean EncryptionMaterialsHasPlaintextDataKey(EncryptionMaterials encryptionMaterials) {
        return encryptionMaterials.dtor_plaintextDataKey().is_Some() && BigInteger.valueOf(encryptionMaterials.dtor_encryptedDataKeys().length()).signum() == 1 && __default.ValidEncryptionMaterials(encryptionMaterials);
    }

    public static Result<EncryptionMaterials, Error> EncryptionMaterialAddEncryptedDataKeys(EncryptionMaterials encryptionMaterials, DafnySequence<? extends EncryptedDataKey> encryptedDataKeysToAdd, Option<DafnySequence<? extends DafnySequence<? extends Byte>>> symmetricSigningKeysToAdd) {
        Outcome<Error> _47_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), __default.ValidEncryptionMaterials(encryptionMaterials), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Attempt to modify invalid encryption material.")));
        if (_47_valueOrError0.IsFailure(Error._typeDescriptor())) {
            return _47_valueOrError0.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _48_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), encryptionMaterials.dtor_plaintextDataKey().is_Some(), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Adding encrypted data keys without a plaintext data key is not allowed.")));
        if (_48_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _48_valueOrError1.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _49_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), !symmetricSigningKeysToAdd.is_None() || encryptionMaterials.dtor_algorithmSuite().dtor_symmetricSignature().is_None(), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Adding encrypted data keys without a symmetric signing key when using symmetric signing is not allowed.")));
        if (_49_valueOrError2.IsFailure(Error._typeDescriptor())) {
            return _49_valueOrError2.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _50_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), !symmetricSigningKeysToAdd.is_Some() || !encryptionMaterials.dtor_algorithmSuite().dtor_symmetricSignature().is_None(), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Adding encrypted data keys with a symmetric signing key when not using symmetric signing is not allowed.")));
        if (_50_valueOrError3.IsFailure(Error._typeDescriptor())) {
            return _50_valueOrError3.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _51_symmetricSigningKeys = symmetricSigningKeysToAdd.is_None() ? encryptionMaterials.dtor_symmetricSigningKeys() : Option.create_Some(DafnySequence.concatenate(encryptionMaterials.dtor_symmetricSigningKeys().dtor_value(), symmetricSigningKeysToAdd.dtor_value()));
        return Result.create_Success(EncryptionMaterials.create(encryptionMaterials.dtor_algorithmSuite(), encryptionMaterials.dtor_encryptionContext(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.concatenate(encryptionMaterials.dtor_encryptedDataKeys(), encryptedDataKeysToAdd), encryptionMaterials.dtor_requiredEncryptionContextKeys(), encryptionMaterials.dtor_plaintextDataKey(), encryptionMaterials.dtor_signingKey(), _51_symmetricSigningKeys));
    }

    public static Result<EncryptionMaterials, Error> EncryptionMaterialAddDataKey(EncryptionMaterials encryptionMaterials, DafnySequence<? extends Byte> plaintextDataKey, DafnySequence<? extends EncryptedDataKey> encryptedDataKeysToAdd, Option<DafnySequence<? extends DafnySequence<? extends Byte>>> symmetricSigningKeysToAdd) {
        AlgorithmSuiteInfo _52_suite = encryptionMaterials.dtor_algorithmSuite();
        Outcome<Error> _53_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), __default.ValidEncryptionMaterials(encryptionMaterials), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Attempt to modify invalid encryption material.")));
        if (_53_valueOrError0.IsFailure(Error._typeDescriptor())) {
            return _53_valueOrError0.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _54_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), encryptionMaterials.dtor_plaintextDataKey().is_None(), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Attempt to modify plaintextDataKey.")));
        if (_54_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _54_valueOrError1.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _55_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Objects.equals(BigInteger.valueOf(AlgorithmSuites_Compile.__default.GetEncryptKeyLength(_52_suite)), BigInteger.valueOf(plaintextDataKey.length())), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"plaintextDataKey does not match Algorithm Suite specification.")));
        if (_55_valueOrError2.IsFailure(Error._typeDescriptor())) {
            return _55_valueOrError2.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _56_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), symmetricSigningKeysToAdd.is_None() == encryptionMaterials.dtor_algorithmSuite().dtor_symmetricSignature().is_None(), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Adding encrypted data keys without a symmetric signing key when using symmetric signing is not allowed.")));
        if (_56_valueOrError3.IsFailure(Error._typeDescriptor())) {
            return _56_valueOrError3.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _57_valueOrError4 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), symmetricSigningKeysToAdd.is_Some() == !encryptionMaterials.dtor_algorithmSuite().dtor_symmetricSignature().is_None(), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Adding encrypted data keys with a symmetric signing key when not using symmetric signing is not allowed.")));
        if (_57_valueOrError4.IsFailure(Error._typeDescriptor())) {
            return _57_valueOrError4.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _58_symmetricSigningKeys = symmetricSigningKeysToAdd.is_None() ? encryptionMaterials.dtor_symmetricSigningKeys() : Option.create_Some(DafnySequence.concatenate(encryptionMaterials.dtor_symmetricSigningKeys().dtor_value(), symmetricSigningKeysToAdd.dtor_value()));
        return Result.create_Success(EncryptionMaterials.create(encryptionMaterials.dtor_algorithmSuite(), encryptionMaterials.dtor_encryptionContext(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.concatenate(encryptionMaterials.dtor_encryptedDataKeys(), encryptedDataKeysToAdd), encryptionMaterials.dtor_requiredEncryptionContextKeys(), Option.create_Some(plaintextDataKey), encryptionMaterials.dtor_signingKey(), _58_symmetricSigningKeys));
    }

    public static boolean DecryptionMaterialsTransitionIsValid(DecryptionMaterials oldMat, DecryptionMaterials newMat) {
        return Objects.equals(newMat.dtor_algorithmSuite(), oldMat.dtor_algorithmSuite()) && newMat.dtor_encryptionContext().equals(oldMat.dtor_encryptionContext()) && newMat.dtor_requiredEncryptionContextKeys().equals(oldMat.dtor_requiredEncryptionContextKeys()) && Objects.equals(newMat.dtor_verificationKey(), oldMat.dtor_verificationKey()) && oldMat.dtor_plaintextDataKey().is_None() && newMat.dtor_plaintextDataKey().is_Some() && oldMat.dtor_symmetricSigningKey().is_None() && __default.ValidDecryptionMaterials(oldMat) && __default.ValidDecryptionMaterials(newMat);
    }

    public static boolean ValidDecryptionMaterials(DecryptionMaterials decryptionMaterials) {
        DecryptionMaterials _pat_let_tv17 = decryptionMaterials;
        DecryptionMaterials _pat_let_tv18 = decryptionMaterials;
        DecryptionMaterials _pat_let_tv19 = decryptionMaterials;
        DecryptionMaterials _pat_let_tv20 = decryptionMaterials;
        DecryptionMaterials _pat_let_tv21 = decryptionMaterials;
        DecryptionMaterials _pat_let_tv22 = decryptionMaterials;
        DecryptionMaterials _pat_let_tv23 = decryptionMaterials;
        DecryptionMaterials _pat_let_tv24 = decryptionMaterials;
        DecryptionMaterials _pat_let_tv25 = decryptionMaterials;
        return AlgorithmSuites_Compile.__default.AlgorithmSuite_q(decryptionMaterials.dtor_algorithmSuite()) && (Boolean)Helpers.Let((Object)decryptionMaterials.dtor_algorithmSuite(), boxed10 -> {
            AlgorithmSuiteInfo _pat_let5_0 = boxed10;
            return (boolean)((Boolean)Helpers.Let((Object)_pat_let5_0, boxed11 -> {
                AlgorithmSuiteInfo _59_suite = boxed11;
                return !(_pat_let_tv17.dtor_plaintextDataKey().is_Some() && !Objects.equals(BigInteger.valueOf(AlgorithmSuites_Compile.__default.GetEncryptKeyLength(_59_suite)), BigInteger.valueOf(_pat_let_tv18.dtor_plaintextDataKey().dtor_value().length())) || !_59_suite.dtor_signature().is_None() != _pat_let_tv19.dtor_encryptionContext().contains(__default.EC__PUBLIC__KEY__FIELD()) || _59_suite.dtor_signature().is_ECDSA() != _pat_let_tv20.dtor_verificationKey().is_Some() || !_59_suite.dtor_signature().is_None() != _pat_let_tv21.dtor_encryptionContext().contains(__default.EC__PUBLIC__KEY__FIELD()) || !_59_suite.dtor_symmetricSignature().is_None() && _pat_let_tv22.dtor_plaintextDataKey().is_Some() != _pat_let_tv23.dtor_symmetricSigningKey().is_Some() || _59_suite.dtor_symmetricSignature().is_None() && !_pat_let_tv24.dtor_symmetricSigningKey().is_None() || ((Function<DecryptionMaterials, Boolean>)_60_decryptionMaterials -> Helpers.Quantifier((Iterable)_60_decryptionMaterials.dtor_requiredEncryptionContextKeys().UniqueElements(), (boolean)true, _forall_var_3_boxed0 -> {
                    DafnySequence _forall_var_3;
                    DafnySequence _61_k = _forall_var_3 = _forall_var_3_boxed0;
                    return !_60_decryptionMaterials.dtor_requiredEncryptionContextKeys().contains((Object)_61_k) || _60_decryptionMaterials.dtor_encryptionContext().contains((Object)_61_k);
                })).apply(_pat_let_tv25) == false);
            }));
        }) != false;
    }

    public static Result<DecryptionMaterials, Error> DecryptionMaterialsAddDataKey(DecryptionMaterials decryptionMaterials, DafnySequence<? extends Byte> plaintextDataKey, Option<DafnySequence<? extends Byte>> symmetricSigningKey) {
        AlgorithmSuiteInfo _62_suite = decryptionMaterials.dtor_algorithmSuite();
        Outcome<Error> _63_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), __default.ValidDecryptionMaterials(decryptionMaterials), Error.create_InvalidDecryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Attempt to modify invalid decryption material.")));
        if (_63_valueOrError0.IsFailure(Error._typeDescriptor())) {
            return _63_valueOrError0.PropagateFailure(Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _64_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), decryptionMaterials.dtor_plaintextDataKey().is_None(), Error.create_InvalidDecryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Attempt to modify plaintextDataKey.")));
        if (_64_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _64_valueOrError1.PropagateFailure(Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _65_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Objects.equals(BigInteger.valueOf(AlgorithmSuites_Compile.__default.GetEncryptKeyLength(_62_suite)), BigInteger.valueOf(plaintextDataKey.length())), Error.create_InvalidDecryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"plaintextDataKey does not match Algorithm Suite specification.")));
        if (_65_valueOrError2.IsFailure(Error._typeDescriptor())) {
            return _65_valueOrError2.PropagateFailure(Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _66_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), symmetricSigningKey.is_Some() == !decryptionMaterials.dtor_algorithmSuite().dtor_symmetricSignature().is_None(), Error.create_InvalidDecryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"symmetric signature key must be added with plaintextDataKey if using an algorithm suite with symmetric signing.")));
        if (_66_valueOrError3.IsFailure(Error._typeDescriptor())) {
            return _66_valueOrError3.PropagateFailure(Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _67_valueOrError4 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), symmetricSigningKey.is_None() == decryptionMaterials.dtor_algorithmSuite().dtor_symmetricSignature().is_None(), Error.create_InvalidDecryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"symmetric signature key cannot be added with plaintextDataKey if using an algorithm suite without symmetric signing.")));
        if (_67_valueOrError4.IsFailure(Error._typeDescriptor())) {
            return _67_valueOrError4.PropagateFailure(Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        return Result.create_Success(DecryptionMaterials.create(decryptionMaterials.dtor_algorithmSuite(), decryptionMaterials.dtor_encryptionContext(), decryptionMaterials.dtor_requiredEncryptionContextKeys(), Option.create_Some(plaintextDataKey), decryptionMaterials.dtor_verificationKey(), symmetricSigningKey));
    }

    public static boolean DecryptionMaterialsWithoutPlaintextDataKey(DecryptionMaterials decryptionMaterials) {
        return decryptionMaterials.dtor_plaintextDataKey().is_None() && __default.ValidDecryptionMaterials(decryptionMaterials);
    }

    public static boolean DecryptionMaterialsWithPlaintextDataKey(DecryptionMaterials decryptionMaterials) {
        return decryptionMaterials.dtor_plaintextDataKey().is_Some() && __default.ValidDecryptionMaterials(decryptionMaterials);
    }

    public static DafnySequence<? extends Byte> EC__PUBLIC__KEY__FIELD() {
        DafnySequence _68_s = DafnySequence.of((byte[])new byte[]{97, 119, 115, 45, 99, 114, 121, 112, 116, 111, 45, 112, 117, 98, 108, 105, 99, 45, 107, 101, 121});
        return _68_s;
    }

    public static DafnySet<? extends DafnySequence<? extends Byte>> RESERVED__KEY__VALUES() {
        return DafnySet.of((Object[])new DafnySequence[]{__default.EC__PUBLIC__KEY__FIELD()});
    }

    public static TypeDescriptor<__default> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "Materials_Compile._default";
    }
}

