/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.internaldafny.types;

import BoundedInts_Compile.uint8;
import Wrappers_Compile.Option;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;

public class KdfCtrInput {
    public DigestAlgorithm _digestAlgorithm;
    public DafnySequence<? extends Byte> _ikm;
    public int _expectedLength;
    public Option<DafnySequence<? extends Byte>> _purpose;
    public Option<DafnySequence<? extends Byte>> _nonce;
    private static final KdfCtrInput theDefault = KdfCtrInput.create(DigestAlgorithm.Default(), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()), 0, Option.Default(), Option.Default());
    private static final TypeDescriptor<KdfCtrInput> _TYPE = TypeDescriptor.referenceWithInitializer(KdfCtrInput.class, () -> KdfCtrInput.Default());

    public KdfCtrInput(DigestAlgorithm digestAlgorithm, DafnySequence<? extends Byte> ikm, int expectedLength, Option<DafnySequence<? extends Byte>> purpose, Option<DafnySequence<? extends Byte>> nonce) {
        this._digestAlgorithm = digestAlgorithm;
        this._ikm = ikm;
        this._expectedLength = expectedLength;
        this._purpose = purpose;
        this._nonce = nonce;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        KdfCtrInput o = (KdfCtrInput)other;
        return Objects.equals(this._digestAlgorithm, o._digestAlgorithm) && Objects.equals(this._ikm, o._ikm) && this._expectedLength == o._expectedLength && Objects.equals(this._purpose, o._purpose) && Objects.equals(this._nonce, o._nonce);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._digestAlgorithm);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._ikm);
        hash = (hash << 5) + hash + (long)Integer.hashCode(this._expectedLength);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._purpose);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._nonce);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("software.amazon.cryptography.primitives.internaldafny.types_Compile.KdfCtrInput.KdfCtrInput");
        s.append("(");
        s.append(Helpers.toString((Object)this._digestAlgorithm));
        s.append(", ");
        s.append(Helpers.toString(this._ikm));
        s.append(", ");
        s.append(this._expectedLength);
        s.append(", ");
        s.append(Helpers.toString(this._purpose));
        s.append(", ");
        s.append(Helpers.toString(this._nonce));
        s.append(")");
        return s.toString();
    }

    public static KdfCtrInput Default() {
        return theDefault;
    }

    public static TypeDescriptor<KdfCtrInput> _typeDescriptor() {
        return _TYPE;
    }

    public static KdfCtrInput create(DigestAlgorithm digestAlgorithm, DafnySequence<? extends Byte> ikm, int expectedLength, Option<DafnySequence<? extends Byte>> purpose, Option<DafnySequence<? extends Byte>> nonce) {
        return new KdfCtrInput(digestAlgorithm, ikm, expectedLength, purpose, nonce);
    }

    public static KdfCtrInput create_KdfCtrInput(DigestAlgorithm digestAlgorithm, DafnySequence<? extends Byte> ikm, int expectedLength, Option<DafnySequence<? extends Byte>> purpose, Option<DafnySequence<? extends Byte>> nonce) {
        return KdfCtrInput.create(digestAlgorithm, ikm, expectedLength, purpose, nonce);
    }

    public boolean is_KdfCtrInput() {
        return true;
    }

    public DigestAlgorithm dtor_digestAlgorithm() {
        return this._digestAlgorithm;
    }

    public DafnySequence<? extends Byte> dtor_ikm() {
        return this._ikm;
    }

    public int dtor_expectedLength() {
        return this._expectedLength;
    }

    public Option<DafnySequence<? extends Byte>> dtor_purpose() {
        return this._purpose;
    }

    public Option<DafnySequence<? extends Byte>> dtor_nonce() {
        return this._nonce;
    }
}

