/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsMrkDiscoveryKeyring_Compile;

import Actions_Compile.__default;
import AwsKmsMrkDiscoveryKeyring_Compile.AwsKmsEncryptedDataKeyDecryptor;
import AwsKmsMrkDiscoveryKeyring_Compile.AwsKmsEncryptedDataKeyFilterTransform;
import Constants_Compile.AwsKmsEdkHelper;
import Keyring_Compile.VerifiableInterface;
import Materials_Compile.SealedDecryptionMaterials;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.Result_Failure;
import Wrappers_Compile.Result_Success;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.function.Function;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.DiscoveryFilter;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class AwsKmsMrkDiscoveryKeyring
implements VerifiableInterface,
IKeyring {
    public IKMSClient _client = null;
    public DafnySequence<? extends Character> _region = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public Option<DiscoveryFilter> _discoveryFilter = Option.Default();
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    private static final TypeDescriptor<AwsKmsMrkDiscoveryKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsMrkDiscoveryKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out55 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out55;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out56 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out56;
    }

    public void __ctor(IKMSClient client, DafnySequence<? extends Character> region, Option<DiscoveryFilter> discoveryFilter, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        this._client = client;
        this._region = region;
        this._discoveryFilter = discoveryFilter;
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> output = null;
        output = Result.create_Failure(Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Encryption is not supported with a Discovery Keyring.")));
        return output;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<Error>> _out58;
        Result output = null;
        DecryptionMaterials _474_materials = input.dtor_materials();
        DafnySequence<? extends EncryptedDataKey> _475_encryptedDataKeys = input.dtor_encryptedDataKeys();
        AlgorithmSuiteInfo _476_suite = input.dtor_materials().dtor_algorithmSuite();
        Outcome<Object> _477_valueOrError0 = Outcome.Default();
        _477_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_474_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_477_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _477_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        AwsKmsEncryptedDataKeyFilterTransform _nw14 = new AwsKmsEncryptedDataKeyFilterTransform();
        _nw14.__ctor(this.region(), this.discoveryFilter());
        AwsKmsEncryptedDataKeyFilterTransform _478_edkFilterTransform = _nw14;
        Result<Object, Object> _480_valueOrError1 = Result.Default(DafnySequence.empty(AwsKmsEdkHelper._typeDescriptor()));
        Result<DafnySequence<? extends AwsKmsEdkHelper>, Error> _out57 = __default.DeterministicFlatMapWithResult(EncryptedDataKey._typeDescriptor(), AwsKmsEdkHelper._typeDescriptor(), Error._typeDescriptor(), _478_edkFilterTransform, _475_encryptedDataKeys);
        _480_valueOrError1 = _out57;
        if (_480_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()), Error._typeDescriptor())) {
            output = _480_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        DafnySequence _479_edksToAttempt = (DafnySequence)_480_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()), Error._typeDescriptor());
        Outcome<Object> _481_valueOrError2 = Outcome.Default();
        _481_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_479_edksToAttempt.length()).signum() == 1, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unable to decrypt data key: No Encrypted Data Keys found to match.")));
        if (_481_valueOrError2.IsFailure(Error._typeDescriptor())) {
            output = _481_valueOrError2.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        AwsKmsEncryptedDataKeyDecryptor _nw15 = new AwsKmsEncryptedDataKeyDecryptor();
        _nw15.__ctor(_474_materials, this.client(), this.region(), this.grantTokens());
        AwsKmsEncryptedDataKeyDecryptor _482_decryptAction = _nw15;
        Result<DecryptionMaterials, DafnySequence<Error>> _483_outcome = _out58 = __default.ReduceToSuccess(AwsKmsEdkHelper._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _482_decryptAction, _479_edksToAttempt);
        output = ((Function<Result, Result>)_source22_boxed0 -> {
            Result _source22 = _source22_boxed0;
            if (_source22.is_Success()) {
                DecryptionMaterials _484___mcc_h0 = (DecryptionMaterials)((Result_Success)_source22)._value;
                return (Result)Helpers.Let((Object)_484___mcc_h0, boxed28 -> {
                    DecryptionMaterials _pat_let14_0 = boxed28;
                    return (Result)Helpers.Let((Object)_pat_let14_0, boxed29 -> {
                        DecryptionMaterials _485_mat = boxed29;
                        return Result.create_Success(OnDecryptOutput.create(_485_mat));
                    });
                });
            }
            DafnySequence _486___mcc_h1 = (DafnySequence)((Result_Failure)_source22)._error;
            return (Result)Helpers.Let((Object)_486___mcc_h1, boxed30 -> {
                DafnySequence _pat_let15_0 = boxed30;
                return (Result)Helpers.Let((Object)_pat_let15_0, boxed31 -> {
                    DafnySequence _487_errors = boxed31;
                    return Result.create_Failure(Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_487_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured KMS Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`.")));
                });
            });
        }).apply(_483_outcome);
        return output;
    }

    public IKMSClient client() {
        return this._client;
    }

    public DafnySequence<? extends Character> region() {
        return this._region;
    }

    public Option<DiscoveryFilter> discoveryFilter() {
        return this._discoveryFilter;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public static TypeDescriptor<AwsKmsMrkDiscoveryKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsMrkDiscoveryKeyring_Compile.AwsKmsMrkDiscoveryKeyring";
    }
}

