/*
 * Decompiled with CFR 0.152.
 */
package RawAESKeyring_Compile;

import BoundedInts_Compile.uint8;
import EdkWrapping_Compile.UnwrapEdkMaterialOutput;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import RawAESKeyring_Compile.AesGenerateAndWrapKeyMaterial;
import RawAESKeyring_Compile.AesUnwrapInfo;
import RawAESKeyring_Compile.AesUnwrapKeyMaterial;
import RawAESKeyring_Compile.AesWrapInfo;
import RawAESKeyring_Compile.AesWrapKeyMaterial;
import RawAESKeyring_Compile.__default;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.AES__GCM;

public class RawAESKeyring
implements VerifiableInterface,
IKeyring {
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public DafnySequence<? extends Byte> _wrappingKey = DafnySequence.empty(uint8._typeDescriptor());
    public AES__GCM _wrappingAlgorithm = null;
    public DafnySequence<? extends Byte> _keyNamespace = ValidUTF8Bytes.defaultValue();
    public DafnySequence<? extends Byte> _keyName = ValidUTF8Bytes.defaultValue();
    private static final TypeDescriptor<RawAESKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(RawAESKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out133 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out133;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out134 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out134;
    }

    public void __ctor(DafnySequence<? extends Byte> namespace, DafnySequence<? extends Byte> name, DafnySequence<? extends Byte> key, AES__GCM wrappingAlgorithm, AtomicPrimitivesClient cryptoPrimitives) {
        this._keyNamespace = namespace;
        this._keyName = name;
        this._wrappingKey = key;
        this._wrappingAlgorithm = wrappingAlgorithm;
        this._cryptoPrimitives = cryptoPrimitives;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> output = null;
        EncryptionMaterials _850_materials = input.dtor_materials();
        AlgorithmSuiteInfo _851_suite = _850_materials.dtor_algorithmSuite();
        AesWrapKeyMaterial _nw44 = new AesWrapKeyMaterial();
        _nw44.__ctor(this.wrappingKey(), this.wrappingAlgorithm(), this.cryptoPrimitives());
        AesWrapKeyMaterial _852_wrap = _nw44;
        AesGenerateAndWrapKeyMaterial _nw45 = new AesGenerateAndWrapKeyMaterial();
        _nw45.__ctor(_852_wrap);
        AesGenerateAndWrapKeyMaterial _853_generateAndWrap = _nw45;
        Result<WrapEdkMaterialOutput<AesWrapInfo>, Object> _855_valueOrError0 = Result.Default(WrapEdkMaterialOutput.Default(AesWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<AesWrapInfo>, Error> _out135 = EdkWrapping_Compile.__default.WrapEdkMaterial(AesWrapInfo._typeDescriptor(), _850_materials, _852_wrap, _853_generateAndWrap);
        _855_valueOrError0 = _out135;
        if (_855_valueOrError0.IsFailure(WrapEdkMaterialOutput._typeDescriptor(AesWrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            output = _855_valueOrError0.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(AesWrapInfo._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return output;
        }
        WrapEdkMaterialOutput<AesWrapInfo> _854_wrapOutput = _855_valueOrError0.Extract(WrapEdkMaterialOutput._typeDescriptor(AesWrapInfo._typeDescriptor()), Error._typeDescriptor());
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _856_symmetricSigningKeyList = _854_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_854_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None();
        EncryptedDataKey _857_edk = EncryptedDataKey.create(this.keyNamespace(), this.SerializeProviderInfo(_854_wrapOutput.dtor_wrapInfo().dtor_iv()), _854_wrapOutput.dtor_wrappedMaterial());
        if (_854_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _859_valueOrError1 = null;
            _859_valueOrError1 = Materials_Compile.__default.EncryptionMaterialAddDataKey(_850_materials, _854_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_857_edk}), _856_symmetricSigningKeyList);
            if (_859_valueOrError1.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                output = _859_valueOrError1.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return output;
            }
            EncryptionMaterials _858_result = _859_valueOrError1.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            output = Result.create_Success(OnEncryptOutput.create(_858_result));
            return output;
        }
        if (_854_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _861_valueOrError2 = null;
            _861_valueOrError2 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(_850_materials, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_857_edk}), _856_symmetricSigningKeyList);
            if (_861_valueOrError2.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                output = _861_valueOrError2.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return output;
            }
            EncryptionMaterials _860_result = _861_valueOrError2.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            output = Result.create_Success(OnEncryptOutput.create(_860_result));
            return output;
        }
        return output;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> output = null;
        DecryptionMaterials _862_materials = input.dtor_materials();
        Outcome<Object> _863_valueOrError0 = Outcome.Default();
        _863_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_862_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_863_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _863_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        Result<Object, Object> _865_valueOrError1 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _865_valueOrError1 = CanonicalEncryptionContext_Compile.__default.EncryptionContextToAAD(input.dtor_materials().dtor_encryptionContext());
        if (_865_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            output = _865_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        DafnySequence _864_aad = (DafnySequence)_865_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        Outcome<Object> _866_valueOrError2 = Outcome.Default();
        _866_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Objects.equals(BigInteger.valueOf(this.wrappingKey().length()), BigInteger.valueOf(this.wrappingAlgorithm().dtor_keyLength())), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"The wrapping key does not match the wrapping algorithm")));
        if (_866_valueOrError2.IsFailure(Error._typeDescriptor())) {
            output = _866_valueOrError2.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        DafnySequence _867_errors = DafnySequence.empty(Error._typeDescriptor());
        BigInteger _hi7 = BigInteger.valueOf(input.dtor_encryptedDataKeys().length());
        BigInteger _868_i = BigInteger.ZERO;
        while (_868_i.compareTo(_hi7) < 0) {
            if (this.ShouldDecryptEDK((EncryptedDataKey)input.dtor_encryptedDataKeys().select(Helpers.toInt((BigInteger)_868_i)))) {
                Result<UnwrapEdkMaterialOutput<AesUnwrapInfo>, Error> _out136;
                EncryptedDataKey _869_edk = (EncryptedDataKey)input.dtor_encryptedDataKeys().select(Helpers.toInt((BigInteger)_868_i));
                DafnySequence<? extends Byte> _870_iv = this.GetIvFromProvInfo(_869_edk.dtor_keyProviderInfo());
                AesUnwrapKeyMaterial _nw46 = new AesUnwrapKeyMaterial();
                _nw46.__ctor(this.wrappingKey(), this.wrappingAlgorithm(), _870_iv, this.cryptoPrimitives());
                AesUnwrapKeyMaterial _871_unwrap = _nw46;
                Result<UnwrapEdkMaterialOutput<AesUnwrapInfo>, Error> _872_unwrapOutput = _out136 = EdkWrapping_Compile.__default.UnwrapEdkMaterial(AesUnwrapInfo._typeDescriptor(), _869_edk.dtor_ciphertext(), _862_materials, _871_unwrap);
                if (_872_unwrapOutput.is_Success()) {
                    Result<DecryptionMaterials, Error> _874_valueOrError3 = null;
                    _874_valueOrError3 = Materials_Compile.__default.DecryptionMaterialsAddDataKey(_862_materials, _872_unwrapOutput.dtor_value().dtor_plaintextDataKey(), _872_unwrapOutput.dtor_value().dtor_symmetricSigningKey());
                    if (_874_valueOrError3.IsFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                        output = _874_valueOrError3.PropagateFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                        return output;
                    }
                    DecryptionMaterials _873_result = _874_valueOrError3.Extract(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
                    OnDecryptOutput _875_value = OnDecryptOutput.create(_873_result);
                    output = Result.create_Success(_875_value);
                    return output;
                }
                _867_errors = DafnySequence.concatenate((DafnySequence)_867_errors, (DafnySequence)DafnySequence.of(Error._typeDescriptor(), (Object[])new Error[]{_872_unwrapOutput.dtor_error()}));
            } else {
                _867_errors = DafnySequence.concatenate((DafnySequence)_867_errors, (DafnySequence)DafnySequence.of(Error._typeDescriptor(), (Object[])new Error[]{Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"EncrypedDataKey "), String_Compile.__default.Base10Int2String(_868_i)), (DafnySequence)DafnySequence.asString((String)" did not match AESKeyring. ")))}));
            }
            _868_i = _868_i.add(BigInteger.ONE);
        }
        output = Result.create_Failure(Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_867_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"Raw AES Keyring was unable to decrypt any encrypted data key. The list of encountered Exceptions is avaible via `list`.")));
        return output;
    }

    public DafnySequence<? extends Byte> SerializeProviderInfo(DafnySequence<? extends Byte> iv) {
        return DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(this.keyName(), StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(this.wrappingAlgorithm().dtor_tagLength() * 8)), StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(this.wrappingAlgorithm().dtor_ivLength())), iv);
    }

    public boolean ShouldDecryptEDK(EncryptedDataKey edk) {
        return edk.dtor_keyProviderId().equals(this.keyNamespace()) && this.ValidProviderInfo(edk.dtor_keyProviderInfo());
    }

    public boolean ValidProviderInfo(DafnySequence<? extends Byte> info) {
        return Objects.equals(BigInteger.valueOf(info.length()), BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN()).add(__default.IV__LEN__LEN()).add(BigInteger.valueOf(this.wrappingAlgorithm().dtor_ivLength()))) && info.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()))).equals(this.keyName()) && StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)info.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length())), Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN())))) == 128 && StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)info.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length())), Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN())))) == this.wrappingAlgorithm().dtor_tagLength() * 8 && StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)info.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN())), Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN()).add(__default.IV__LEN__LEN())))) == this.wrappingAlgorithm().dtor_ivLength() && StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)info.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN())), Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN()).add(__default.IV__LEN__LEN())))) == 12;
    }

    public DafnySequence<? extends Byte> GetIvFromProvInfo(DafnySequence<? extends Byte> info) {
        return info.drop(BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN()).add(__default.IV__LEN__LEN()));
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public DafnySequence<? extends Byte> wrappingKey() {
        return this._wrappingKey;
    }

    public AES__GCM wrappingAlgorithm() {
        return this._wrappingAlgorithm;
    }

    public DafnySequence<? extends Byte> keyNamespace() {
        return this._keyNamespace;
    }

    public DafnySequence<? extends Byte> keyName() {
        return this._keyName;
    }

    public static TypeDescriptor<RawAESKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "RawAESKeyring_Compile.RawAESKeyring";
    }
}

