/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsHierarchicalKeyring_Compile;

import AwsKmsHierarchicalKeyring_Compile.DecryptSingleEncryptedDataKey;
import AwsKmsHierarchicalKeyring_Compile.HierarchyWrapInfo;
import AwsKmsHierarchicalKeyring_Compile.KmsHierarchyGenerateAndWrapKeyMaterial;
import AwsKmsHierarchicalKeyring_Compile.KmsHierarchyWrapKeyMaterial;
import AwsKmsHierarchicalKeyring_Compile.OnDecryptHierarchyEncryptedDataKeyFilter;
import AwsKmsHierarchicalKeyring_Compile.__default;
import BoundedInts_Compile.uint8;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import LocalCMC_Compile.LocalCMC;
import Materials_Compile.SealedDecryptionMaterials;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.Tuple0;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.internaldafny.SynchronizedLocalCMC;
import software.amazon.cryptography.keystore.internaldafny.types.GetActiveBranchKeyInput;
import software.amazon.cryptography.keystore.internaldafny.types.GetActiveBranchKeyOutput;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.BranchKeyMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetBranchKeyIdInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetBranchKeyIdOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.IBranchKeyIdSupplier;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.Materials;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.DigestInput;
import software.amazon.cryptography.primitives.internaldafny.types.Error;

public class AwsKmsHierarchicalKeyring
implements VerifiableInterface,
IKeyring {
    public IKeyStoreClient _keyStore = null;
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public Option<IBranchKeyIdSupplier> _branchKeyIdSupplier = Option.Default();
    public Option<DafnySequence<? extends Character>> _branchKeyId = Option.Default();
    public long _ttlSeconds = 0L;
    public int _maxCacheSize = 0;
    public SynchronizedLocalCMC _cache = null;
    private static final TypeDescriptor<AwsKmsHierarchicalKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsHierarchicalKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out85 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out85;
    }

    @Override
    public Result<OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out86 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out86;
    }

    public void __ctor(IKeyStoreClient keyStore, Option<DafnySequence<? extends Character>> branchKeyId, Option<IBranchKeyIdSupplier> branchKeyIdSupplier, long ttlSeconds, int maxCacheSize, AtomicPrimitivesClient cryptoPrimitives) {
        SynchronizedLocalCMC _nw31;
        LocalCMC _nw30 = new LocalCMC();
        _nw30.__ctor(BigInteger.valueOf(maxCacheSize), BigInteger.ONE);
        LocalCMC _601_localCMC = _nw30;
        SynchronizedLocalCMC _602_cmc = _nw31 = new SynchronizedLocalCMC(_601_localCMC);
        this._keyStore = keyStore;
        this._branchKeyId = branchKeyId;
        this._branchKeyIdSupplier = branchKeyIdSupplier;
        this._ttlSeconds = ttlSeconds;
        this._maxCacheSize = maxCacheSize;
        this._cryptoPrimitives = cryptoPrimitives;
        this._cache = _602_cmc;
    }

    public Result<DafnySequence<? extends Character>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetBranchKeyId(DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> context) {
        Result<Object, software.amazon.cryptography.materialproviders.internaldafny.types.Error> ret = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        if (this.branchKeyId().is_Some()) {
            ret = Result.create_Success(this.branchKeyId().dtor_value());
            return ret;
        }
        Result<GetBranchKeyIdOutput, Object> _604_valueOrError0 = Result.Default(GetBranchKeyIdOutput.Default());
        Result<GetBranchKeyIdOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out87 = this.branchKeyIdSupplier().dtor_value().GetBranchKeyId(GetBranchKeyIdInput.create(context));
        _604_valueOrError0 = _out87;
        if (_604_valueOrError0.IsFailure(GetBranchKeyIdOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            ret = _604_valueOrError0.PropagateFailure(GetBranchKeyIdOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            return ret;
        }
        GetBranchKeyIdOutput _603_GetBranchKeyIdOut = _604_valueOrError0.Extract(GetBranchKeyIdOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        ret = Result.create_Success(_603_GetBranchKeyIdOut.dtor_branchKeyId());
        return ret;
    }

    @Override
    public Result<OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = null;
        EncryptionMaterials _605_materials = input.dtor_materials();
        AlgorithmSuiteInfo _606_suite = _605_materials.dtor_algorithmSuite();
        Result<Object, Object> _608_valueOrError0 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        Result<DafnySequence<? extends Character>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out88 = this.GetBranchKeyId(_605_materials.dtor_encryptionContext());
        _608_valueOrError0 = _out88;
        if (_608_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _608_valueOrError0.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _607_branchKeyIdForEncrypt = (DafnySequence)_608_valueOrError0.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<DafnySequence<? extends Byte>, Object> _610_valueOrError1 = Result.Default(ValidUTF8Bytes.defaultValue());
        _610_valueOrError1 = UTF8.__default.Encode((DafnySequence<? extends Character>)_607_branchKeyIdForEncrypt).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_610_valueOrError1.IsFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _610_valueOrError1.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence<? extends Byte> _609_branchKeyIdUtf8 = _610_valueOrError1.Extract(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<Object, Object> _612_valueOrError2 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out89 = this.GetActiveCacheId((DafnySequence<? extends Character>)_607_branchKeyIdForEncrypt, _609_branchKeyIdUtf8, this.cryptoPrimitives());
        _612_valueOrError2 = _out89;
        if (_612_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _612_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _611_cacheId = (DafnySequence)_612_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<BranchKeyMaterials, Object> _614_valueOrError3 = Result.Default(BranchKeyMaterials.Default());
        Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out90 = this.GetActiveHierarchicalMaterials((DafnySequence<? extends Character>)_607_branchKeyIdForEncrypt, (DafnySequence<? extends Byte>)_611_cacheId, this.keyStore());
        _614_valueOrError3 = _out90;
        if (_614_valueOrError3.IsFailure(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _614_valueOrError3.PropagateFailure(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        BranchKeyMaterials _613_hierarchicalMaterials = _614_valueOrError3.Extract(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        DafnySequence<? extends Byte> _615_branchKey = _613_hierarchicalMaterials.dtor_branchKey();
        DafnySequence<? extends Byte> _616_branchKeyVersion = _613_hierarchicalMaterials.dtor_branchKeyVersion();
        Result<Object, Object> _618_valueOrError4 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        _618_valueOrError4 = UTF8.__default.Decode(_616_branchKeyVersion).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_618_valueOrError4.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _618_valueOrError4.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _617_branchKeyVersionAsString = (DafnySequence)_618_valueOrError4.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<Object, Object> _620_valueOrError5 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _620_valueOrError5 = UUID.__default.ToByteArray((DafnySequence<? extends Character>)_617_branchKeyVersionAsString).MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_620_valueOrError5.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _620_valueOrError5.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _619_branchKeyVersionAsBytes = (DafnySequence)_620_valueOrError5.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        KmsHierarchyGenerateAndWrapKeyMaterial _nw32 = new KmsHierarchyGenerateAndWrapKeyMaterial();
        _nw32.__ctor(_613_hierarchicalMaterials.dtor_branchKey(), _609_branchKeyIdUtf8, (DafnySequence<? extends Byte>)_619_branchKeyVersionAsBytes, this.cryptoPrimitives());
        KmsHierarchyGenerateAndWrapKeyMaterial _621_kmsHierarchyGenerateAndWrap = _nw32;
        KmsHierarchyWrapKeyMaterial _nw33 = new KmsHierarchyWrapKeyMaterial();
        _nw33.__ctor(_613_hierarchicalMaterials.dtor_branchKey(), _609_branchKeyIdUtf8, (DafnySequence<? extends Byte>)_619_branchKeyVersionAsBytes, this.cryptoPrimitives());
        KmsHierarchyWrapKeyMaterial _622_kmsHierarchyWrap = _nw33;
        Result<WrapEdkMaterialOutput<HierarchyWrapInfo>, Object> _624_valueOrError6 = Result.Default(WrapEdkMaterialOutput.Default(HierarchyWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<HierarchyWrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out91 = EdkWrapping_Compile.__default.WrapEdkMaterial(HierarchyWrapInfo._typeDescriptor(), _605_materials, _622_kmsHierarchyWrap, _621_kmsHierarchyGenerateAndWrap);
        _624_valueOrError6 = _out91;
        if (_624_valueOrError6.IsFailure(WrapEdkMaterialOutput._typeDescriptor(HierarchyWrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _624_valueOrError6.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(HierarchyWrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        WrapEdkMaterialOutput<HierarchyWrapInfo> _623_wrapOutput = _624_valueOrError6.Extract(WrapEdkMaterialOutput._typeDescriptor(HierarchyWrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _625_symmetricSigningKeyList = _623_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_623_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None();
        EncryptedDataKey _626_edk = EncryptedDataKey.create(Constants_Compile.__default.PROVIDER__ID__HIERARCHY(), _609_branchKeyIdUtf8, _623_wrapOutput.dtor_wrappedMaterial());
        if (_623_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _628_valueOrError7 = null;
            _628_valueOrError7 = Materials_Compile.__default.EncryptionMaterialAddDataKey(_605_materials, _623_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_626_edk}), _625_symmetricSigningKeyList);
            if (_628_valueOrError7.IsFailure(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                res = _628_valueOrError7.PropagateFailure(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _627_result = _628_valueOrError7.Extract(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput.create(_627_result));
            return res;
        }
        if (_623_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _630_valueOrError8 = null;
            _630_valueOrError8 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(_605_materials, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_626_edk}), _625_symmetricSigningKeyList);
            if (_630_valueOrError8.IsFailure(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                res = _630_valueOrError8.PropagateFailure(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _629_result = _630_valueOrError8.Extract(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput.create(_629_result));
            return res;
        }
        return res;
    }

    @Override
    public Result<OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<software.amazon.cryptography.materialproviders.internaldafny.types.Error>> _out94;
        Result<OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = null;
        DecryptionMaterials _631_materials = input.dtor_materials();
        AlgorithmSuiteInfo _632_suite = input.dtor_materials().dtor_algorithmSuite();
        Outcome<Object> _633_valueOrError0 = Outcome.Default();
        _633_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_631_materials), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_633_valueOrError0.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _633_valueOrError0.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        Result<Object, Object> _635_valueOrError1 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        Result<DafnySequence<? extends Character>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out92 = this.GetBranchKeyId(_631_materials.dtor_encryptionContext());
        _635_valueOrError1 = _out92;
        if (_635_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _635_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _634_branchKeyIdForDecrypt = (DafnySequence)_635_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        OnDecryptHierarchyEncryptedDataKeyFilter _nw34 = new OnDecryptHierarchyEncryptedDataKeyFilter();
        _nw34.__ctor((DafnySequence<? extends Character>)_634_branchKeyIdForDecrypt);
        OnDecryptHierarchyEncryptedDataKeyFilter _636_filter = _nw34;
        Result<Object, Object> _638_valueOrError2 = Result.Default(DafnySequence.empty(EncryptedDataKey._typeDescriptor()));
        Result<DafnySequence<? extends EncryptedDataKey>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out93 = Actions_Compile.__default.FilterWithResult(EncryptedDataKey._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _636_filter, input.dtor_encryptedDataKeys());
        _638_valueOrError2 = _out93;
        if (_638_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _638_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _637_edksToAttempt = (DafnySequence)_638_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Outcome<Object> _639_valueOrError3 = Outcome.Default();
        _639_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BigInteger.valueOf(_637_edksToAttempt.length()).signum() == 1, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unable to decrypt data key: No Encrypted Data Keys found to match.")));
        if (_639_valueOrError3.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _639_valueOrError3.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptSingleEncryptedDataKey _nw35 = new DecryptSingleEncryptedDataKey();
        _nw35.__ctor(_631_materials, this.keyStore(), this.cryptoPrimitives(), (DafnySequence<? extends Character>)_634_branchKeyIdForDecrypt, this.ttlSeconds(), this.cache());
        DecryptSingleEncryptedDataKey _640_decryptClosure = _nw35;
        Result<DecryptionMaterials, DafnySequence<software.amazon.cryptography.materialproviders.internaldafny.types.Error>> _641_outcome = _out94 = Actions_Compile.__default.ReduceToSuccess(EncryptedDataKey._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _640_decryptClosure, _637_edksToAttempt);
        Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _643_valueOrError4 = null;
        _643_valueOrError4 = _641_outcome.MapFailure(SealedDecryptionMaterials._typeDescriptor(), (TypeDescriptor<DafnySequence<software.amazon.cryptography.materialproviders.internaldafny.types.Error>>)DafnySequence._typeDescriptor(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _644_errors_boxed0 -> {
            DafnySequence _644_errors = _644_errors_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_CollectionOfErrors((DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.Error>)_644_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured KMS Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`."));
        });
        if (_643_valueOrError4.IsFailure(SealedDecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _643_valueOrError4.PropagateFailure(SealedDecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptionMaterials _642_SealedDecryptionMaterials = _643_valueOrError4.Extract(SealedDecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        res = Result.create_Success(OnDecryptOutput.create(_642_SealedDecryptionMaterials));
        return res;
    }

    public Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetActiveCacheId(DafnySequence<? extends Character> branchKeyId, DafnySequence<? extends Byte> branchKeyIdUtf8, AtomicPrimitivesClient cryptoPrimitives) {
        Result<DafnySequence<? extends Byte>, Error> _out96;
        Result<DafnySequence<? extends Byte>, Error> _out95;
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> cacheId = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Outcome<Object> _645_valueOrError0 = Outcome.Default();
        _645_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UTF8.__default.Decode(branchKeyIdUtf8).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError).is_Success() && (Boolean)Helpers.Let(UTF8.__default.Decode(branchKeyIdUtf8).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError).dtor_value(), boxed36 -> {
            DafnySequence _pat_let18_0 = boxed36;
            return (boolean)((Boolean)Helpers.Let((Object)_pat_let18_0, boxed37 -> {
                DafnySequence _646_branchKeyId = boxed37;
                return BigInteger.valueOf(_646_branchKeyId.length()).signum() != -1 && BigInteger.valueOf(_646_branchKeyId.length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT32__LIMIT()) < 0;
            }));
        }) != false, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Branch Key ID Length")));
        if (_645_valueOrError0.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _645_valueOrError0.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence<? extends Character> _647_branchKeyId = UTF8.__default.Decode(branchKeyIdUtf8).dtor_value();
        DafnySequence<? extends Byte> _648_lenBranchKey = StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(_647_branchKeyId.cardinalityInt());
        DigestAlgorithm _649_hashAlgorithm = DigestAlgorithm.create_SHA__512();
        Result<DafnySequence<? extends Byte>, Error> _650_maybeBranchKeyDigest = _out95 = cryptoPrimitives.Digest(DigestInput.create(_649_hashAlgorithm, branchKeyIdUtf8));
        Result<Object, Object> _652_valueOrError1 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _652_valueOrError1 = _650_maybeBranchKeyDigest.MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _653_e_boxed0 -> {
            Error _653_e = _653_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_653_e);
        });
        if (_652_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _652_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence _651_branchKeyDigest = (DafnySequence)_652_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<DafnySequence<? extends Byte>, Object> _655_valueOrError2 = Result.Default(ValidUTF8Bytes.defaultValue());
        _655_valueOrError2 = UTF8.__default.Encode(__default.EXPRESSION__ATTRIBUTE__VALUE__STATUS__VALUE()).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_655_valueOrError2.IsFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _655_valueOrError2.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence<? extends Byte> _654_activeUtf8 = _655_valueOrError2.Extract(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        DafnySequence _656_identifier = DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(_648_lenBranchKey, (DafnySequence)_651_branchKeyDigest), (DafnySequence)DafnySequence.of((byte[])new byte[]{0})), _654_activeUtf8);
        Result<DafnySequence<? extends Byte>, Error> _657_maybeCacheIdDigest = _out96 = cryptoPrimitives.Digest(DigestInput.create(_649_hashAlgorithm, (DafnySequence<? extends Byte>)_656_identifier));
        Result<Object, Object> _659_valueOrError3 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _659_valueOrError3 = _657_maybeCacheIdDigest.MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _660_e_boxed0 -> {
            Error _660_e = _660_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_660_e);
        });
        if (_659_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _659_valueOrError3.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence _658_cacheDigest = (DafnySequence)_659_valueOrError3.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Outcome<Object> _661_valueOrError4 = Outcome.Default();
        _661_valueOrError4 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Objects.equals(BigInteger.valueOf(_658_cacheDigest.length()), Digest_Compile.__default.Length(_649_hashAlgorithm)), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Digest generated a message not equal to the expected length.")));
        if (_661_valueOrError4.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _661_valueOrError4.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        cacheId = Result.create_Success(_658_cacheDigest.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)BigInteger.valueOf(32L))));
        return cacheId;
    }

    public Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetActiveHierarchicalMaterials(DafnySequence<? extends Character> branchKeyId, DafnySequence<? extends Byte> cacheId, IKeyStoreClient keyStore) {
        Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> material = Result.Default(BranchKeyMaterials.Default());
        GetCacheEntryInput _662_getCacheInput = GetCacheEntryInput.create(cacheId, Option.create_None());
        Result<GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out97 = __default.getEntry(this.cache(), _662_getCacheInput);
        Result<GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _663_getCacheOutput = _out97;
        if (_663_getCacheOutput.is_Failure()) {
            long _out99;
            Result<GetActiveBranchKeyOutput, software.amazon.cryptography.keystore.internaldafny.types.Error> _out98;
            Result<GetActiveBranchKeyOutput, software.amazon.cryptography.keystore.internaldafny.types.Error> _664_maybeRawBranchKeyMaterials = _out98 = keyStore.GetActiveBranchKey(GetActiveBranchKeyInput.create(branchKeyId));
            Result<GetActiveBranchKeyOutput, Object> _666_valueOrError0 = Result.Default(GetActiveBranchKeyOutput.Default());
            _666_valueOrError0 = _664_maybeRawBranchKeyMaterials.MapFailure(GetActiveBranchKeyOutput._typeDescriptor(), software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _667_e_boxed0 -> {
                software.amazon.cryptography.keystore.internaldafny.types.Error _667_e = _667_e_boxed0;
                return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyKeyStore(_667_e);
            });
            if (_666_valueOrError0.IsFailure(GetActiveBranchKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _666_valueOrError0.PropagateFailure(GetActiveBranchKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            GetActiveBranchKeyOutput _665_rawBranchKeyMaterials = _666_valueOrError0.Extract(GetActiveBranchKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            BranchKeyMaterials _668_branchKeyMaterials = BranchKeyMaterials.create(_665_rawBranchKeyMaterials.dtor_branchKeyVersion(), _665_rawBranchKeyMaterials.dtor_branchKey());
            long _669_now = _out99 = Time.__default.CurrentRelativeTime().longValue();
            Outcome<Object> _670_valueOrError1 = Outcome.Default();
            _670_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BigInteger.valueOf(_669_now).add(BigInteger.valueOf(this.ttlSeconds())).compareTo(StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT()) < 0, software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"INT64 Overflow when putting cache entry.")));
            if (_670_valueOrError1.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _670_valueOrError1.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            PutCacheEntryInput _671_putCacheEntryInput = PutCacheEntryInput.create(cacheId, Materials.create_BranchKey(_668_branchKeyMaterials), _669_now, this.ttlSeconds() + _669_now, Option.create_None(), Option.create_None());
            Result<Tuple0, Object> _673_valueOrError2 = Result.Default(Tuple0.Default());
            Result<Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out100 = __default.putEntry(this.cache(), _671_putCacheEntryInput);
            _673_valueOrError2 = _out100;
            if (_673_valueOrError2.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _673_valueOrError2.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            Tuple0 _672___v0 = _673_valueOrError2.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            material = Result.create_Success(_668_branchKeyMaterials);
            return material;
        }
        Outcome<Object> _674_valueOrError3 = Outcome.Default();
        _674_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _663_getCacheOutput.dtor_value().dtor_materials().is_BranchKey() && Objects.equals(_663_getCacheOutput.dtor_value().dtor_materials(), Materials.create_BranchKey(_663_getCacheOutput.dtor_value().dtor_materials().dtor_BranchKey())), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Material Type.")));
        if (_674_valueOrError3.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            material = _674_valueOrError3.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
            return material;
        }
        material = Result.create_Success(_663_getCacheOutput.dtor_value().dtor_materials().dtor_BranchKey());
        return material;
    }

    public IKeyStoreClient keyStore() {
        return this._keyStore;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public Option<IBranchKeyIdSupplier> branchKeyIdSupplier() {
        return this._branchKeyIdSupplier;
    }

    public Option<DafnySequence<? extends Character>> branchKeyId() {
        return this._branchKeyId;
    }

    public long ttlSeconds() {
        return this._ttlSeconds;
    }

    public int maxCacheSize() {
        return this._maxCacheSize;
    }

    public SynchronizedLocalCMC cache() {
        return this._cache;
    }

    public static TypeDescriptor<AwsKmsHierarchicalKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsHierarchicalKeyring_Compile.AwsKmsHierarchicalKeyring";
    }
}

