/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.nio.ByteBuffer;
import java.util.Objects;

public class UpdaterUsageMetadataInput {
    private final ByteBuffer identifier;
    private final int bytesUsed;

    protected UpdaterUsageMetadataInput(BuilderImpl builder) {
        this.identifier = builder.identifier();
        this.bytesUsed = builder.bytesUsed();
    }

    public ByteBuffer identifier() {
        return this.identifier;
    }

    public int bytesUsed() {
        return this.bytesUsed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ByteBuffer identifier;
        protected int bytesUsed;
        private boolean _bytesUsedSet = false;

        protected BuilderImpl() {
        }

        protected BuilderImpl(UpdaterUsageMetadataInput model) {
            this.identifier = model.identifier();
            this.bytesUsed = model.bytesUsed();
            this._bytesUsedSet = true;
        }

        @Override
        public Builder identifier(ByteBuffer identifier) {
            this.identifier = identifier;
            return this;
        }

        @Override
        public ByteBuffer identifier() {
            return this.identifier;
        }

        @Override
        public Builder bytesUsed(int bytesUsed) {
            this.bytesUsed = bytesUsed;
            this._bytesUsedSet = true;
            return this;
        }

        @Override
        public int bytesUsed() {
            return this.bytesUsed;
        }

        @Override
        public UpdaterUsageMetadataInput build() {
            if (Objects.isNull(this.identifier())) {
                throw new IllegalArgumentException("Missing value for required field `identifier`");
            }
            if (!this._bytesUsedSet) {
                throw new IllegalArgumentException("Missing value for required field `bytesUsed`");
            }
            if (this._bytesUsedSet && this.bytesUsed() < 0) {
                throw new IllegalArgumentException("`bytesUsed` must be greater than or equal to 0");
            }
            return new UpdaterUsageMetadataInput(this);
        }
    }

    public static interface Builder {
        public Builder identifier(ByteBuffer var1);

        public ByteBuffer identifier();

        public Builder bytesUsed(int var1);

        public int bytesUsed();

        public UpdaterUsageMetadataInput build();
    }
}

