/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.List;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.CryptographicMaterialsManager;
import software.amazon.cryptography.materialproviders.ICryptographicMaterialsManager;
import software.amazon.cryptography.materialproviders.IKeyring;
import software.amazon.cryptography.materialproviders.Keyring;

public class CreateExpectedEncryptionContextCMMInput {
    private final ICryptographicMaterialsManager underlyingCMM;
    private final IKeyring keyring;
    private final List<String> requiredEncryptionContextKeys;

    protected CreateExpectedEncryptionContextCMMInput(BuilderImpl builder) {
        this.underlyingCMM = builder.underlyingCMM();
        this.keyring = builder.keyring();
        this.requiredEncryptionContextKeys = builder.requiredEncryptionContextKeys();
    }

    public ICryptographicMaterialsManager underlyingCMM() {
        return this.underlyingCMM;
    }

    public IKeyring keyring() {
        return this.keyring;
    }

    public List<String> requiredEncryptionContextKeys() {
        return this.requiredEncryptionContextKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ICryptographicMaterialsManager underlyingCMM;
        protected IKeyring keyring;
        protected List<String> requiredEncryptionContextKeys;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CreateExpectedEncryptionContextCMMInput model) {
            this.underlyingCMM = model.underlyingCMM();
            this.keyring = model.keyring();
            this.requiredEncryptionContextKeys = model.requiredEncryptionContextKeys();
        }

        @Override
        public Builder underlyingCMM(ICryptographicMaterialsManager underlyingCMM) {
            this.underlyingCMM = CryptographicMaterialsManager.wrap(underlyingCMM);
            return this;
        }

        @Override
        public ICryptographicMaterialsManager underlyingCMM() {
            return this.underlyingCMM;
        }

        @Override
        public Builder keyring(IKeyring keyring) {
            this.keyring = Keyring.wrap(keyring);
            return this;
        }

        @Override
        public IKeyring keyring() {
            return this.keyring;
        }

        @Override
        public Builder requiredEncryptionContextKeys(List<String> requiredEncryptionContextKeys) {
            this.requiredEncryptionContextKeys = requiredEncryptionContextKeys;
            return this;
        }

        @Override
        public List<String> requiredEncryptionContextKeys() {
            return this.requiredEncryptionContextKeys;
        }

        @Override
        public CreateExpectedEncryptionContextCMMInput build() {
            if (Objects.isNull(this.requiredEncryptionContextKeys())) {
                throw new IllegalArgumentException("Missing value for required field `requiredEncryptionContextKeys`");
            }
            return new CreateExpectedEncryptionContextCMMInput(this);
        }
    }

    public static interface Builder {
        public Builder underlyingCMM(ICryptographicMaterialsManager var1);

        public ICryptographicMaterialsManager underlyingCMM();

        public Builder keyring(IKeyring var1);

        public IKeyring keyring();

        public Builder requiredEncryptionContextKeys(List<String> var1);

        public List<String> requiredEncryptionContextKeys();

        public CreateExpectedEncryptionContextCMMInput build();
    }
}

