/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;

public class BeaconKeyMaterials {
    private final String beaconKeyIdentifier;
    private final ByteBuffer beaconKey;
    private final Map<String, ByteBuffer> hmacKeys;

    protected BeaconKeyMaterials(BuilderImpl builder) {
        this.beaconKeyIdentifier = builder.beaconKeyIdentifier();
        this.beaconKey = builder.beaconKey();
        this.hmacKeys = builder.hmacKeys();
    }

    public String beaconKeyIdentifier() {
        return this.beaconKeyIdentifier;
    }

    public ByteBuffer beaconKey() {
        return this.beaconKey;
    }

    public Map<String, ByteBuffer> hmacKeys() {
        return this.hmacKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String beaconKeyIdentifier;
        protected ByteBuffer beaconKey;
        protected Map<String, ByteBuffer> hmacKeys;

        protected BuilderImpl() {
        }

        protected BuilderImpl(BeaconKeyMaterials model) {
            this.beaconKeyIdentifier = model.beaconKeyIdentifier();
            this.beaconKey = model.beaconKey();
            this.hmacKeys = model.hmacKeys();
        }

        @Override
        public Builder beaconKeyIdentifier(String beaconKeyIdentifier) {
            this.beaconKeyIdentifier = beaconKeyIdentifier;
            return this;
        }

        @Override
        public String beaconKeyIdentifier() {
            return this.beaconKeyIdentifier;
        }

        @Override
        public Builder beaconKey(ByteBuffer beaconKey) {
            this.beaconKey = beaconKey;
            return this;
        }

        @Override
        public ByteBuffer beaconKey() {
            return this.beaconKey;
        }

        @Override
        public Builder hmacKeys(Map<String, ByteBuffer> hmacKeys) {
            this.hmacKeys = hmacKeys;
            return this;
        }

        @Override
        public Map<String, ByteBuffer> hmacKeys() {
            return this.hmacKeys;
        }

        @Override
        public BeaconKeyMaterials build() {
            if (Objects.isNull(this.beaconKeyIdentifier())) {
                throw new IllegalArgumentException("Missing value for required field `beaconKeyIdentifier`");
            }
            return new BeaconKeyMaterials(this);
        }
    }

    public static interface Builder {
        public Builder beaconKeyIdentifier(String var1);

        public String beaconKeyIdentifier();

        public Builder beaconKey(ByteBuffer var1);

        public ByteBuffer beaconKey();

        public Builder hmacKeys(Map<String, ByteBuffer> var1);

        public Map<String, ByteBuffer> hmacKeys();

        public BeaconKeyMaterials build();
    }
}

