/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.internaldafny.types;

import dafny.TypeDescriptor;
import software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm_HKDF;
import software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm_IDENTITY;
import software.amazon.cryptography.materialproviders.internaldafny.types.DerivationAlgorithm_None;
import software.amazon.cryptography.materialproviders.internaldafny.types.HKDF;
import software.amazon.cryptography.materialproviders.internaldafny.types.IDENTITY;
import software.amazon.cryptography.materialproviders.internaldafny.types.None;

public abstract class DerivationAlgorithm {
    private static final DerivationAlgorithm theDefault = DerivationAlgorithm.create_HKDF(HKDF.Default());
    private static final TypeDescriptor<DerivationAlgorithm> _TYPE = TypeDescriptor.referenceWithInitializer(DerivationAlgorithm.class, () -> DerivationAlgorithm.Default());

    public static DerivationAlgorithm Default() {
        return theDefault;
    }

    public static TypeDescriptor<DerivationAlgorithm> _typeDescriptor() {
        return _TYPE;
    }

    public static DerivationAlgorithm create_HKDF(HKDF HKDF2) {
        return new DerivationAlgorithm_HKDF(HKDF2);
    }

    public static DerivationAlgorithm create_IDENTITY(IDENTITY IDENTITY2) {
        return new DerivationAlgorithm_IDENTITY(IDENTITY2);
    }

    public static DerivationAlgorithm create_None(None None2) {
        return new DerivationAlgorithm_None(None2);
    }

    public boolean is_HKDF() {
        return this instanceof DerivationAlgorithm_HKDF;
    }

    public boolean is_IDENTITY() {
        return this instanceof DerivationAlgorithm_IDENTITY;
    }

    public boolean is_None() {
        return this instanceof DerivationAlgorithm_None;
    }

    public HKDF dtor_HKDF() {
        DerivationAlgorithm d = this;
        return ((DerivationAlgorithm_HKDF)d)._HKDF;
    }

    public IDENTITY dtor_IDENTITY() {
        DerivationAlgorithm d = this;
        return ((DerivationAlgorithm_IDENTITY)d)._IDENTITY;
    }

    public None dtor_None() {
        DerivationAlgorithm d = this;
        return ((DerivationAlgorithm_None)d)._None;
    }
}

