/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.keystore.internaldafny;

import AwsArnParsing_Compile.AwsKmsIdentifier;
import AwsCryptographyKeyStoreOperations_Compile.Config;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import software.amazon.cryptography.keystore.internaldafny.KeyStoreClient;
import software.amazon.cryptography.keystore.internaldafny.__default;
import software.amazon.cryptography.keystore.internaldafny.types.Error;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration;
import software.amazon.cryptography.keystore.internaldafny.types.KeyStoreConfig;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.IDynamoDBClient;
import software.amazon.cryptography.services.dynamodb.internaldafny.types._Companion_IDynamoDBClient;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;
import software.amazon.cryptography.services.kms.internaldafny.types._Companion_IKMSClient;

public abstract class _ExternBase___default {
    private static final TypeDescriptor<__default> _TYPE = TypeDescriptor.referenceWithInitializer(__default.class, () -> null);

    public static KeyStoreConfig DefaultKeyStoreConfig() {
        return KeyStoreConfig.create((DafnySequence<? extends Character>)DafnySequence.asString((String)"None"), KMSConfiguration.create((DafnySequence<? extends Character>)DafnySequence.asString((String)"")), (DafnySequence<? extends Character>)DafnySequence.asString((String)"None"), Option.create_None(), Option.create_None(), Option.create_None(), Option.create_None());
    }

    public static Result<KeyStoreClient, Error> KeyStore(KeyStoreConfig config) {
        Result<KeyStoreClient, Error> res = null;
        Outcome<Object> _1330_valueOrError0 = Outcome.Default();
        _1330_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__KeyIdType(config.dtor_kmsConfiguration().dtor_kmsKeyArn()) && AwsArnParsing_Compile.__default.ParseAwsKmsArn(config.dtor_kmsConfiguration().dtor_kmsKeyArn()).is_Success(), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid AWS KMS Key Arn")));
        if (_1330_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _1330_valueOrError0.PropagateFailure(Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
            return res;
        }
        Result<DafnySequence<? extends DafnySequence<? extends Character>>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1331_grantTokens = AwsKmsUtils_Compile.__default.GetValidGrantTokens(config.dtor_grantTokens());
        Outcome<Object> _1332_valueOrError1 = Outcome.Default();
        _1332_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _1331_grantTokens.is_Success(), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"CreateKey received invalid grant tokens")));
        if (_1332_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _1332_valueOrError1.PropagateFailure(Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
            return res;
        }
        DafnySequence _1333_keyStoreId = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
        if (config.dtor_id().is_Some()) {
            _1333_keyStoreId = config.dtor_id().dtor_value();
        } else {
            DafnySequence _1335_uuid;
            Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> _out234;
            Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> _1334_maybeUuid = _out234 = UUID.__default.GenerateUUID();
            Result<Object, Object> _1336_valueOrError2 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _1336_valueOrError2 = _1334_maybeUuid.MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _1337_e_boxed0 -> {
                DafnySequence _1337_e = _1337_e_boxed0;
                return Error.create_KeyStoreException((DafnySequence<? extends Character>)_1337_e);
            });
            if (_1336_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                res = _1336_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _1333_keyStoreId = _1335_uuid = (DafnySequence)_1336_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
        }
        IKMSClient _1338_kmsClient = null;
        IDynamoDBClient _1339_ddbClient = null;
        Result<AwsKmsIdentifier, DafnySequence<? extends Character>> _1340_keyArn = AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(config.dtor_kmsConfiguration().dtor_kmsKeyArn());
        Option<DafnySequence<? extends Character>> _1341_kmsRegion = AwsArnParsing_Compile.__default.GetRegion(_1340_keyArn.dtor_value());
        if (config.dtor_kmsClient().is_None()) {
            IKMSClient _1343_extractedClient;
            Result<IKMSClient, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out235;
            Result<IKMSClient, software.amazon.cryptography.services.kms.internaldafny.types.Error> _1342_maybeKmsClient = _out235 = software.amazon.cryptography.services.kms.internaldafny.__default.KMSClientForRegion(_1341_kmsRegion.dtor_value());
            Result<IKMSClient, Error> _1344_valueOrError3 = null;
            _1344_valueOrError3 = _1342_maybeKmsClient.MapFailure(_Companion_IKMSClient._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _1345_e_boxed0 -> {
                software.amazon.cryptography.services.kms.internaldafny.types.Error _1345_e = _1345_e_boxed0;
                return Error.create_ComAmazonawsKms(_1345_e);
            });
            if (_1344_valueOrError3.IsFailure(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor())) {
                res = _1344_valueOrError3.PropagateFailure(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _1338_kmsClient = _1343_extractedClient = _1344_valueOrError3.Extract(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor());
        } else {
            _1338_kmsClient = config.dtor_kmsClient().dtor_value();
        }
        if (config.dtor_ddbClient().is_None()) {
            IDynamoDBClient _1347_extractedClient;
            Result<IDynamoDBClient, software.amazon.cryptography.services.dynamodb.internaldafny.types.Error> _out236;
            Result<IDynamoDBClient, software.amazon.cryptography.services.dynamodb.internaldafny.types.Error> _1346_maybeDdbClient = _out236 = software.amazon.cryptography.services.dynamodb.internaldafny.__default.DDBClientForRegion(_1341_kmsRegion.dtor_value());
            Result<IDynamoDBClient, Error> _1348_valueOrError4 = null;
            _1348_valueOrError4 = _1346_maybeDdbClient.MapFailure(_Companion_IDynamoDBClient._typeDescriptor(), software.amazon.cryptography.services.dynamodb.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _1349_e_boxed0 -> {
                software.amazon.cryptography.services.dynamodb.internaldafny.types.Error _1349_e = _1349_e_boxed0;
                return Error.create_ComAmazonawsDynamodb(_1349_e);
            });
            if (_1348_valueOrError4.IsFailure(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor())) {
                res = _1348_valueOrError4.PropagateFailure(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _1339_ddbClient = _1347_extractedClient = _1348_valueOrError4.Extract(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor());
        } else {
            _1339_ddbClient = config.dtor_ddbClient().dtor_value();
        }
        Outcome<Object> _1350_valueOrError5 = Outcome.Default();
        _1350_valueOrError5 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), software.amazon.cryptography.services.dynamodb.internaldafny.types.__default.IsValid__TableName(config.dtor_ddbTableName()), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Amazon DynamoDB Table Name")));
        if (_1350_valueOrError5.IsFailure(Error._typeDescriptor())) {
            res = _1350_valueOrError5.PropagateFailure(Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
            return res;
        }
        KeyStoreClient _nw66 = new KeyStoreClient();
        _nw66.__ctor(Config.create((DafnySequence<? extends Character>)_1333_keyStoreId, config.dtor_ddbTableName(), config.dtor_logicalKeyStoreName(), config.dtor_kmsConfiguration(), _1331_grantTokens.dtor_value(), _1338_kmsClient, _1339_ddbClient));
        KeyStoreClient _1351_client = _nw66;
        res = Result.create_Success(_1351_client);
        return res;
    }

    public static TypeDescriptor<__default> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "software.amazon.cryptography.keystore.internaldafny_Compile._default";
    }
}

