/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.keystore;

import Wrappers_Compile.Result;
import dafny.Tuple0;
import java.util.Objects;
import software.amazon.cryptography.keystore.ToDafny;
import software.amazon.cryptography.keystore.ToNative;
import software.amazon.cryptography.keystore.internaldafny.KeyStoreClient;
import software.amazon.cryptography.keystore.internaldafny.__default;
import software.amazon.cryptography.keystore.internaldafny.types.BranchKeyStatusResolutionInput;
import software.amazon.cryptography.keystore.internaldafny.types.CreateKeyStoreOutput;
import software.amazon.cryptography.keystore.internaldafny.types.Error;
import software.amazon.cryptography.keystore.internaldafny.types.GetActiveBranchKeyOutput;
import software.amazon.cryptography.keystore.internaldafny.types.GetBeaconKeyInput;
import software.amazon.cryptography.keystore.internaldafny.types.GetBeaconKeyOutput;
import software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionInput;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;
import software.amazon.cryptography.keystore.internaldafny.types.KeyStoreConfig;
import software.amazon.cryptography.keystore.model.CreateKeyOutput;
import software.amazon.cryptography.keystore.model.CreateKeyStoreInput;
import software.amazon.cryptography.keystore.model.GetActiveBranchKeyInput;
import software.amazon.cryptography.keystore.model.GetBranchKeyVersionOutput;
import software.amazon.cryptography.keystore.model.GetKeyStoreInfoOutput;
import software.amazon.cryptography.keystore.model.VersionKeyInput;

public class KeyStore {
    private final IKeyStoreClient _impl;

    protected KeyStore(BuilderImpl builder) {
        software.amazon.cryptography.keystore.model.KeyStoreConfig input = builder.KeyStoreConfig();
        KeyStoreConfig dafnyValue = ToDafny.KeyStoreConfig(input);
        Result<KeyStoreClient, Error> result = __default.KeyStore(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        this._impl = result.dtor_value();
    }

    KeyStore(IKeyStoreClient impl) {
        this._impl = impl;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public void BranchKeyStatusResolution(software.amazon.cryptography.keystore.model.BranchKeyStatusResolutionInput input) {
        BranchKeyStatusResolutionInput dafnyValue = ToDafny.BranchKeyStatusResolutionInput(input);
        Result<Tuple0, Error> result = this._impl.BranchKeyStatusResolution(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
    }

    public CreateKeyOutput CreateKey() {
        Result<software.amazon.cryptography.keystore.internaldafny.types.CreateKeyOutput, Error> result = this._impl.CreateKey();
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.CreateKeyOutput(result.dtor_value());
    }

    public software.amazon.cryptography.keystore.model.CreateKeyStoreOutput CreateKeyStore(CreateKeyStoreInput input) {
        software.amazon.cryptography.keystore.internaldafny.types.CreateKeyStoreInput dafnyValue = ToDafny.CreateKeyStoreInput(input);
        Result<CreateKeyStoreOutput, Error> result = this._impl.CreateKeyStore(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.CreateKeyStoreOutput(result.dtor_value());
    }

    public software.amazon.cryptography.keystore.model.GetActiveBranchKeyOutput GetActiveBranchKey(GetActiveBranchKeyInput input) {
        software.amazon.cryptography.keystore.internaldafny.types.GetActiveBranchKeyInput dafnyValue = ToDafny.GetActiveBranchKeyInput(input);
        Result<GetActiveBranchKeyOutput, Error> result = this._impl.GetActiveBranchKey(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.GetActiveBranchKeyOutput(result.dtor_value());
    }

    public software.amazon.cryptography.keystore.model.GetBeaconKeyOutput GetBeaconKey(software.amazon.cryptography.keystore.model.GetBeaconKeyInput input) {
        GetBeaconKeyInput dafnyValue = ToDafny.GetBeaconKeyInput(input);
        Result<GetBeaconKeyOutput, Error> result = this._impl.GetBeaconKey(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.GetBeaconKeyOutput(result.dtor_value());
    }

    public GetBranchKeyVersionOutput GetBranchKeyVersion(software.amazon.cryptography.keystore.model.GetBranchKeyVersionInput input) {
        GetBranchKeyVersionInput dafnyValue = ToDafny.GetBranchKeyVersionInput(input);
        Result<software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionOutput, Error> result = this._impl.GetBranchKeyVersion(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.GetBranchKeyVersionOutput(result.dtor_value());
    }

    public GetKeyStoreInfoOutput GetKeyStoreInfo() {
        Result<software.amazon.cryptography.keystore.internaldafny.types.GetKeyStoreInfoOutput, Error> result = this._impl.GetKeyStoreInfo();
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.GetKeyStoreInfoOutput(result.dtor_value());
    }

    public void VersionKey(VersionKeyInput input) {
        software.amazon.cryptography.keystore.internaldafny.types.VersionKeyInput dafnyValue = ToDafny.VersionKeyInput(input);
        Result<Tuple0, Error> result = this._impl.VersionKey(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
    }

    protected IKeyStoreClient impl() {
        return this._impl;
    }

    static class BuilderImpl
    implements Builder {
        protected software.amazon.cryptography.keystore.model.KeyStoreConfig KeyStoreConfig;

        protected BuilderImpl() {
        }

        @Override
        public Builder KeyStoreConfig(software.amazon.cryptography.keystore.model.KeyStoreConfig KeyStoreConfig2) {
            this.KeyStoreConfig = KeyStoreConfig2;
            return this;
        }

        @Override
        public software.amazon.cryptography.keystore.model.KeyStoreConfig KeyStoreConfig() {
            return this.KeyStoreConfig;
        }

        @Override
        public KeyStore build() {
            if (Objects.isNull(this.KeyStoreConfig())) {
                throw new IllegalArgumentException("Missing value for required field `KeyStoreConfig`");
            }
            return new KeyStore(this);
        }
    }

    public static interface Builder {
        public Builder KeyStoreConfig(software.amazon.cryptography.keystore.model.KeyStoreConfig var1);

        public software.amazon.cryptography.keystore.model.KeyStoreConfig KeyStoreConfig();

        public KeyStore build();
    }
}

