/*
 * Decompiled with CFR 0.152.
 */
package MultiKeyring_Compile;

import Keyring_Compile.VerifiableInterface;
import MultiKeyring_Compile.__default;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;

public class MultiKeyring
implements VerifiableInterface,
IKeyring {
    public Option<IKeyring> _generatorKeyring = Option.Default();
    public DafnySequence<? extends IKeyring> _childKeyrings = DafnySequence.empty(_Companion_IKeyring._typeDescriptor());
    private static final TypeDescriptor<MultiKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(MultiKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out10 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out10;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out11 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out11;
    }

    public void __ctor(Option<IKeyring> generatorKeyring, DafnySequence<? extends IKeyring> childKeyrings) {
        this._generatorKeyring = generatorKeyring;
        this._childKeyrings = childKeyrings;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> res = null;
        if (this.generatorKeyring().is_None() && input.dtor_materials().dtor_plaintextDataKey().is_None()) {
            DafnySequence _69_exception = DafnySequence.asString((String)"Need either a generator keyring or input encryption materials which contain a plaintext data key");
            res = Result.create_Failure(Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_69_exception));
            return res;
        }
        EncryptionMaterials _70_returnMaterials = input.dtor_materials();
        if (this.generatorKeyring().is_Some()) {
            Result<OnEncryptOutput, Error> _out12;
            Outcome<Object> _71_valueOrError0 = Outcome.Default();
            _71_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), input.dtor_materials().dtor_plaintextDataKey().is_None(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"This multi keyring has a generator but provided Encryption Materials already contain plaintext data key")));
            if (_71_valueOrError0.IsFailure(Error._typeDescriptor())) {
                res = _71_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            Result<OnEncryptOutput, Error> _72_onEncryptOutput = _out12 = this.generatorKeyring().dtor_value().OnEncrypt(input);
            Outcome<Object> _73_valueOrError1 = Outcome.Default();
            _73_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _72_onEncryptOutput.is_Success(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Generator keyring failed to generate plaintext data key")));
            if (_73_valueOrError1.IsFailure(Error._typeDescriptor())) {
                res = _73_valueOrError1.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            Outcome<Object> _74_valueOrError2 = Outcome.Default();
            _74_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.ValidEncryptionMaterialsTransition(input.dtor_materials(), _72_onEncryptOutput.dtor_value().dtor_materials()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Generator keyring returned invalid encryption materials")));
            if (_74_valueOrError2.IsFailure(Error._typeDescriptor())) {
                res = _74_valueOrError2.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            _70_returnMaterials = _72_onEncryptOutput.dtor_value().dtor_materials();
        }
        BigInteger _hi0 = BigInteger.valueOf(this.childKeyrings().length());
        BigInteger _75_i = BigInteger.ZERO;
        while (_75_i.compareTo(_hi0) < 0) {
            Result<OnEncryptOutput, Error> _out13;
            OnEncryptInput _76_onEncryptInput = OnEncryptInput.create(_70_returnMaterials);
            Result<OnEncryptOutput, Error> _77_onEncryptOutput = _out13 = ((IKeyring)this.childKeyrings().select(Helpers.toInt((BigInteger)_75_i))).OnEncrypt(_76_onEncryptInput);
            Outcome<Object> _78_valueOrError3 = Outcome.Default();
            _78_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _77_onEncryptOutput.is_Success(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Child keyring failed to encrypt plaintext data key")));
            if (_78_valueOrError3.IsFailure(Error._typeDescriptor())) {
                res = _78_valueOrError3.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            Outcome<Object> _79_valueOrError4 = Outcome.Default();
            _79_valueOrError4 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.ValidEncryptionMaterialsTransition(_70_returnMaterials, _77_onEncryptOutput.dtor_value().dtor_materials()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Child keyring performed invalid transition on encryption materials")));
            if (_79_valueOrError4.IsFailure(Error._typeDescriptor())) {
                res = _79_valueOrError4.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            _70_returnMaterials = _77_onEncryptOutput.dtor_value().dtor_materials();
            _75_i = _75_i.add(BigInteger.ONE);
        }
        Outcome<Object> _80_valueOrError5 = Outcome.Default();
        _80_valueOrError5 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.ValidEncryptionMaterialsTransition(input.dtor_materials(), _70_returnMaterials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"A child or generator keyring modified the encryption materials in illegal ways.")));
        if (_80_valueOrError5.IsFailure(Error._typeDescriptor())) {
            res = _80_valueOrError5.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        res = Result.create_Success(OnEncryptOutput.create(_70_returnMaterials));
        return res;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> res = null;
        DecryptionMaterials _81_materials = input.dtor_materials();
        Outcome<Object> _82_valueOrError0 = Outcome.Default();
        _82_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(input.dtor_materials()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_82_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _82_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _83_failures = DafnySequence.empty(Error._typeDescriptor());
        if (this.generatorKeyring().is_Some()) {
            Result<OnDecryptOutput, Error> _out14 = __default.AttemptDecryptDataKey(this.generatorKeyring().dtor_value(), input);
            Result<OnDecryptOutput, Error> _84_result = _out14;
            if (_84_result.is_Success()) {
                if (_84_result.dtor_value().dtor_materials().dtor_plaintextDataKey().is_Some()) {
                    res = Result.create_Success(_84_result.dtor_value());
                    return res;
                }
            } else {
                _83_failures = DafnySequence.concatenate((DafnySequence)_83_failures, (DafnySequence)DafnySequence.of(Error._typeDescriptor(), (Object[])new Error[]{_84_result.dtor_error()}));
            }
        }
        BigInteger _hi1 = BigInteger.valueOf(this.childKeyrings().length());
        BigInteger _85_j = BigInteger.ZERO;
        while (_85_j.compareTo(_hi1) < 0) {
            Result<OnDecryptOutput, Error> _out15 = __default.AttemptDecryptDataKey((IKeyring)this.childKeyrings().select(Helpers.toInt((BigInteger)_85_j)), input);
            Result<OnDecryptOutput, Error> _86_result = _out15;
            if (_86_result.is_Success()) {
                res = Result.create_Success(_86_result.dtor_value());
                return res;
            }
            _83_failures = DafnySequence.concatenate((DafnySequence)_83_failures, (DafnySequence)DafnySequence.of(Error._typeDescriptor(), (Object[])new Error[]{_86_result.dtor_error()}));
            _85_j = _85_j.add(BigInteger.ONE);
        }
        Error _87_combinedResult = Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_83_failures, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured Keyring was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`."));
        res = Result.create_Failure(_87_combinedResult);
        return res;
    }

    public Option<IKeyring> generatorKeyring() {
        return this._generatorKeyring;
    }

    public DafnySequence<? extends IKeyring> childKeyrings() {
        return this._childKeyrings;
    }

    public static TypeDescriptor<MultiKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "MultiKeyring_Compile.MultiKeyring";
    }
}

