/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsUtils_Compile;

import Actions_Compile.DeterministicAction;
import Actions_Compile.DeterministicActionWithResult;
import AwsArnParsing_Compile.AwsArn;
import AwsArnParsing_Compile.AwsKmsArn;
import AwsArnParsing_Compile.AwsKmsIdentifier;
import AwsKmsUtils_Compile.__default;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;

public class OnDecryptMrkAwareEncryptedDataKeyFilter
implements DeterministicActionWithResult<EncryptedDataKey, Boolean, Error>,
DeterministicAction<EncryptedDataKey, Result<Boolean, Error>> {
    public AwsKmsIdentifier _awsKmsKey = null;
    public DafnySequence<? extends Byte> _providerId = ValidUTF8Bytes.defaultValue();
    private static final TypeDescriptor<OnDecryptMrkAwareEncryptedDataKeyFilter> _TYPE = TypeDescriptor.referenceWithInitializer(OnDecryptMrkAwareEncryptedDataKeyFilter.class, () -> null);

    public void __ctor(AwsKmsIdentifier awsKmsKey, DafnySequence<? extends Byte> providerId) {
        this._awsKmsKey = awsKmsKey;
        this._providerId = providerId;
    }

    @Override
    public Result<Boolean, Error> Invoke(EncryptedDataKey edk) {
        Result<Boolean, Error> res = Result.Default(false);
        if (!edk.dtor_keyProviderId().equals(this.providerId())) {
            res = Result.create_Success(false);
            return res;
        }
        if (!UTF8.__default.ValidUTF8Seq(edk.dtor_keyProviderInfo())) {
            res = Result.create_Failure(Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid AWS KMS encoding, provider info is not UTF8.")));
            return res;
        }
        Result<Object, Object> _173_valueOrError0 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        _173_valueOrError0 = UTF8.__default.Decode(edk.dtor_keyProviderInfo()).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), __default::WrapStringToError);
        if (_173_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
            res = _173_valueOrError0.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return res;
        }
        DafnySequence _172_keyId = (DafnySequence)_173_valueOrError0.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
        Result<AwsArn, Error> _175_valueOrError1 = null;
        _175_valueOrError1 = AwsArnParsing_Compile.__default.ParseAwsKmsArn((DafnySequence<? extends Character>)_172_keyId).MapFailure(AwsKmsArn._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), __default::WrapStringToError);
        if (_175_valueOrError1.IsFailure(AwsKmsArn._typeDescriptor(), Error._typeDescriptor())) {
            res = _175_valueOrError1.PropagateFailure(AwsKmsArn._typeDescriptor(), Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return res;
        }
        AwsArn _174_arn = _175_valueOrError1.Extract(AwsKmsArn._typeDescriptor(), Error._typeDescriptor());
        res = Result.create_Success(AwsKmsMrkMatchForDecrypt_Compile.__default.AwsKmsMrkMatchForDecrypt(this.awsKmsKey(), AwsKmsIdentifier.create_AwsKmsArnIdentifier(_174_arn)));
        return res;
    }

    public AwsKmsIdentifier awsKmsKey() {
        return this._awsKmsKey;
    }

    public DafnySequence<? extends Byte> providerId() {
        return this._providerId;
    }

    public static TypeDescriptor<OnDecryptMrkAwareEncryptedDataKeyFilter> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsUtils_Compile.OnDecryptMrkAwareEncryptedDataKeyFilter";
    }
}

