/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsHierarchicalKeyring_Compile;

import Actions_Compile.Action;
import Actions_Compile.ActionWithResult;
import AwsKmsHierarchicalKeyring_Compile.HierarchyUnwrapInfo;
import AwsKmsHierarchicalKeyring_Compile.KmsHierarchyUnwrapKeyMaterial;
import AwsKmsHierarchicalKeyring_Compile.__default;
import BoundedInts_Compile.uint8;
import EdkWrapping_Compile.UnwrapEdkMaterialOutput;
import Materials_Compile.SealedDecryptionMaterials;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.Tuple0;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.internaldafny.SynchronizedLocalCMC;
import software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionInput;
import software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionOutput;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.BranchKeyMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.Materials;
import software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.DigestInput;
import software.amazon.cryptography.primitives.internaldafny.types.Error;

public class DecryptSingleEncryptedDataKey
implements ActionWithResult<EncryptedDataKey, DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>,
Action<EncryptedDataKey, Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>> {
    public DecryptionMaterials _materials = null;
    public IKeyStoreClient _keyStore = null;
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public DafnySequence<? extends Character> _branchKeyId = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public long _ttlSeconds = 0L;
    public SynchronizedLocalCMC _cache = null;
    private static final TypeDescriptor<DecryptSingleEncryptedDataKey> _TYPE = TypeDescriptor.referenceWithInitializer(DecryptSingleEncryptedDataKey.class, () -> null);

    public void __ctor(DecryptionMaterials materials, IKeyStoreClient keyStore, AtomicPrimitivesClient cryptoPrimitives, DafnySequence<? extends Character> branchKeyId, long ttlSeconds, SynchronizedLocalCMC cache) {
        this._materials = materials;
        this._keyStore = keyStore;
        this._cryptoPrimitives = cryptoPrimitives;
        this._branchKeyId = branchKeyId;
        this._ttlSeconds = ttlSeconds;
        this._cache = cache;
    }

    @Override
    public Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> Invoke(EncryptedDataKey edk) {
        Result<UnwrapEdkMaterialOutput<HierarchyUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out103;
        Result<AtomicPrimitivesClient, Error> _out102;
        Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = null;
        Outcome<Object> _678_valueOrError0 = Outcome.Default();
        _678_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UTF8.__default.ValidUTF8Seq(edk.dtor_keyProviderInfo()), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Received invalid EDK provider info for Hierarchical Keyring")));
        if (_678_valueOrError0.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _678_valueOrError0.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        AlgorithmSuiteInfo _679_suite = this.materials().dtor_algorithmSuite();
        DafnySequence<? extends Byte> _680_keyProviderId = edk.dtor_keyProviderId();
        DafnySequence<? extends Byte> _681_branchKeyIdUtf8 = edk.dtor_keyProviderInfo();
        DafnySequence<? extends Byte> _682_ciphertext = edk.dtor_ciphertext();
        Result<Object, Object> _684_valueOrError1 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _684_valueOrError1 = EdkWrapping_Compile.__default.GetProviderWrappedMaterial(_682_ciphertext, _679_suite);
        if (_684_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _684_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _683_providerWrappedMaterial = (DafnySequence)_684_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Outcome<Object> _685_valueOrError2 = Outcome.Default();
        _685_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BigInteger.valueOf(_683_providerWrappedMaterial.length()).compareTo(BigInteger.valueOf(__default.EDK__CIPHERTEXT__VERSION__INDEX())) >= 0, software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Received EDK Ciphertext of incorrect length.")));
        if (_685_valueOrError2.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _685_valueOrError2.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _686_branchKeyVersionUuid = _683_providerWrappedMaterial.subsequence(__default.EDK__CIPHERTEXT__BRANCH__KEY__VERSION__INDEX(), __default.EDK__CIPHERTEXT__VERSION__INDEX());
        Result<Object, Object> _688_valueOrError3 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        _688_valueOrError3 = UUID.__default.FromByteArray((DafnySequence<? extends Byte>)_686_branchKeyVersionUuid).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_688_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _688_valueOrError3.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _687_version = (DafnySequence)_688_valueOrError3.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<Object, Object> _690_valueOrError4 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out100 = this.GetVersionCacheId(_681_branchKeyIdUtf8, (DafnySequence<? extends Character>)_687_version, this.cryptoPrimitives());
        _690_valueOrError4 = _out100;
        if (_690_valueOrError4.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _690_valueOrError4.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _689_cacheId = (DafnySequence)_690_valueOrError4.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<BranchKeyMaterials, Object> _692_valueOrError5 = Result.Default(BranchKeyMaterials.Default());
        Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out101 = this.GetHierarchicalMaterialsVersion(this.branchKeyId(), _681_branchKeyIdUtf8, (DafnySequence<? extends Character>)_687_version, (DafnySequence<? extends Byte>)_689_cacheId);
        _692_valueOrError5 = _out101;
        if (_692_valueOrError5.IsFailure(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _692_valueOrError5.PropagateFailure(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        BranchKeyMaterials _691_hierarchicalMaterials = _692_valueOrError5.Extract(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        DafnySequence<? extends Byte> _693_branchKey = _691_hierarchicalMaterials.dtor_branchKey();
        DafnySequence<? extends Byte> _694_branchKeyVersion = _691_hierarchicalMaterials.dtor_branchKeyVersion();
        Result<Object, Object> _696_valueOrError6 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        _696_valueOrError6 = UTF8.__default.Decode(_694_branchKeyVersion).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_696_valueOrError6.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _696_valueOrError6.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _695_branchKeyVersionAsString = (DafnySequence)_696_valueOrError6.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<Object, Object> _698_valueOrError7 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _698_valueOrError7 = UUID.__default.ToByteArray((DafnySequence<? extends Character>)_695_branchKeyVersionAsString).MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_698_valueOrError7.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _698_valueOrError7.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _697_branchKeyVersionAsBytes = (DafnySequence)_698_valueOrError7.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<AtomicPrimitivesClient, Error> _699_maybeCrypto = _out102 = software.amazon.cryptography.primitives.internaldafny.__default.AtomicPrimitives(software.amazon.cryptography.primitives.internaldafny.__default.DefaultCryptoConfig());
        Result<AtomicPrimitivesClient, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _701_valueOrError8 = null;
        _701_valueOrError8 = _699_maybeCrypto.MapFailure(AtomicPrimitivesClient._typeDescriptor(), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _702_e_boxed0 -> {
            Error _702_e = _702_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_702_e);
        });
        if (_701_valueOrError8.IsFailure(AtomicPrimitivesClient._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _701_valueOrError8.PropagateFailure(AtomicPrimitivesClient._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        AtomicPrimitivesClient _700_crypto = _701_valueOrError8.Extract(AtomicPrimitivesClient._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        KmsHierarchyUnwrapKeyMaterial _nw36 = new KmsHierarchyUnwrapKeyMaterial();
        _nw36.__ctor(_693_branchKey, _681_branchKeyIdUtf8, (DafnySequence<? extends Byte>)_697_branchKeyVersionAsBytes, _700_crypto);
        KmsHierarchyUnwrapKeyMaterial _703_kmsHierarchyUnwrap = _nw36;
        Result<UnwrapEdkMaterialOutput<HierarchyUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _704_unwrapOutputRes = _out103 = EdkWrapping_Compile.__default.UnwrapEdkMaterial(HierarchyUnwrapInfo._typeDescriptor(), edk.dtor_ciphertext(), this.materials(), _703_kmsHierarchyUnwrap);
        Result<UnwrapEdkMaterialOutput<HierarchyUnwrapInfo>, Object> _706_valueOrError9 = Result.Default(UnwrapEdkMaterialOutput.Default(HierarchyUnwrapInfo.Default()));
        _706_valueOrError9 = _704_unwrapOutputRes;
        if (_706_valueOrError9.IsFailure(UnwrapEdkMaterialOutput._typeDescriptor(HierarchyUnwrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _706_valueOrError9.PropagateFailure(UnwrapEdkMaterialOutput._typeDescriptor(HierarchyUnwrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        UnwrapEdkMaterialOutput<HierarchyUnwrapInfo> _705_unwrapOutput = _706_valueOrError9.Extract(UnwrapEdkMaterialOutput._typeDescriptor(HierarchyUnwrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _708_valueOrError10 = null;
        _708_valueOrError10 = Materials_Compile.__default.DecryptionMaterialsAddDataKey(this.materials(), _705_unwrapOutput.dtor_plaintextDataKey(), _705_unwrapOutput.dtor_symmetricSigningKey());
        if (_708_valueOrError10.IsFailure(DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _708_valueOrError10.PropagateFailure(DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DecryptionMaterials _707_result = _708_valueOrError10.Extract(DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        res = Result.create_Success(_707_result);
        return res;
    }

    public Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetVersionCacheId(DafnySequence<? extends Byte> branchKeyIdUtf8, DafnySequence<? extends Character> branchKeyVersion, AtomicPrimitivesClient cryptoPrimitives) {
        Result<DafnySequence<? extends Byte>, Error> _out104;
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> cacheId = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Outcome<Object> _709_valueOrError0 = Outcome.Default();
        _709_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UTF8.__default.Decode(branchKeyIdUtf8).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError).is_Success() && (Boolean)Helpers.Let(UTF8.__default.Decode(branchKeyIdUtf8).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError).dtor_value(), boxed38 -> {
            DafnySequence _pat_let19_0 = boxed38;
            return (boolean)((Boolean)Helpers.Let((Object)_pat_let19_0, boxed39 -> {
                DafnySequence _710_branchKeyId = boxed39;
                return BigInteger.valueOf(_710_branchKeyId.length()).signum() != -1 && BigInteger.valueOf(_710_branchKeyId.length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT32__LIMIT()) < 0;
            }));
        }) != false, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Branch Key ID Length")));
        if (_709_valueOrError0.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _709_valueOrError0.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence<? extends Character> _711_branchKeyId = UTF8.__default.Decode(branchKeyIdUtf8).dtor_value();
        DafnySequence<? extends Byte> _712_lenBranchKey = StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(_711_branchKeyId.cardinalityInt());
        Outcome<Object> _713_valueOrError1 = Outcome.Default();
        _713_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UTF8.__default.IsASCIIString(branchKeyVersion), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unable to represent as an ASCII string.")));
        if (_713_valueOrError1.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _713_valueOrError1.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence<? extends Byte> _714_versionBytes = UTF8.__default.EncodeAscii(branchKeyVersion);
        DafnySequence _715_identifier = DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(_712_lenBranchKey, branchKeyIdUtf8), (DafnySequence)DafnySequence.of((byte[])new byte[]{0})), _714_versionBytes);
        DigestInput _716_identifierDigestInput = DigestInput.create(DigestAlgorithm.create_SHA__512(), (DafnySequence<? extends Byte>)_715_identifier);
        Result<DafnySequence<? extends Byte>, Error> _717_maybeCacheDigest = _out104 = Digest_Compile.__default.Digest(_716_identifierDigestInput);
        Result<Object, Object> _719_valueOrError2 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _719_valueOrError2 = _717_maybeCacheDigest.MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _720_e_boxed0 -> {
            Error _720_e = _720_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_720_e);
        });
        if (_719_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _719_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence _718_cacheDigest = (DafnySequence)_719_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        cacheId = Result.create_Success(_718_cacheDigest.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)BigInteger.valueOf(32L))));
        return cacheId;
    }

    public Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetHierarchicalMaterialsVersion(DafnySequence<? extends Character> branchKeyId, DafnySequence<? extends Byte> branchKeyIdUtf8, DafnySequence<? extends Character> version, DafnySequence<? extends Byte> cacheId) {
        Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> material = Result.Default(BranchKeyMaterials.Default());
        GetCacheEntryInput _721_getCacheInput = GetCacheEntryInput.create(cacheId, Option.create_None());
        Result<GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out105 = __default.getEntry(this.cache(), _721_getCacheInput);
        Result<GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _722_getCacheOutput = _out105;
        if (_722_getCacheOutput.is_Failure()) {
            long _out107;
            Result<GetBranchKeyVersionOutput, software.amazon.cryptography.keystore.internaldafny.types.Error> _out106;
            Result<GetBranchKeyVersionOutput, software.amazon.cryptography.keystore.internaldafny.types.Error> _723_maybeRawBranchKeyMaterials = _out106 = this.keyStore().GetBranchKeyVersion(GetBranchKeyVersionInput.create(branchKeyId, version));
            Result<GetBranchKeyVersionOutput, Object> _725_valueOrError0 = Result.Default(GetBranchKeyVersionOutput.Default());
            _725_valueOrError0 = _723_maybeRawBranchKeyMaterials.MapFailure(GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _726_e_boxed0 -> {
                software.amazon.cryptography.keystore.internaldafny.types.Error _726_e = _726_e_boxed0;
                return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyKeyStore(_726_e);
            });
            if (_725_valueOrError0.IsFailure(GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _725_valueOrError0.PropagateFailure(GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            GetBranchKeyVersionOutput _724_rawBranchKeyMaterials = _725_valueOrError0.Extract(GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            BranchKeyMaterials _727_branchKeyMaterials = BranchKeyMaterials.create(_724_rawBranchKeyMaterials.dtor_branchKeyVersion(), _724_rawBranchKeyMaterials.dtor_branchKey());
            long _728_now = _out107 = Time.__default.CurrentRelativeTime().longValue();
            Outcome<Object> _729_valueOrError1 = Outcome.Default();
            _729_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BigInteger.valueOf(_728_now).add(BigInteger.valueOf(this.ttlSeconds())).compareTo(StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT()) < 0, software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"INT64 Overflow when putting cache entry.")));
            if (_729_valueOrError1.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _729_valueOrError1.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            PutCacheEntryInput _730_putCacheEntryInput = PutCacheEntryInput.create(cacheId, Materials.create_BranchKey(_727_branchKeyMaterials), _728_now, this.ttlSeconds() + _728_now, Option.create_None(), Option.create_None());
            Result<Tuple0, Object> _732_valueOrError2 = Result.Default(Tuple0.Default());
            Result<Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out108 = __default.putEntry(this.cache(), _730_putCacheEntryInput);
            _732_valueOrError2 = _out108;
            if (_732_valueOrError2.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _732_valueOrError2.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            Tuple0 _731___v1 = _732_valueOrError2.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            material = Result.create_Success(_727_branchKeyMaterials);
            return material;
        }
        Outcome<Object> _733_valueOrError3 = Outcome.Default();
        _733_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _722_getCacheOutput.dtor_value().dtor_materials().is_BranchKey() && Objects.equals(_722_getCacheOutput.dtor_value().dtor_materials(), Materials.create_BranchKey(_722_getCacheOutput.dtor_value().dtor_materials().dtor_BranchKey())), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Material Type.")));
        if (_733_valueOrError3.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            material = _733_valueOrError3.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
            return material;
        }
        material = Result.create_Success(_722_getCacheOutput.dtor_value().dtor_materials().dtor_BranchKey());
        return material;
    }

    public DecryptionMaterials materials() {
        return this._materials;
    }

    public IKeyStoreClient keyStore() {
        return this._keyStore;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public DafnySequence<? extends Character> branchKeyId() {
        return this._branchKeyId;
    }

    public long ttlSeconds() {
        return this._ttlSeconds;
    }

    public SynchronizedLocalCMC cache() {
        return this._cache;
    }

    public static TypeDescriptor<DecryptSingleEncryptedDataKey> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsHierarchicalKeyring_Compile.DecryptSingleEncryptedDataKey";
    }
}

