/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsHierarchicalKeyring_Compile;

import AwsKmsHierarchicalKeyring_Compile.DecryptSingleEncryptedDataKey;
import AwsKmsHierarchicalKeyring_Compile.HierarchyWrapInfo;
import AwsKmsHierarchicalKeyring_Compile.KmsHierarchyGenerateAndWrapKeyMaterial;
import AwsKmsHierarchicalKeyring_Compile.KmsHierarchyWrapKeyMaterial;
import AwsKmsHierarchicalKeyring_Compile.OnDecryptHierarchyEncryptedDataKeyFilter;
import AwsKmsHierarchicalKeyring_Compile.__default;
import BoundedInts_Compile.uint8;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import LocalCMC_Compile.LocalCMC;
import Materials_Compile.SealedDecryptionMaterials;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.Tuple0;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.internaldafny.SynchronizedLocalCMC;
import software.amazon.cryptography.keystore.internaldafny.types.GetActiveBranchKeyInput;
import software.amazon.cryptography.keystore.internaldafny.types.GetActiveBranchKeyOutput;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.BranchKeyMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetBranchKeyIdInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetBranchKeyIdOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.IBranchKeyIdSupplier;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.Materials;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.DigestInput;
import software.amazon.cryptography.primitives.internaldafny.types.Error;

public class AwsKmsHierarchicalKeyring
implements VerifiableInterface,
IKeyring {
    public IKeyStoreClient _keyStore = null;
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public Option<IBranchKeyIdSupplier> _branchKeyIdSupplier = Option.Default();
    public Option<DafnySequence<? extends Character>> _branchKeyId = Option.Default();
    public long _ttlSeconds = 0L;
    public int _maxCacheSize = 0;
    public SynchronizedLocalCMC _cache = null;
    private static final TypeDescriptor<AwsKmsHierarchicalKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsHierarchicalKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out84 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out84;
    }

    @Override
    public Result<OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out85 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out85;
    }

    public void __ctor(IKeyStoreClient keyStore, Option<DafnySequence<? extends Character>> branchKeyId, Option<IBranchKeyIdSupplier> branchKeyIdSupplier, long ttlSeconds, int maxCacheSize, AtomicPrimitivesClient cryptoPrimitives) {
        SynchronizedLocalCMC _nw31;
        LocalCMC _nw30 = new LocalCMC();
        _nw30.__ctor(BigInteger.valueOf(maxCacheSize), BigInteger.ONE);
        LocalCMC _600_localCMC = _nw30;
        SynchronizedLocalCMC _601_cmc = _nw31 = new SynchronizedLocalCMC(_600_localCMC);
        this._keyStore = keyStore;
        this._branchKeyId = branchKeyId;
        this._branchKeyIdSupplier = branchKeyIdSupplier;
        this._ttlSeconds = ttlSeconds;
        this._maxCacheSize = maxCacheSize;
        this._cryptoPrimitives = cryptoPrimitives;
        this._cache = _601_cmc;
    }

    public Result<DafnySequence<? extends Character>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetBranchKeyId(DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> context) {
        Result<Object, software.amazon.cryptography.materialproviders.internaldafny.types.Error> ret = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        if (this.branchKeyId().is_Some()) {
            ret = Result.create_Success(this.branchKeyId().dtor_value());
            return ret;
        }
        Result<GetBranchKeyIdOutput, Object> _603_valueOrError0 = Result.Default(GetBranchKeyIdOutput.Default());
        Result<GetBranchKeyIdOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out86 = this.branchKeyIdSupplier().dtor_value().GetBranchKeyId(GetBranchKeyIdInput.create(context));
        _603_valueOrError0 = _out86;
        if (_603_valueOrError0.IsFailure(GetBranchKeyIdOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            ret = _603_valueOrError0.PropagateFailure(GetBranchKeyIdOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            return ret;
        }
        GetBranchKeyIdOutput _602_GetBranchKeyIdOut = _603_valueOrError0.Extract(GetBranchKeyIdOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        ret = Result.create_Success(_602_GetBranchKeyIdOut.dtor_branchKeyId());
        return ret;
    }

    @Override
    public Result<OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = null;
        EncryptionMaterials _604_materials = input.dtor_materials();
        AlgorithmSuiteInfo _605_suite = _604_materials.dtor_algorithmSuite();
        Result<Object, Object> _607_valueOrError0 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        Result<DafnySequence<? extends Character>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out87 = this.GetBranchKeyId(_604_materials.dtor_encryptionContext());
        _607_valueOrError0 = _out87;
        if (_607_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _607_valueOrError0.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _606_branchKeyIdForEncrypt = (DafnySequence)_607_valueOrError0.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<DafnySequence<? extends Byte>, Object> _609_valueOrError1 = Result.Default(ValidUTF8Bytes.defaultValue());
        _609_valueOrError1 = UTF8.__default.Encode((DafnySequence<? extends Character>)_606_branchKeyIdForEncrypt).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_609_valueOrError1.IsFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _609_valueOrError1.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence<? extends Byte> _608_branchKeyIdUtf8 = _609_valueOrError1.Extract(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<Object, Object> _611_valueOrError2 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out88 = this.GetActiveCacheId((DafnySequence<? extends Character>)_606_branchKeyIdForEncrypt, _608_branchKeyIdUtf8, this.cryptoPrimitives());
        _611_valueOrError2 = _out88;
        if (_611_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _611_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _610_cacheId = (DafnySequence)_611_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<BranchKeyMaterials, Object> _613_valueOrError3 = Result.Default(BranchKeyMaterials.Default());
        Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out89 = this.GetActiveHierarchicalMaterials((DafnySequence<? extends Character>)_606_branchKeyIdForEncrypt, (DafnySequence<? extends Byte>)_610_cacheId, this.keyStore());
        _613_valueOrError3 = _out89;
        if (_613_valueOrError3.IsFailure(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _613_valueOrError3.PropagateFailure(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        BranchKeyMaterials _612_hierarchicalMaterials = _613_valueOrError3.Extract(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        DafnySequence<? extends Byte> _614_branchKey = _612_hierarchicalMaterials.dtor_branchKey();
        DafnySequence<? extends Byte> _615_branchKeyVersion = _612_hierarchicalMaterials.dtor_branchKeyVersion();
        Result<Object, Object> _617_valueOrError4 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        _617_valueOrError4 = UTF8.__default.Decode(_615_branchKeyVersion).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_617_valueOrError4.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _617_valueOrError4.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _616_branchKeyVersionAsString = (DafnySequence)_617_valueOrError4.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<Object, Object> _619_valueOrError5 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _619_valueOrError5 = UUID.__default.ToByteArray((DafnySequence<? extends Character>)_616_branchKeyVersionAsString).MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_619_valueOrError5.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _619_valueOrError5.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _618_branchKeyVersionAsBytes = (DafnySequence)_619_valueOrError5.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        KmsHierarchyGenerateAndWrapKeyMaterial _nw32 = new KmsHierarchyGenerateAndWrapKeyMaterial();
        _nw32.__ctor(_612_hierarchicalMaterials.dtor_branchKey(), _608_branchKeyIdUtf8, (DafnySequence<? extends Byte>)_618_branchKeyVersionAsBytes, this.cryptoPrimitives());
        KmsHierarchyGenerateAndWrapKeyMaterial _620_kmsHierarchyGenerateAndWrap = _nw32;
        KmsHierarchyWrapKeyMaterial _nw33 = new KmsHierarchyWrapKeyMaterial();
        _nw33.__ctor(_612_hierarchicalMaterials.dtor_branchKey(), _608_branchKeyIdUtf8, (DafnySequence<? extends Byte>)_618_branchKeyVersionAsBytes, this.cryptoPrimitives());
        KmsHierarchyWrapKeyMaterial _621_kmsHierarchyWrap = _nw33;
        Result<WrapEdkMaterialOutput<HierarchyWrapInfo>, Object> _623_valueOrError6 = Result.Default(WrapEdkMaterialOutput.Default(HierarchyWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<HierarchyWrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out90 = EdkWrapping_Compile.__default.WrapEdkMaterial(HierarchyWrapInfo._typeDescriptor(), _604_materials, _621_kmsHierarchyWrap, _620_kmsHierarchyGenerateAndWrap);
        _623_valueOrError6 = _out90;
        if (_623_valueOrError6.IsFailure(WrapEdkMaterialOutput._typeDescriptor(HierarchyWrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _623_valueOrError6.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(HierarchyWrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        WrapEdkMaterialOutput<HierarchyWrapInfo> _622_wrapOutput = _623_valueOrError6.Extract(WrapEdkMaterialOutput._typeDescriptor(HierarchyWrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _624_symmetricSigningKeyList = _622_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_622_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None();
        EncryptedDataKey _625_edk = EncryptedDataKey.create(Constants_Compile.__default.PROVIDER__ID__HIERARCHY(), _608_branchKeyIdUtf8, _622_wrapOutput.dtor_wrappedMaterial());
        if (_622_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _627_valueOrError7 = null;
            _627_valueOrError7 = Materials_Compile.__default.EncryptionMaterialAddDataKey(_604_materials, _622_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_625_edk}), _624_symmetricSigningKeyList);
            if (_627_valueOrError7.IsFailure(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                res = _627_valueOrError7.PropagateFailure(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _626_result = _627_valueOrError7.Extract(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput.create(_626_result));
            return res;
        }
        if (_622_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _629_valueOrError8 = null;
            _629_valueOrError8 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(_604_materials, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_625_edk}), _624_symmetricSigningKeyList);
            if (_629_valueOrError8.IsFailure(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                res = _629_valueOrError8.PropagateFailure(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _628_result = _629_valueOrError8.Extract(EncryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput.create(_628_result));
            return res;
        }
        return res;
    }

    @Override
    public Result<OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<software.amazon.cryptography.materialproviders.internaldafny.types.Error>> _out93;
        Result<OnDecryptOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = null;
        DecryptionMaterials _630_materials = input.dtor_materials();
        AlgorithmSuiteInfo _631_suite = input.dtor_materials().dtor_algorithmSuite();
        Outcome<Object> _632_valueOrError0 = Outcome.Default();
        _632_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_630_materials), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_632_valueOrError0.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _632_valueOrError0.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        Result<Object, Object> _634_valueOrError1 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        Result<DafnySequence<? extends Character>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out91 = this.GetBranchKeyId(_630_materials.dtor_encryptionContext());
        _634_valueOrError1 = _out91;
        if (_634_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _634_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _633_branchKeyIdForDecrypt = (DafnySequence)_634_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        OnDecryptHierarchyEncryptedDataKeyFilter _nw34 = new OnDecryptHierarchyEncryptedDataKeyFilter();
        _nw34.__ctor((DafnySequence<? extends Character>)_633_branchKeyIdForDecrypt);
        OnDecryptHierarchyEncryptedDataKeyFilter _635_filter = _nw34;
        Result<Object, Object> _637_valueOrError2 = Result.Default(DafnySequence.empty(EncryptedDataKey._typeDescriptor()));
        Result<DafnySequence<? extends EncryptedDataKey>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out92 = Actions_Compile.__default.FilterWithResult(EncryptedDataKey._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _635_filter, input.dtor_encryptedDataKeys());
        _637_valueOrError2 = _out92;
        if (_637_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _637_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _636_edksToAttempt = (DafnySequence)_637_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Outcome<Object> _638_valueOrError3 = Outcome.Default();
        _638_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BigInteger.valueOf(_636_edksToAttempt.length()).signum() == 1, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unable to decrypt data key: No Encrypted Data Keys found to match.")));
        if (_638_valueOrError3.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _638_valueOrError3.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptSingleEncryptedDataKey _nw35 = new DecryptSingleEncryptedDataKey();
        _nw35.__ctor(_630_materials, this.keyStore(), this.cryptoPrimitives(), (DafnySequence<? extends Character>)_633_branchKeyIdForDecrypt, this.ttlSeconds(), this.cache());
        DecryptSingleEncryptedDataKey _639_decryptClosure = _nw35;
        Result<DecryptionMaterials, DafnySequence<software.amazon.cryptography.materialproviders.internaldafny.types.Error>> _640_outcome = _out93 = Actions_Compile.__default.ReduceToSuccess(EncryptedDataKey._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _639_decryptClosure, _636_edksToAttempt);
        Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _642_valueOrError4 = null;
        _642_valueOrError4 = _640_outcome.MapFailure(SealedDecryptionMaterials._typeDescriptor(), (TypeDescriptor<DafnySequence<software.amazon.cryptography.materialproviders.internaldafny.types.Error>>)DafnySequence._typeDescriptor(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _643_errors_boxed0 -> {
            DafnySequence _643_errors = _643_errors_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_CollectionOfErrors((DafnySequence<? extends software.amazon.cryptography.materialproviders.internaldafny.types.Error>)_643_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured KMS Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`."));
        });
        if (_642_valueOrError4.IsFailure(SealedDecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _642_valueOrError4.PropagateFailure(SealedDecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptionMaterials _641_SealedDecryptionMaterials = _642_valueOrError4.Extract(SealedDecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        res = Result.create_Success(OnDecryptOutput.create(_641_SealedDecryptionMaterials));
        return res;
    }

    public Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetActiveCacheId(DafnySequence<? extends Character> branchKeyId, DafnySequence<? extends Byte> branchKeyIdUtf8, AtomicPrimitivesClient cryptoPrimitives) {
        Result<DafnySequence<? extends Byte>, Error> _out95;
        Result<DafnySequence<? extends Byte>, Error> _out94;
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> cacheId = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Outcome<Object> _644_valueOrError0 = Outcome.Default();
        _644_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UTF8.__default.Decode(branchKeyIdUtf8).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError).is_Success() && (Boolean)Helpers.Let(UTF8.__default.Decode(branchKeyIdUtf8).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError).dtor_value(), boxed36 -> {
            DafnySequence _pat_let18_0 = boxed36;
            return (boolean)((Boolean)Helpers.Let((Object)_pat_let18_0, boxed37 -> {
                DafnySequence _645_branchKeyId = boxed37;
                return BigInteger.valueOf(_645_branchKeyId.length()).signum() != -1 && BigInteger.valueOf(_645_branchKeyId.length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT32__LIMIT()) < 0;
            }));
        }) != false, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Branch Key ID Length")));
        if (_644_valueOrError0.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _644_valueOrError0.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence<? extends Character> _646_branchKeyId = UTF8.__default.Decode(branchKeyIdUtf8).dtor_value();
        DafnySequence<? extends Byte> _647_lenBranchKey = StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(_646_branchKeyId.cardinalityInt());
        DigestAlgorithm _648_hashAlgorithm = DigestAlgorithm.create_SHA__512();
        Result<DafnySequence<? extends Byte>, Error> _649_maybeBranchKeyDigest = _out94 = cryptoPrimitives.Digest(DigestInput.create(_648_hashAlgorithm, branchKeyIdUtf8));
        Result<Object, Object> _651_valueOrError1 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _651_valueOrError1 = _649_maybeBranchKeyDigest.MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _652_e_boxed0 -> {
            Error _652_e = _652_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_652_e);
        });
        if (_651_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _651_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence _650_branchKeyDigest = (DafnySequence)_651_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<DafnySequence<? extends Byte>, Object> _654_valueOrError2 = Result.Default(ValidUTF8Bytes.defaultValue());
        _654_valueOrError2 = UTF8.__default.Encode(__default.EXPRESSION__ATTRIBUTE__VALUE__STATUS__VALUE()).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_654_valueOrError2.IsFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _654_valueOrError2.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence<? extends Byte> _653_activeUtf8 = _654_valueOrError2.Extract(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        DafnySequence _655_identifier = DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(_647_lenBranchKey, (DafnySequence)_650_branchKeyDigest), (DafnySequence)DafnySequence.of((byte[])new byte[]{0})), _653_activeUtf8);
        Result<DafnySequence<? extends Byte>, Error> _656_maybeCacheIdDigest = _out95 = cryptoPrimitives.Digest(DigestInput.create(_648_hashAlgorithm, (DafnySequence<? extends Byte>)_655_identifier));
        Result<Object, Object> _658_valueOrError3 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _658_valueOrError3 = _656_maybeCacheIdDigest.MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _659_e_boxed0 -> {
            Error _659_e = _659_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_659_e);
        });
        if (_658_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _658_valueOrError3.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence _657_cacheDigest = (DafnySequence)_658_valueOrError3.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Outcome<Object> _660_valueOrError4 = Outcome.Default();
        _660_valueOrError4 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Objects.equals(BigInteger.valueOf(_657_cacheDigest.length()), Digest_Compile.__default.Length(_648_hashAlgorithm)), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Digest generated a message not equal to the expected length.")));
        if (_660_valueOrError4.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _660_valueOrError4.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        cacheId = Result.create_Success(_657_cacheDigest.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)BigInteger.valueOf(32L))));
        return cacheId;
    }

    public Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetActiveHierarchicalMaterials(DafnySequence<? extends Character> branchKeyId, DafnySequence<? extends Byte> cacheId, IKeyStoreClient keyStore) {
        Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> material = Result.Default(BranchKeyMaterials.Default());
        GetCacheEntryInput _661_getCacheInput = GetCacheEntryInput.create(cacheId, Option.create_None());
        Result<GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out96 = __default.getEntry(this.cache(), _661_getCacheInput);
        Result<GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _662_getCacheOutput = _out96;
        if (_662_getCacheOutput.is_Failure()) {
            long _out98;
            Result<GetActiveBranchKeyOutput, software.amazon.cryptography.keystore.internaldafny.types.Error> _out97;
            Result<GetActiveBranchKeyOutput, software.amazon.cryptography.keystore.internaldafny.types.Error> _663_maybeRawBranchKeyMaterials = _out97 = keyStore.GetActiveBranchKey(GetActiveBranchKeyInput.create(branchKeyId));
            Result<GetActiveBranchKeyOutput, Object> _665_valueOrError0 = Result.Default(GetActiveBranchKeyOutput.Default());
            _665_valueOrError0 = _663_maybeRawBranchKeyMaterials.MapFailure(GetActiveBranchKeyOutput._typeDescriptor(), software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _666_e_boxed0 -> {
                software.amazon.cryptography.keystore.internaldafny.types.Error _666_e = _666_e_boxed0;
                return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyKeyStore(_666_e);
            });
            if (_665_valueOrError0.IsFailure(GetActiveBranchKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _665_valueOrError0.PropagateFailure(GetActiveBranchKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            GetActiveBranchKeyOutput _664_rawBranchKeyMaterials = _665_valueOrError0.Extract(GetActiveBranchKeyOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            BranchKeyMaterials _667_branchKeyMaterials = BranchKeyMaterials.create(_664_rawBranchKeyMaterials.dtor_branchKeyVersion(), _664_rawBranchKeyMaterials.dtor_branchKey());
            long _668_now = _out98 = Time.__default.CurrentRelativeTime().longValue();
            Outcome<Object> _669_valueOrError1 = Outcome.Default();
            _669_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BigInteger.valueOf(_668_now).add(BigInteger.valueOf(this.ttlSeconds())).compareTo(StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT()) < 0, software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"INT64 Overflow when putting cache entry.")));
            if (_669_valueOrError1.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _669_valueOrError1.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            PutCacheEntryInput _670_putCacheEntryInput = PutCacheEntryInput.create(cacheId, Materials.create_BranchKey(_667_branchKeyMaterials), _668_now, this.ttlSeconds() + _668_now, Option.create_None(), Option.create_None());
            Result<Tuple0, Object> _672_valueOrError2 = Result.Default(Tuple0.Default());
            Result<Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out99 = __default.putEntry(this.cache(), _670_putCacheEntryInput);
            _672_valueOrError2 = _out99;
            if (_672_valueOrError2.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _672_valueOrError2.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            Tuple0 _671___v0 = _672_valueOrError2.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            material = Result.create_Success(_667_branchKeyMaterials);
            return material;
        }
        Outcome<Object> _673_valueOrError3 = Outcome.Default();
        _673_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _662_getCacheOutput.dtor_value().dtor_materials().is_BranchKey() && Objects.equals(_662_getCacheOutput.dtor_value().dtor_materials(), Materials.create_BranchKey(_662_getCacheOutput.dtor_value().dtor_materials().dtor_BranchKey())), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Material Type.")));
        if (_673_valueOrError3.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            material = _673_valueOrError3.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
            return material;
        }
        material = Result.create_Success(_662_getCacheOutput.dtor_value().dtor_materials().dtor_BranchKey());
        return material;
    }

    public IKeyStoreClient keyStore() {
        return this._keyStore;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public Option<IBranchKeyIdSupplier> branchKeyIdSupplier() {
        return this._branchKeyIdSupplier;
    }

    public Option<DafnySequence<? extends Character>> branchKeyId() {
        return this._branchKeyId;
    }

    public long ttlSeconds() {
        return this._ttlSeconds;
    }

    public int maxCacheSize() {
        return this._maxCacheSize;
    }

    public SynchronizedLocalCMC cache() {
        return this._cache;
    }

    public static TypeDescriptor<AwsKmsHierarchicalKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsHierarchicalKeyring_Compile.AwsKmsHierarchicalKeyring";
    }
}

