/*
 * Decompiled with CFR 0.152.
 */
package RawRSAKeyring_Compile;

import BoundedInts_Compile.uint8;
import EdkWrapping_Compile.UnwrapEdkMaterialOutput;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import RawRSAKeyring_Compile.RsaGenerateAndWrapKeyMaterial;
import RawRSAKeyring_Compile.RsaUnwrapInfo;
import RawRSAKeyring_Compile.RsaUnwrapKeyMaterial;
import RawRSAKeyring_Compile.RsaWrapInfo;
import RawRSAKeyring_Compile.RsaWrapKeyMaterial;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.__default;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.RSAPaddingMode;

public class RawRSAKeyring
implements VerifiableInterface,
IKeyring {
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public DafnySequence<? extends Byte> _keyNamespace = ValidUTF8Bytes.defaultValue();
    public DafnySequence<? extends Byte> _keyName = ValidUTF8Bytes.defaultValue();
    public RSAPaddingMode _paddingScheme = RSAPaddingMode.Default();
    public Option<DafnySequence<? extends Byte>> _publicKey = Option.Default();
    public Option<DafnySequence<? extends Byte>> _privateKey = Option.Default();
    private static final TypeDescriptor<RawRSAKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(RawRSAKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out141 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out141;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out142 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out142;
    }

    public void __ctor(DafnySequence<? extends Byte> namespace, DafnySequence<? extends Byte> name, Option<DafnySequence<? extends Byte>> publicKey, Option<DafnySequence<? extends Byte>> privateKey, RSAPaddingMode paddingScheme, AtomicPrimitivesClient cryptoPrimitives) {
        this._keyNamespace = namespace;
        this._keyName = name;
        this._paddingScheme = paddingScheme;
        this._publicKey = publicKey;
        this._privateKey = privateKey;
        this._cryptoPrimitives = cryptoPrimitives;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> output = null;
        Outcome<Object> _902_valueOrError0 = Outcome.Default();
        _902_valueOrError0 = __default.Need(Error._typeDescriptor(), this.publicKey().is_Some() && BigInteger.valueOf(this.publicKey().Extract((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor())).length()).signum() == 1, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"A RawRSAKeyring without a public key cannot provide OnEncrypt")));
        if (_902_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _902_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return output;
        }
        EncryptionMaterials _903_materials = input.dtor_materials();
        AlgorithmSuiteInfo _904_suite = _903_materials.dtor_algorithmSuite();
        RsaWrapKeyMaterial _nw47 = new RsaWrapKeyMaterial();
        _nw47.__ctor(this.publicKey().dtor_value(), this.paddingScheme(), this.cryptoPrimitives());
        RsaWrapKeyMaterial _905_wrap = _nw47;
        RsaGenerateAndWrapKeyMaterial _nw48 = new RsaGenerateAndWrapKeyMaterial();
        _nw48.__ctor(this.publicKey().dtor_value(), this.paddingScheme(), this.cryptoPrimitives());
        RsaGenerateAndWrapKeyMaterial _906_generateAndWrap = _nw48;
        Result<WrapEdkMaterialOutput<RsaWrapInfo>, Object> _908_valueOrError1 = Result.Default(WrapEdkMaterialOutput.Default(RsaWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<RsaWrapInfo>, Error> _out143 = EdkWrapping_Compile.__default.WrapEdkMaterial(RsaWrapInfo._typeDescriptor(), _903_materials, _905_wrap, _906_generateAndWrap);
        _908_valueOrError1 = _out143;
        if (_908_valueOrError1.IsFailure(WrapEdkMaterialOutput._typeDescriptor(RsaWrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            output = _908_valueOrError1.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(RsaWrapInfo._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return output;
        }
        WrapEdkMaterialOutput<RsaWrapInfo> _907_wrapOutput = _908_valueOrError1.Extract(WrapEdkMaterialOutput._typeDescriptor(RsaWrapInfo._typeDescriptor()), Error._typeDescriptor());
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _909_symmetricSigningKeyList = _907_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_907_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None();
        EncryptedDataKey _910_edk = EncryptedDataKey.create(this.keyNamespace(), this.keyName(), _907_wrapOutput.dtor_wrappedMaterial());
        if (_907_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _912_valueOrError2 = null;
            _912_valueOrError2 = Materials_Compile.__default.EncryptionMaterialAddDataKey(_903_materials, _907_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_910_edk}), _909_symmetricSigningKeyList);
            if (_912_valueOrError2.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                output = _912_valueOrError2.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return output;
            }
            EncryptionMaterials _911_result = _912_valueOrError2.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            output = Result.create_Success(OnEncryptOutput.create(_911_result));
            return output;
        }
        if (_907_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _914_valueOrError3 = null;
            _914_valueOrError3 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(_903_materials, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_910_edk}), _909_symmetricSigningKeyList);
            if (_914_valueOrError3.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                output = _914_valueOrError3.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return output;
            }
            EncryptionMaterials _913_result = _914_valueOrError3.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            output = Result.create_Success(OnEncryptOutput.create(_913_result));
            return output;
        }
        return output;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> output = null;
        Outcome<Object> _915_valueOrError0 = Outcome.Default();
        _915_valueOrError0 = __default.Need(Error._typeDescriptor(), this.privateKey().is_Some() && BigInteger.valueOf(this.privateKey().Extract((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor())).length()).signum() == 1, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"A RawRSAKeyring without a private key cannot provide OnEncrypt")));
        if (_915_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _915_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        DecryptionMaterials _916_materials = input.dtor_materials();
        Outcome<Object> _917_valueOrError1 = Outcome.Default();
        _917_valueOrError1 = __default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_916_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_917_valueOrError1.IsFailure(Error._typeDescriptor())) {
            output = _917_valueOrError1.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        DafnySequence _918_errors = DafnySequence.empty(Error._typeDescriptor());
        BigInteger _hi8 = BigInteger.valueOf(input.dtor_encryptedDataKeys().length());
        BigInteger _919_i = BigInteger.ZERO;
        while (_919_i.compareTo(_hi8) < 0) {
            if (this.ShouldDecryptEDK((EncryptedDataKey)input.dtor_encryptedDataKeys().select(Helpers.toInt((BigInteger)_919_i)))) {
                Result<UnwrapEdkMaterialOutput<RsaUnwrapInfo>, Error> _out144;
                EncryptedDataKey _920_edk = (EncryptedDataKey)input.dtor_encryptedDataKeys().select(Helpers.toInt((BigInteger)_919_i));
                RsaUnwrapKeyMaterial _nw49 = new RsaUnwrapKeyMaterial();
                _nw49.__ctor(this.privateKey().Extract((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor())), this.paddingScheme(), this.cryptoPrimitives());
                RsaUnwrapKeyMaterial _921_unwrap = _nw49;
                Result<UnwrapEdkMaterialOutput<RsaUnwrapInfo>, Error> _922_unwrapOutput = _out144 = EdkWrapping_Compile.__default.UnwrapEdkMaterial(RsaUnwrapInfo._typeDescriptor(), _920_edk.dtor_ciphertext(), _916_materials, _921_unwrap);
                if (_922_unwrapOutput.is_Success()) {
                    Result<DecryptionMaterials, Error> _924_valueOrError2 = null;
                    _924_valueOrError2 = Materials_Compile.__default.DecryptionMaterialsAddDataKey(_916_materials, _922_unwrapOutput.dtor_value().dtor_plaintextDataKey(), _922_unwrapOutput.dtor_value().dtor_symmetricSigningKey());
                    if (_924_valueOrError2.IsFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                        output = _924_valueOrError2.PropagateFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                        return output;
                    }
                    DecryptionMaterials _923_returnMaterials = _924_valueOrError2.Extract(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
                    output = Result.create_Success(OnDecryptOutput.create(_923_returnMaterials));
                    return output;
                }
                _918_errors = DafnySequence.concatenate((DafnySequence)_918_errors, (DafnySequence)DafnySequence.of(Error._typeDescriptor(), (Object[])new Error[]{_922_unwrapOutput.dtor_error()}));
            } else {
                _918_errors = DafnySequence.concatenate((DafnySequence)_918_errors, (DafnySequence)DafnySequence.of(Error._typeDescriptor(), (Object[])new Error[]{Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"EncryptedDataKey "), String_Compile.__default.Base10Int2String(_919_i)), (DafnySequence)DafnySequence.asString((String)" did not match RSAKeyring. ")))}));
            }
            _919_i = _919_i.add(BigInteger.ONE);
        }
        output = Result.create_Failure(Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_918_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"Raw RSA Key was unable to decrypt any encrypted data key. The list of encountered Exceptions is avaible via `list`.")));
        return output;
    }

    public boolean ShouldDecryptEDK(EncryptedDataKey edk) {
        return UTF8.__default.ValidUTF8Seq(edk.dtor_keyProviderInfo()) && edk.dtor_keyProviderInfo().equals(this.keyName()) && edk.dtor_keyProviderId().equals(this.keyNamespace()) && BigInteger.valueOf(edk.dtor_ciphertext().length()).signum() == 1;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public DafnySequence<? extends Byte> keyNamespace() {
        return this._keyNamespace;
    }

    public DafnySequence<? extends Byte> keyName() {
        return this._keyName;
    }

    public RSAPaddingMode paddingScheme() {
        return this._paddingScheme;
    }

    public Option<DafnySequence<? extends Byte>> publicKey() {
        return this._publicKey;
    }

    public Option<DafnySequence<? extends Byte>> privateKey() {
        return this._privateKey;
    }

    public static TypeDescriptor<RawRSAKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "RawRSAKeyring_Compile.RawRSAKeyring";
    }
}

