/*
 * Decompiled with CFR 0.152.
 */
package LocalCMC_Compile;

import BoundedInts_Compile.uint8;
import DafnyLibraries.MutableMap;
import LocalCMC_Compile.CacheEntry;
import LocalCMC_Compile.DoublyLinkedCacheEntryList;
import LocalCMC_Compile.__default;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Tuple0;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.internaldafny.types.DeleteCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache;
import software.amazon.cryptography.materialproviders.internaldafny.types.PositiveInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.UpdaterUsageMetadataInput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_ICryptographicMaterialsCache;

public class LocalCMC
implements ICryptographicMaterialsCache {
    public DoublyLinkedCacheEntryList queue = null;
    public MutableMap<DafnySequence<? extends Byte>, CacheEntry> cache = null;
    public BigInteger _entryCapacity = BigInteger.ZERO;
    public BigInteger _entryPruningTailSize = BigInteger.ZERO;
    private static final TypeDescriptor<LocalCMC> _TYPE = TypeDescriptor.referenceWithInitializer(LocalCMC.class, () -> null);

    @Override
    public Result<Tuple0, Error> PutCacheEntry(PutCacheEntryInput input) {
        Result<Tuple0, Error> _out69 = _Companion_ICryptographicMaterialsCache.PutCacheEntry(this, input);
        return _out69;
    }

    @Override
    public Result<Tuple0, Error> UpdaterUsageMetadata(UpdaterUsageMetadataInput input) {
        Result<Tuple0, Error> _out70 = _Companion_ICryptographicMaterialsCache.UpdaterUsageMetadata(this, input);
        return _out70;
    }

    @Override
    public Result<GetCacheEntryOutput, Error> GetCacheEntry(GetCacheEntryInput input) {
        Result<GetCacheEntryOutput, Error> _out71 = _Companion_ICryptographicMaterialsCache.GetCacheEntry(this, input);
        return _out71;
    }

    @Override
    public Result<Tuple0, Error> DeleteCacheEntry(DeleteCacheEntryInput input) {
        Result<Tuple0, Error> _out72 = _Companion_ICryptographicMaterialsCache.DeleteCacheEntry(this, input);
        return _out72;
    }

    public void __ctor(BigInteger entryCapacity_k, BigInteger entryPruningTailSize_k) {
        this._entryCapacity = entryCapacity_k;
        this._entryPruningTailSize = entryPruningTailSize_k;
        MutableMap _nw27 = new MutableMap(DafnySequence._typeDescriptor(uint8._typeDescriptor()), CacheEntry._typeDescriptor());
        this.cache = _nw27;
        DoublyLinkedCacheEntryList _nw28 = new DoublyLinkedCacheEntryList();
        _nw28.__ctor();
        this.queue = _nw28;
    }

    @Override
    public Result<GetCacheEntryOutput, Error> GetCacheEntry_k(GetCacheEntryInput input) {
        Result<GetCacheEntryOutput, Error> output = null;
        if (this.cache.Keys().contains(input.dtor_identifier())) {
            CacheEntry _582_entry;
            long _out73 = Time.__default.CurrentRelativeTime();
            long _581_now = _out73;
            if (_581_now <= (_582_entry = this.cache.Select(input.dtor_identifier())).expiryTime()) {
                this.queue.moveToFront(_582_entry);
                output = Result.create_Success(GetCacheEntryOutput.create(_582_entry.materials(), _582_entry.creationTime(), _582_entry.expiryTime(), _582_entry.messagesUsed, _582_entry.bytesUsed));
                Result<Tuple0, Object> _584_valueOrError0 = Result.Default(Tuple0.Default());
                Result<Tuple0, Error> _out74 = this.pruning();
                _584_valueOrError0 = _out74;
                if (_584_valueOrError0.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor())) {
                    output = _584_valueOrError0.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor(), GetCacheEntryOutput._typeDescriptor());
                    return output;
                }
                Tuple0 tuple0 = _584_valueOrError0.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor());
            } else {
                Result<Tuple0, Object> _586_valueOrError1 = Result.Default(Tuple0.Default());
                Result<Tuple0, Error> _out75 = this.DeleteCacheEntry_k(DeleteCacheEntryInput.create(input.dtor_identifier()));
                _586_valueOrError1 = _out75;
                if (_586_valueOrError1.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor())) {
                    output = _586_valueOrError1.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor(), GetCacheEntryOutput._typeDescriptor());
                    return output;
                }
                Tuple0 _585___v1 = _586_valueOrError1.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor());
                output = Result.create_Failure(Error.create_EntryDoesNotExist((DafnySequence<? extends Character>)DafnySequence.asString((String)"Entry past TTL")));
            }
        } else {
            output = Result.create_Failure(Error.create_EntryDoesNotExist((DafnySequence<? extends Character>)DafnySequence.asString((String)"Entry does not exist")));
        }
        return output;
    }

    @Override
    public Result<Tuple0, Error> PutCacheEntry_k(PutCacheEntryInput input) {
        Result<Object, Error> output = Result.Default(Tuple0.Default());
        if (this.entryCapacity().signum() == 0) {
            output = Result.create_Success(Tuple0.create());
            return output;
        }
        Outcome<Object> _587_valueOrError0 = Outcome.Default();
        _587_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), !this.cache.Keys().contains(input.dtor_identifier()), Error.create_EntryAlreadyExists((DafnySequence<? extends Character>)DafnySequence.asString((String)"Updating an entry is not allowed, remove first.")));
        if (_587_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _587_valueOrError0.PropagateFailure(Error._typeDescriptor(), Tuple0._typeDescriptor());
            return output;
        }
        if (Objects.equals(this.entryCapacity(), this.cache.Size())) {
            Result<Tuple0, Object> _589_valueOrError1 = Result.Default(Tuple0.Default());
            Result<Tuple0, Error> _out76 = this.DeleteCacheEntry_k(DeleteCacheEntryInput.create(this.queue.tail.dtor_deref().identifier()));
            _589_valueOrError1 = _out76;
            if (_589_valueOrError1.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor())) {
                output = _589_valueOrError1.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0._typeDescriptor());
                return output;
            }
            Tuple0 tuple0 = _589_valueOrError1.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor());
        }
        CacheEntry _nw29 = new CacheEntry();
        _nw29.__ctor(input.dtor_materials(), input.dtor_identifier(), input.dtor_creationTime(), input.dtor_expiryTime(), input.dtor_messagesUsed().UnwrapOr(PositiveInteger._typeDescriptor(), 0), input.dtor_bytesUsed().UnwrapOr(PositiveInteger._typeDescriptor(), 0));
        CacheEntry _590_cell = _nw29;
        this.queue.pushCell(_590_cell);
        this.cache.Put(input.dtor_identifier(), _590_cell);
        output = Result.create_Success(Tuple0.create());
        return output;
    }

    @Override
    public Result<Tuple0, Error> DeleteCacheEntry_k(DeleteCacheEntryInput input) {
        Result<Tuple0, Error> output = Result.Default(Tuple0.Default());
        if (this.cache.Keys().contains(input.dtor_identifier())) {
            CacheEntry _591_cell = this.cache.Select(input.dtor_identifier());
            this.cache.Remove(input.dtor_identifier());
            this.queue.remove(_591_cell);
        }
        output = Result.create_Success(Tuple0.create());
        return output;
    }

    @Override
    public Result<Tuple0, Error> UpdaterUsageMetadata_k(UpdaterUsageMetadataInput input) {
        Result<Object, Error> output = Result.Default(Tuple0.Default());
        if (this.cache.Keys().contains(input.dtor_identifier())) {
            CacheEntry _592_cell = this.cache.Select(input.dtor_identifier());
            if (_592_cell.messagesUsed <= __default.INT32__MAX__VALUE() - 1 && _592_cell.bytesUsed <= __default.INT32__MAX__VALUE() - input.dtor_bytesUsed()) {
                int _rhs0 = _592_cell.messagesUsed + 1;
                int _rhs1 = _592_cell.bytesUsed + input.dtor_bytesUsed();
                CacheEntry _lhs0 = _592_cell;
                CacheEntry _lhs1 = _592_cell;
                _lhs0.messagesUsed = _rhs0;
                _lhs1.bytesUsed = _rhs1;
            } else {
                Result<Tuple0, Object> _594_valueOrError0 = Result.Default(Tuple0.Default());
                Result<Tuple0, Error> _out77 = this.DeleteCacheEntry_k(DeleteCacheEntryInput.create(input.dtor_identifier()));
                _594_valueOrError0 = _out77;
                if (_594_valueOrError0.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor())) {
                    output = _594_valueOrError0.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0._typeDescriptor());
                    return output;
                }
                Tuple0 tuple0 = _594_valueOrError0.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor());
            }
        }
        output = Result.create_Success(Tuple0.create());
        return output;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result<Tuple0, Error> pruning() {
        long _out78;
        Result result = Result.Default(Tuple0.Default());
        long _595_now = _out78 = Time.__default.CurrentRelativeTime().longValue();
        BigInteger _hi6 = this.entryPruningTailSize();
        BigInteger _596_i = BigInteger.ZERO;
        while (_596_i.compareTo(_hi6) < 0) {
            if (!this.queue.tail.is_Ptr()) return Result.create_Success(Tuple0.create());
            if (this.queue.tail.dtor_deref().expiryTime() >= _595_now) return Result.create_Success(Tuple0.create());
            Result<Tuple0, Object> _598_valueOrError0 = Result.Default(Tuple0.Default());
            Result<Tuple0, Error> _out79 = this.DeleteCacheEntry_k(DeleteCacheEntryInput.create(this.queue.tail.dtor_deref().identifier()));
            _598_valueOrError0 = _out79;
            if (_598_valueOrError0.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor())) {
                return _598_valueOrError0.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0._typeDescriptor());
            }
            Tuple0 tuple0 = _598_valueOrError0.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor());
            _596_i = _596_i.add(BigInteger.ONE);
        }
        return Result.create_Success(Tuple0.create());
    }

    public BigInteger entryCapacity() {
        return this._entryCapacity;
    }

    public BigInteger entryPruningTailSize() {
        return this._entryPruningTailSize;
    }

    public static TypeDescriptor<LocalCMC> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "LocalCMC_Compile.LocalCMC";
    }
}

