/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsKeyring_Compile;

import AwsArnParsing_Compile.AwsKmsIdentifier;
import AwsKmsKeyring_Compile.DecryptSingleEncryptedDataKey;
import AwsKmsKeyring_Compile.KmsGenerateAndWrapKeyMaterial;
import AwsKmsKeyring_Compile.KmsWrapInfo;
import AwsKmsKeyring_Compile.KmsWrapKeyMaterial;
import AwsKmsKeyring_Compile.OnDecryptEncryptedDataKeyFilter;
import BoundedInts_Compile.uint8;
import Constants_Compile.__default;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import Materials_Compile.SealedDecryptionMaterials;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class AwsKmsKeyring
implements VerifiableInterface,
IKeyring {
    public IKMSClient _client = null;
    public DafnySequence<? extends Character> _awsKmsKey = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    public AwsKmsIdentifier _awsKmsArn = null;
    private static final TypeDescriptor<AwsKmsKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out37 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out37;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out38 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out38;
    }

    public void __ctor(IKMSClient client, DafnySequence<? extends Character> awsKmsKey, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        Result<AwsKmsIdentifier, DafnySequence<? extends Character>> _323_parsedAwsKmsId = AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(awsKmsKey);
        this._client = client;
        this._awsKmsKey = awsKmsKey;
        this._awsKmsArn = _323_parsedAwsKmsId.dtor_value();
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> res = null;
        EncryptionMaterials _324_materials = input.dtor_materials();
        AlgorithmSuiteInfo _325_suite = input.dtor_materials().dtor_algorithmSuite();
        Result<Object, Object> _327_valueOrError0 = Result.Default(DafnyMap.empty());
        _327_valueOrError0 = AwsKmsUtils_Compile.__default.StringifyEncryptionContext(input.dtor_materials().dtor_encryptionContext());
        if (_327_valueOrError0.IsFailure((TypeDescriptor<DafnyMap>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor())) {
            res = _327_valueOrError0.PropagateFailure((TypeDescriptor<Object>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnyMap _326_stringifiedEncCtx = (DafnyMap)_327_valueOrError0.Extract((TypeDescriptor<Object>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor());
        KmsGenerateAndWrapKeyMaterial _nw0 = new KmsGenerateAndWrapKeyMaterial();
        _nw0.__ctor(this.client(), this.awsKmsKey(), this.grantTokens());
        KmsGenerateAndWrapKeyMaterial _328_kmsGenerateAndWrap = _nw0;
        KmsWrapKeyMaterial _nw1 = new KmsWrapKeyMaterial();
        _nw1.__ctor(this.client(), this.awsKmsKey(), this.grantTokens());
        KmsWrapKeyMaterial _329_kmsWrap = _nw1;
        Result<WrapEdkMaterialOutput<KmsWrapInfo>, Object> _331_valueOrError1 = Result.Default(WrapEdkMaterialOutput.Default(KmsWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<KmsWrapInfo>, Error> _out39 = EdkWrapping_Compile.__default.WrapEdkMaterial(KmsWrapInfo._typeDescriptor(), _324_materials, _329_kmsWrap, _328_kmsGenerateAndWrap);
        _331_valueOrError1 = _out39;
        if (_331_valueOrError1.IsFailure(WrapEdkMaterialOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            res = _331_valueOrError1.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        WrapEdkMaterialOutput<KmsWrapInfo> _330_wrapOutput = _331_valueOrError1.Extract(WrapEdkMaterialOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()), Error._typeDescriptor());
        DafnySequence<? extends Character> _332_kmsKeyArn = _330_wrapOutput.dtor_wrapInfo().dtor_kmsKeyArn();
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _333_symmetricSigningKeyList = _330_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_330_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None();
        Result<DafnySequence<? extends Byte>, Object> _335_valueOrError2 = Result.Default(ValidUTF8Bytes.defaultValue());
        _335_valueOrError2 = UTF8.__default.Encode(_332_kmsKeyArn).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_335_valueOrError2.IsFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor())) {
            res = _335_valueOrError2.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence<? extends Byte> _334_providerInfo = _335_valueOrError2.Extract(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor());
        Outcome<Object> _336_valueOrError3 = Outcome.Default();
        _336_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_334_providerInfo.length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS GenerateDataKey: Key ID too long.")));
        if (_336_valueOrError3.IsFailure(Error._typeDescriptor())) {
            res = _336_valueOrError3.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        EncryptedDataKey _337_edk = EncryptedDataKey.create(__default.PROVIDER__ID(), _334_providerInfo, _330_wrapOutput.dtor_wrappedMaterial());
        if (_330_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _339_valueOrError4 = null;
            _339_valueOrError4 = Materials_Compile.__default.EncryptionMaterialAddDataKey(_324_materials, _330_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_337_edk}), _333_symmetricSigningKeyList);
            if (_339_valueOrError4.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _339_valueOrError4.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _338_result = _339_valueOrError4.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput.create(_338_result));
            return res;
        }
        if (_330_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _341_valueOrError5 = null;
            _341_valueOrError5 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(_324_materials, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_337_edk}), _333_symmetricSigningKeyList);
            if (_341_valueOrError5.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _341_valueOrError5.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _340_result = _341_valueOrError5.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput.create(_340_result));
            return res;
        }
        return res;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<Error>> _out41;
        Result<OnDecryptOutput, Error> res = null;
        DecryptionMaterials _342_materials = input.dtor_materials();
        AlgorithmSuiteInfo _343_suite = input.dtor_materials().dtor_algorithmSuite();
        Outcome<Object> _344_valueOrError0 = Outcome.Default();
        _344_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_342_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_344_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _344_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        OnDecryptEncryptedDataKeyFilter _nw2 = new OnDecryptEncryptedDataKeyFilter();
        _nw2.__ctor(this.awsKmsKey());
        OnDecryptEncryptedDataKeyFilter _345_filter = _nw2;
        Result<Object, Object> _347_valueOrError1 = Result.Default(DafnySequence.empty(EncryptedDataKey._typeDescriptor()));
        Result<DafnySequence<? extends EncryptedDataKey>, Error> _out40 = Actions_Compile.__default.FilterWithResult(EncryptedDataKey._typeDescriptor(), Error._typeDescriptor(), _345_filter, input.dtor_encryptedDataKeys());
        _347_valueOrError1 = _out40;
        if (_347_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor())) {
            res = _347_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _346_edksToAttempt = (DafnySequence)_347_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor());
        Outcome<Object> _348_valueOrError2 = Outcome.Default();
        _348_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_346_edksToAttempt.length()).signum() == 1, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unable to decrypt data key: No Encrypted Data Keys found to match.")));
        if (_348_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _348_valueOrError2.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptSingleEncryptedDataKey _nw3 = new DecryptSingleEncryptedDataKey();
        _nw3.__ctor(_342_materials, this.client(), this.awsKmsKey(), this.grantTokens());
        DecryptSingleEncryptedDataKey _349_decryptClosure = _nw3;
        Result<DecryptionMaterials, DafnySequence<Error>> _350_outcome = _out41 = Actions_Compile.__default.ReduceToSuccess(EncryptedDataKey._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _349_decryptClosure, _346_edksToAttempt);
        Result<DecryptionMaterials, Error> _352_valueOrError3 = null;
        _352_valueOrError3 = _350_outcome.MapFailure(SealedDecryptionMaterials._typeDescriptor(), (TypeDescriptor<DafnySequence<Error>>)DafnySequence._typeDescriptor(Error._typeDescriptor()), Error._typeDescriptor(), _353_errors_boxed0 -> {
            DafnySequence _353_errors = _353_errors_boxed0;
            return Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_353_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured KMS Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`."));
        });
        if (_352_valueOrError3.IsFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
            res = _352_valueOrError3.PropagateFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptionMaterials _351_SealedDecryptionMaterials = _352_valueOrError3.Extract(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        res = Result.create_Success(OnDecryptOutput.create(_351_SealedDecryptionMaterials));
        return res;
    }

    public IKMSClient client() {
        return this._client;
    }

    public DafnySequence<? extends Character> awsKmsKey() {
        return this._awsKmsKey;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public AwsKmsIdentifier awsKmsArn() {
        return this._awsKmsArn;
    }

    public static TypeDescriptor<AwsKmsKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsKeyring_Compile.AwsKmsKeyring";
    }
}

