/*
 * Decompiled with CFR 0.152.
 */
package AESEncryption;

import AESEncryption.AES_GCM;
import AESEncryption.__default;
import BoundedInts_Compile.uint8;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.primitives.internaldafny.types.AESDecryptInput;
import software.amazon.cryptography.primitives.internaldafny.types.AESEncryptInput;
import software.amazon.cryptography.primitives.internaldafny.types.AESEncryptOutput;
import software.amazon.cryptography.primitives.internaldafny.types.AES__GCM;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.types.OpaqueError;

public abstract class _ExternBase___default {
    private static final TypeDescriptor<__default> _TYPE = TypeDescriptor.referenceWithInitializer(__default.class, () -> null);

    public static AESEncryptOutput EncryptionOutputFromByteSeq(DafnySequence<? extends Byte> s, AES__GCM encAlg) {
        DafnySequence _3_cipherText = s.take(BigInteger.valueOf(s.length()).subtract(BigInteger.valueOf(encAlg.dtor_tagLength())));
        DafnySequence _4_authTag = s.drop(BigInteger.valueOf(s.length()).subtract(BigInteger.valueOf(encAlg.dtor_tagLength())));
        return AESEncryptOutput.create((DafnySequence<? extends Byte>)_3_cipherText, (DafnySequence<? extends Byte>)_4_authTag);
    }

    public static Result<AESEncryptOutput, Error> AESEncrypt(AESEncryptInput input) {
        Result<AESEncryptOutput, Error> res = Result.Default(AESEncryptOutput.Default());
        Outcome<Object> _5_valueOrError0 = Outcome.Default();
        _5_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Objects.equals(BigInteger.valueOf(input.dtor_iv().length()), BigInteger.valueOf(input.dtor_encAlg().dtor_ivLength())) && Objects.equals(BigInteger.valueOf(input.dtor_key().length()), BigInteger.valueOf(input.dtor_encAlg().dtor_keyLength())), Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"Request does not match algorithm.")));
        if (_5_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _5_valueOrError0.PropagateFailure(Error._typeDescriptor(), AESEncryptOutput._typeDescriptor());
            return res;
        }
        AESEncryptInput _let_tmp_rhs0 = input;
        AES__GCM _6_encAlg = _let_tmp_rhs0._encAlg;
        DafnySequence<? extends Byte> _7_iv = _let_tmp_rhs0._iv;
        DafnySequence<? extends Byte> _8_key = _let_tmp_rhs0._key;
        DafnySequence<? extends Byte> _9_msg = _let_tmp_rhs0._msg;
        DafnySequence<? extends Byte> _10_aad = _let_tmp_rhs0._aad;
        Result<AESEncryptOutput, Object> _12_valueOrError1 = Result.Default(AESEncryptOutput.Default());
        Result<AESEncryptOutput, Error> _out1 = AES_GCM.AESEncryptExtern(_6_encAlg, _7_iv, _8_key, _9_msg, _10_aad);
        _12_valueOrError1 = _out1;
        if (_12_valueOrError1.IsFailure(AESEncryptOutput._typeDescriptor(), OpaqueError._typeDescriptor())) {
            res = _12_valueOrError1.PropagateFailure(AESEncryptOutput._typeDescriptor(), OpaqueError._typeDescriptor(), AESEncryptOutput._typeDescriptor());
            return res;
        }
        AESEncryptOutput _11_value = _12_valueOrError1.Extract(AESEncryptOutput._typeDescriptor(), OpaqueError._typeDescriptor());
        Outcome<Object> _13_valueOrError2 = Outcome.Default();
        _13_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Objects.equals(BigInteger.valueOf(_11_value.dtor_cipherText().length()), BigInteger.valueOf(_9_msg.length())), Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"AESEncrypt did not return cipherText of expected length")));
        if (_13_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _13_valueOrError2.PropagateFailure(Error._typeDescriptor(), AESEncryptOutput._typeDescriptor());
            return res;
        }
        Outcome<Object> _14_valueOrError3 = Outcome.Default();
        _14_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Objects.equals(BigInteger.valueOf(_11_value.dtor_authTag().length()), BigInteger.valueOf(_6_encAlg.dtor_tagLength())), Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"AESEncryption did not return valid tag")));
        if (_14_valueOrError3.IsFailure(Error._typeDescriptor())) {
            res = _14_valueOrError3.PropagateFailure(Error._typeDescriptor(), AESEncryptOutput._typeDescriptor());
            return res;
        }
        res = Result.create_Success(_11_value);
        return res;
    }

    public static Result<DafnySequence<? extends Byte>, Error> AESDecrypt(AESDecryptInput input) {
        Result<DafnySequence<? extends Byte>, Error> res = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Outcome<Object> _15_valueOrError0 = Outcome.Default();
        _15_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Objects.equals(BigInteger.valueOf(input.dtor_key().length()), BigInteger.valueOf(input.dtor_encAlg().dtor_keyLength())) && Objects.equals(BigInteger.valueOf(input.dtor_iv().length()), BigInteger.valueOf(input.dtor_encAlg().dtor_ivLength())) && Objects.equals(BigInteger.valueOf(input.dtor_authTag().length()), BigInteger.valueOf(input.dtor_encAlg().dtor_tagLength())), Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"Request does not match algorithm.")));
        if (_15_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _15_valueOrError0.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return res;
        }
        AESDecryptInput _let_tmp_rhs1 = input;
        AES__GCM _16_encAlg = _let_tmp_rhs1._encAlg;
        DafnySequence<? extends Byte> _17_key = _let_tmp_rhs1._key;
        DafnySequence<? extends Byte> _18_cipherTxt = _let_tmp_rhs1._cipherTxt;
        DafnySequence<? extends Byte> _19_authTag = _let_tmp_rhs1._authTag;
        DafnySequence<? extends Byte> _20_iv = _let_tmp_rhs1._iv;
        DafnySequence<? extends Byte> _21_aad = _let_tmp_rhs1._aad;
        Result<Object, Object> _23_valueOrError1 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out2 = AES_GCM.AESDecryptExtern(_16_encAlg, _17_key, _18_cipherTxt, _19_authTag, _20_iv, _21_aad);
        _23_valueOrError1 = _out2;
        if (_23_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), OpaqueError._typeDescriptor())) {
            res = _23_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), OpaqueError._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return res;
        }
        DafnySequence _22_value = (DafnySequence)_23_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), OpaqueError._typeDescriptor());
        Outcome<Object> _24_valueOrError2 = Outcome.Default();
        _24_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Objects.equals(BigInteger.valueOf(_18_cipherTxt.length()), BigInteger.valueOf(_22_value.length())), Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"AESDecrypt did not return plaintext of expected length")));
        if (_24_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _24_valueOrError2.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return res;
        }
        res = Result.create_Success(_22_value);
        return res;
    }

    public static TypeDescriptor<__default> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AESEncryption_Compile._default";
    }
}

