/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.sinks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import software.amazon.cloudwatchlogs.emf.model.MetricsContext;
import software.amazon.cloudwatchlogs.emf.sinks.ISink;

public class MultiSink
implements ISink {
    @NonNull
    private List<ISink> sinks;

    @Override
    public void accept(MetricsContext context) {
        for (ISink sink : this.sinks) {
            sink.accept(context);
        }
    }

    MultiSink(@NonNull List<ISink> sinks) {
        if (sinks == null) {
            throw new NullPointerException("sinks is marked non-null but is null");
        }
        this.sinks = sinks;
    }

    public static MultiSinkBuilder builder() {
        return new MultiSinkBuilder();
    }

    public static class MultiSinkBuilder {
        private ArrayList<ISink> sinks;

        MultiSinkBuilder() {
        }

        public MultiSinkBuilder sink(ISink sink) {
            if (this.sinks == null) {
                this.sinks = new ArrayList();
            }
            this.sinks.add(sink);
            return this;
        }

        public MultiSinkBuilder sinks(Collection<? extends ISink> sinks) {
            if (sinks == null) {
                throw new NullPointerException("sinks cannot be null");
            }
            if (this.sinks == null) {
                this.sinks = new ArrayList();
            }
            this.sinks.addAll(sinks);
            return this;
        }

        public MultiSinkBuilder clearSinks() {
            if (this.sinks != null) {
                this.sinks.clear();
            }
            return this;
        }

        public MultiSink build() {
            List<ISink> sinks;
            switch (this.sinks == null ? 0 : this.sinks.size()) {
                case 0: {
                    sinks = Collections.emptyList();
                    break;
                }
                case 1: {
                    sinks = Collections.singletonList(this.sinks.get(0));
                    break;
                }
                default: {
                    sinks = Collections.unmodifiableList(new ArrayList<ISink>(this.sinks));
                }
            }
            return new MultiSink(sinks);
        }

        public String toString() {
            return "MultiSink.MultiSinkBuilder(sinks=" + this.sinks + ")";
        }
    }
}

