/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import software.amazon.cloudwatchlogs.emf.exception.EMFClientException;

public class Jackson {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final ObjectWriter writer = objectMapper.writer();

    public static String toJsonString(Object value) {
        try {
            return writer.writeValueAsString(value);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T fromJsonString(String json, Class<T> clazz) {
        return Jackson.fromJsonString(json, objectMapper, clazz);
    }

    public static <T> T fromJsonString(String json, ObjectMapper objectMapper, Class<T> clazz) {
        if (json == null) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (Exception e) {
            throw new EMFClientException("Unable to parse Json String.", e);
        }
    }

    public static JsonNode jsonNodeOf(String json) {
        return Jackson.fromJsonString(json, JsonNode.class);
    }
}

