/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.cloudwatchlogs.emf.model.DimensionSet;
import software.amazon.cloudwatchlogs.emf.model.Metadata;
import software.amazon.cloudwatchlogs.emf.model.MetricDefinition;
import software.amazon.cloudwatchlogs.emf.model.MetricDirective;
import software.amazon.cloudwatchlogs.emf.model.RootNode;
import software.amazon.cloudwatchlogs.emf.model.Unit;

public class MetricsContext {
    private RootNode rootNode;
    private MetricDirective metricDirective;

    public MetricsContext() {
        this(new RootNode());
    }

    public MetricsContext(RootNode rootNode) {
        this.rootNode = rootNode;
        this.metricDirective = rootNode.getAws().createMetricDirective();
    }

    public MetricsContext(String namespace, Map<String, Object> properties, List<DimensionSet> dimensionSets, DimensionSet defaultDimensionSet) {
        this();
        this.setNamespace(namespace);
        this.setDefaultDimensions(defaultDimensionSet);
        for (DimensionSet dimensionSet : dimensionSets) {
            this.putDimension(dimensionSet);
        }
        for (Map.Entry entry : properties.entrySet()) {
            this.putProperty((String)entry.getKey(), entry.getValue());
        }
    }

    public String getNamespace() {
        return this.metricDirective.getNamespace();
    }

    public void setNamespace(String namespace) {
        this.metricDirective.setNamespace(namespace);
    }

    public DimensionSet getDefaultDimensions() {
        return this.metricDirective.getDefaultDimensions();
    }

    public void setDefaultDimensions(DimensionSet dimensionSet) {
        this.metricDirective.setDefaultDimensions(dimensionSet);
    }

    public boolean hasDefaultDimensions() {
        return this.getDefaultDimensions().getDimensionKeys().size() > 0;
    }

    public void putMetric(String key, double value, Unit unit) {
        this.metricDirective.putMetric(key, value, unit);
    }

    public void putMetric(String key, double value) {
        this.putMetric(key, value, Unit.NONE);
    }

    public void putProperty(String name, Object value) {
        this.rootNode.putProperty(name, value);
    }

    public Object getProperty(String name) {
        return this.rootNode.getProperties().get(name);
    }

    public void putDimension(DimensionSet dimensionSet) {
        this.metricDirective.putDimensionSet(dimensionSet);
    }

    public void putDimension(String dimension, String value) {
        this.metricDirective.putDimensionSet(DimensionSet.of(dimension, value));
    }

    public List<DimensionSet> getDimensions() {
        return this.metricDirective.getAllDimensions();
    }

    public void setDimensions(DimensionSet ... dimensionSets) {
        this.metricDirective.setDimensions(Arrays.asList(dimensionSets));
    }

    public void putMetadata(String key, Object value) {
        this.rootNode.getAws().putCustomMetadata(key, value);
    }

    public MetricsContext createCopyWithContext() {
        return new MetricsContext(this.metricDirective.getNamespace(), this.rootNode.getProperties(), this.metricDirective.getDimensions(), this.metricDirective.getDefaultDimensions());
    }

    public List<String> serialize() throws JsonProcessingException {
        if (this.rootNode.metrics().size() <= 100) {
            return Arrays.asList(this.rootNode.serialize());
        }
        ArrayList<RootNode> nodes = new ArrayList<RootNode>();
        HashMap<String, MetricDefinition> metrics = new HashMap<String, MetricDefinition>();
        int count = 0;
        for (MetricDefinition metric : this.rootNode.metrics().values()) {
            metrics.put(metric.getName(), metric);
            if (metrics.size() != 100 && ++count != this.rootNode.metrics().size()) continue;
            Metadata metadata = this.rootNode.getAws();
            MetricDirective metricDirective = metadata.getCloudWatchMetrics().get(0);
            Metadata clonedMetadata = metadata.withCloudWatchMetrics(Arrays.asList(metricDirective.withMetrics(metrics)));
            nodes.add(this.rootNode.withAws(clonedMetadata));
            metrics = new HashMap();
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (RootNode node : nodes) {
            strings.add(node.serialize());
        }
        return strings;
    }

    public RootNode getRootNode() {
        return this.rootNode;
    }
}

