/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.cloudwatchlogs.emf.model.DimensionSet;
import software.amazon.cloudwatchlogs.emf.model.EmptyMetricsFilter;
import software.amazon.cloudwatchlogs.emf.model.Metadata;
import software.amazon.cloudwatchlogs.emf.model.MetricDirective;

@JsonFilter(value="emptyMetricFilter")
class RootNode {
    @JsonProperty(value="_aws")
    private Metadata aws = new Metadata();
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Map<String, List<Double>> metrics = new HashMap<String, List<Double>>();
    private ObjectMapper objectMapper = new ObjectMapper();

    RootNode() {
        SimpleFilterProvider filterProvider = new SimpleFilterProvider().addFilter("emptyMetricFilter", (SimpleBeanPropertyFilter)new EmptyMetricsFilter());
        this.objectMapper.setFilterProvider((FilterProvider)filterProvider);
    }

    public void putProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    void putMetric(String key, double value) {
        if (!this.metrics.containsKey(key)) {
            this.metrics.put(key, new ArrayList());
        }
        this.metrics.get(key).add(value);
    }

    Map<String, Object> getProperties() {
        return this.properties;
    }

    @JsonAnyGetter
    Map<String, Object> getTargetMembers() {
        HashMap<String, Object> targetMembers = new HashMap<String, Object>();
        targetMembers.putAll(this.properties);
        targetMembers.putAll(this.getDimensions());
        for (Map.Entry<String, List<Double>> entry : this.metrics.entrySet()) {
            List<Double> values = entry.getValue();
            targetMembers.put(entry.getKey(), values.size() == 1 ? values.get(0) : values);
        }
        return targetMembers;
    }

    Map<String, String> getDimensions() {
        HashMap<String, String> dimensions = new HashMap<String, String>();
        for (MetricDirective mc : this.aws.getCloudWatchMetrics()) {
            for (DimensionSet dimensionSet : mc.getAllDimensions()) {
                dimensions.putAll(dimensionSet.getDimensionRecords());
            }
        }
        return dimensions;
    }

    String serialize() throws JsonProcessingException {
        return this.objectMapper.writeValueAsString((Object)this);
    }

    public Metadata getAws() {
        return this.aws;
    }
}

