/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.cloudwatchlogs.emf.model.MetricDirective;
import software.amazon.cloudwatchlogs.emf.serializers.InstantDeserializer;
import software.amazon.cloudwatchlogs.emf.serializers.InstantSerializer;

class Metadata {
    @JsonProperty(value="Timestamp")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER, timezone="UTC")
    @JsonSerialize(using=InstantSerializer.class)
    @JsonDeserialize(using=InstantDeserializer.class)
    private Instant timestamp;
    @JsonProperty(value="CloudWatchMetrics")
    private List<MetricDirective> cloudWatchMetrics = new ArrayList<MetricDirective>();
    private Map<String, Object> customFields;

    Metadata() {
        this.timestamp = Instant.now();
        this.customFields = new HashMap<String, Object>();
    }

    MetricDirective createMetricDirective() {
        MetricDirective newMetricDirective = new MetricDirective();
        this.cloudWatchMetrics.add(newMetricDirective);
        return newMetricDirective;
    }

    boolean isEmpty() {
        return this.cloudWatchMetrics.isEmpty() || this.cloudWatchMetrics.stream().allMatch(MetricDirective::hasNoMetrics);
    }

    void putCustomMetadata(String key, Object value) {
        this.customFields.put(key, value);
    }

    @JsonAnyGetter
    Map<String, Object> getCustomMetadata() {
        return this.customFields;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="Timestamp")
    public void setTimestamp(Instant timestamp) {
        this.timestamp = timestamp;
    }

    public List<MetricDirective> getCloudWatchMetrics() {
        return this.cloudWatchMetrics;
    }

    @JsonProperty(value="CloudWatchMetrics")
    public void setCloudWatchMetrics(List<MetricDirective> cloudWatchMetrics) {
        this.cloudWatchMetrics = cloudWatchMetrics;
    }
}

