/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.environment;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import software.amazon.cloudwatchlogs.emf.config.Configuration;
import software.amazon.cloudwatchlogs.emf.config.EnvironmentConfigurationProvider;
import software.amazon.cloudwatchlogs.emf.environment.DefaultEnvironment;
import software.amazon.cloudwatchlogs.emf.environment.EC2Environment;
import software.amazon.cloudwatchlogs.emf.environment.ECSEnvironment;
import software.amazon.cloudwatchlogs.emf.environment.Environment;
import software.amazon.cloudwatchlogs.emf.environment.LambdaEnvironment;
import software.amazon.cloudwatchlogs.emf.environment.LocalEnvironment;
import software.amazon.cloudwatchlogs.emf.environment.ResourceFetcher;

public class EnvironmentProvider {
    private static Environment cachedEnvironment;
    private final Configuration config = EnvironmentConfigurationProvider.getConfig();
    private final Environment lambdaEnvironment = new LambdaEnvironment();
    private final Environment defaultEnvironment = new DefaultEnvironment(this.config);
    private final Environment ec2Environment = new EC2Environment(this.config, new ResourceFetcher());
    private final Environment ecsEnvironment = new ECSEnvironment(this.config, new ResourceFetcher());
    private final Environment[] environments = new Environment[]{this.lambdaEnvironment, this.ec2Environment, this.ecsEnvironment, this.defaultEnvironment};

    public CompletableFuture<Environment> resolveEnvironment() {
        if (cachedEnvironment != null) {
            return CompletableFuture.completedFuture(cachedEnvironment);
        }
        Optional<Environment> env = this.getEnvironmentFromOverride();
        if (env.isPresent()) {
            cachedEnvironment = env.get();
            return CompletableFuture.completedFuture(cachedEnvironment);
        }
        CompletableFuture<Optional<EnvironmentResolveResult>> resolvedEnv = this.discoverEnvironmentAsync();
        return resolvedEnv.thenApply(optionalEnv -> optionalEnv.map(EnvironmentResolveResult::getEnvironment).orElseGet(() -> {
            cachedEnvironment = this.defaultEnvironment;
            return cachedEnvironment;
        }));
    }

    public Environment getDefaultEnvironment() {
        return this.defaultEnvironment;
    }

    void cleanResolvedEnvironment() {
        cachedEnvironment = null;
    }

    private CompletableFuture<Optional<EnvironmentResolveResult>> discoverEnvironmentAsync() {
        CompletionStage<Optional<EnvironmentResolveResult>> ans = CompletableFuture.completedFuture(Optional.empty());
        for (Environment env : this.environments) {
            CompletableFuture<EnvironmentResolveResult> future = CompletableFuture.supplyAsync(() -> new EnvironmentResolveResult(env.probe(), env));
            ans = ans.thenCombine(future, (optionalEnv, envResult) -> {
                if (optionalEnv.isPresent()) {
                    return optionalEnv;
                }
                if (((EnvironmentResolveResult)envResult).isCandidate) {
                    return Optional.of(envResult);
                }
                return Optional.empty();
            });
        }
        return ans;
    }

    private Optional<Environment> getEnvironmentFromOverride() {
        Optional<Environment> environment;
        Configuration config = EnvironmentConfigurationProvider.getConfig();
        switch (config.getEnvironmentOverride()) {
            case Lambda: {
                environment = Optional.of(this.lambdaEnvironment);
                break;
            }
            case Agent: {
                environment = Optional.of(this.defaultEnvironment);
                break;
            }
            case EC2: {
                environment = Optional.of(this.ec2Environment);
                break;
            }
            case ECS: {
                environment = Optional.of(this.ecsEnvironment);
                break;
            }
            case Local: {
                environment = Optional.of(new LocalEnvironment(config));
                break;
            }
            default: {
                environment = Optional.empty();
            }
        }
        return environment;
    }

    static class EnvironmentResolveResult {
        private boolean isCandidate;
        private Environment environment;

        public EnvironmentResolveResult(boolean isCandidate, Environment environment) {
            this.isCandidate = isCandidate;
            this.environment = environment;
        }

        public boolean isCandidate() {
            return this.isCandidate;
        }

        public Environment getEnvironment() {
            return this.environment;
        }

        public void setCandidate(boolean isCandidate) {
            this.isCandidate = isCandidate;
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnvironmentResolveResult)) {
                return false;
            }
            EnvironmentResolveResult other = (EnvironmentResolveResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isCandidate() != other.isCandidate()) {
                return false;
            }
            Environment this$environment = this.getEnvironment();
            Environment other$environment = other.getEnvironment();
            return !(this$environment == null ? other$environment != null : !this$environment.equals(other$environment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EnvironmentResolveResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCandidate() ? 79 : 97);
            Environment $environment = this.getEnvironment();
            result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
            return result;
        }

        public String toString() {
            return "EnvironmentProvider.EnvironmentResolveResult(isCandidate=" + this.isCandidate() + ", environment=" + this.getEnvironment() + ")";
        }
    }
}

