/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.sinks;

import com.fasterxml.jackson.core.JsonProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.cloudwatchlogs.emf.model.MetricsContext;
import software.amazon.cloudwatchlogs.emf.sinks.ISink;

public class ConsoleSink
implements ISink {
    private static final Logger log = LoggerFactory.getLogger(ConsoleSink.class);

    @Override
    public void accept(MetricsContext context) {
        try {
            System.out.println(context.serialize());
        }
        catch (JsonProcessingException e) {
            log.error("Failed to serialize a MetricsContext: ", (Throwable)e);
        }
    }

    public static ConsoleSinkBuilder builder() {
        return new ConsoleSinkBuilder();
    }

    public static class ConsoleSinkBuilder {
        ConsoleSinkBuilder() {
        }

        public ConsoleSink build() {
            return new ConsoleSink();
        }

        public String toString() {
            return "ConsoleSink.ConsoleSinkBuilder()";
        }
    }
}

