/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudformation.resource;

import java.net.URI;
import lombok.Generated;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SchemaLoader;
import org.everit.json.schema.loader.internal.DefaultSchemaClient;
import org.json.JSONObject;
import software.amazon.cloudformation.resource.BaseValidator;
import software.amazon.cloudformation.resource.exceptions.ValidationException;

public class Validator
extends BaseValidator {
    protected static final String RESOURCE_DEFINITION_SCHEMA_PATH = "/schema/provider.definition.schema.v1.json";
    protected static final String TYPE_CONFIGURATION_DEFINITION_SCHEMA_PATH = "/schema/provider.configuration.definition.schema.v1.json";
    private static final URI RESOURCE_DEFINITION_SCHEMA_URI = Validator.newURI("https://schema.cloudformation.us-east-1.amazonaws.com/provider.definition.schema.v1.json");
    private JSONObject typeConfigurationDefinitionJson;

    public Validator(SchemaClient downloader) {
        this(Validator.loadResourceAsJSON(RESOURCE_DEFINITION_SCHEMA_PATH), downloader);
        this.typeConfigurationDefinitionJson = Validator.loadResourceAsJSON(TYPE_CONFIGURATION_DEFINITION_SCHEMA_PATH);
    }

    private Validator(JSONObject definitionSchema, SchemaClient downloader) {
        super(definitionSchema, downloader);
    }

    public Validator() {
        this((SchemaClient)new DefaultSchemaClient());
    }

    private Schema makeResourceDefinitionSchema() {
        SchemaLoader.SchemaLoaderBuilder builder = this.getSchemaLoader();
        this.registerMetaSchema(builder, this.typeConfigurationDefinitionJson);
        builder.schemaJson(this.definitionSchemaJsonObject);
        return builder.build().load().build();
    }

    void validateResourceDefinition(JSONObject resourceDefinition) {
        this.loadResourceDefinitionSchema(resourceDefinition);
    }

    public Schema loadResourceDefinitionSchema(JSONObject resourceDefinition) {
        resourceDefinition.put("$schema", (Object)RESOURCE_DEFINITION_SCHEMA_URI.toString());
        try {
            Schema resourceDefValidator = this.makeResourceDefinitionSchema();
            resourceDefValidator.validate((Object)resourceDefinition);
            SchemaLoader.SchemaLoaderBuilder builder = this.getSchemaLoader();
            this.registerMetaSchema(builder, resourceDefinition);
            this.registerMetaSchema(builder, this.typeConfigurationDefinitionJson);
            builder.schemaJson(resourceDefinition);
            return builder.build().load().build();
        }
        catch (org.everit.json.schema.ValidationException e) {
            throw ValidationException.newScrubbedException(e);
        }
        catch (SchemaException e) {
            throw new ValidationException(e.getMessage(), e.getSchemaLocation(), (Exception)((Object)e));
        }
    }

    @Generated
    public static ValidatorBuilder builder() {
        return new ValidatorBuilder();
    }

    @Generated
    public static class ValidatorBuilder {
        @Generated
        ValidatorBuilder() {
        }

        @Generated
        public Validator build() {
            return new Validator();
        }

        @Generated
        public String toString() {
            return "Validator.ValidatorBuilder()";
        }
    }
}

