/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SamplingStatisticsDocument
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SamplingStatisticsDocument> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SamplingStatisticsDocument.getter(SamplingStatisticsDocument::ruleName)).setter(SamplingStatisticsDocument.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SamplingStatisticsDocument.getter(SamplingStatisticsDocument::clientID)).setter(SamplingStatisticsDocument.setter(Builder::clientID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientID").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(SamplingStatisticsDocument.getter(SamplingStatisticsDocument::timestamp)).setter(SamplingStatisticsDocument.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<Integer> REQUEST_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SamplingStatisticsDocument.getter(SamplingStatisticsDocument::requestCount)).setter(SamplingStatisticsDocument.setter(Builder::requestCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestCount").build()}).build();
    private static final SdkField<Integer> SAMPLED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SamplingStatisticsDocument.getter(SamplingStatisticsDocument::sampledCount)).setter(SamplingStatisticsDocument.setter(Builder::sampledCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampledCount").build()}).build();
    private static final SdkField<Integer> BORROW_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SamplingStatisticsDocument.getter(SamplingStatisticsDocument::borrowCount)).setter(SamplingStatisticsDocument.setter(Builder::borrowCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorrowCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD, CLIENT_ID_FIELD, TIMESTAMP_FIELD, REQUEST_COUNT_FIELD, SAMPLED_COUNT_FIELD, BORROW_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ruleName;
    private final String clientID;
    private final Instant timestamp;
    private final Integer requestCount;
    private final Integer sampledCount;
    private final Integer borrowCount;

    private SamplingStatisticsDocument(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.clientID = builder.clientID;
        this.timestamp = builder.timestamp;
        this.requestCount = builder.requestCount;
        this.sampledCount = builder.sampledCount;
        this.borrowCount = builder.borrowCount;
    }

    public String ruleName() {
        return this.ruleName;
    }

    public String clientID() {
        return this.clientID;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Integer requestCount() {
        return this.requestCount;
    }

    public Integer sampledCount() {
        return this.sampledCount;
    }

    public Integer borrowCount() {
        return this.borrowCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientID());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampledCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.borrowCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamplingStatisticsDocument)) {
            return false;
        }
        SamplingStatisticsDocument other = (SamplingStatisticsDocument)obj;
        return Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.clientID(), other.clientID()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.requestCount(), other.requestCount()) && Objects.equals(this.sampledCount(), other.sampledCount()) && Objects.equals(this.borrowCount(), other.borrowCount());
    }

    public String toString() {
        return ToString.builder((String)"SamplingStatisticsDocument").add("RuleName", (Object)this.ruleName()).add("ClientID", (Object)this.clientID()).add("Timestamp", (Object)this.timestamp()).add("RequestCount", (Object)this.requestCount()).add("SampledCount", (Object)this.sampledCount()).add("BorrowCount", (Object)this.borrowCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "ClientID": {
                return Optional.ofNullable(clazz.cast(this.clientID()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "RequestCount": {
                return Optional.ofNullable(clazz.cast(this.requestCount()));
            }
            case "SampledCount": {
                return Optional.ofNullable(clazz.cast(this.sampledCount()));
            }
            case "BorrowCount": {
                return Optional.ofNullable(clazz.cast(this.borrowCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SamplingStatisticsDocument, T> g) {
        return obj -> g.apply((SamplingStatisticsDocument)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleName;
        private String clientID;
        private Instant timestamp;
        private Integer requestCount;
        private Integer sampledCount;
        private Integer borrowCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SamplingStatisticsDocument model) {
            this.ruleName(model.ruleName);
            this.clientID(model.clientID);
            this.timestamp(model.timestamp);
            this.requestCount(model.requestCount);
            this.sampledCount(model.sampledCount);
            this.borrowCount(model.borrowCount);
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public final String getClientID() {
            return this.clientID;
        }

        @Override
        public final Builder clientID(String clientID) {
            this.clientID = clientID;
            return this;
        }

        public final void setClientID(String clientID) {
            this.clientID = clientID;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final Integer getRequestCount() {
            return this.requestCount;
        }

        @Override
        public final Builder requestCount(Integer requestCount) {
            this.requestCount = requestCount;
            return this;
        }

        public final void setRequestCount(Integer requestCount) {
            this.requestCount = requestCount;
        }

        public final Integer getSampledCount() {
            return this.sampledCount;
        }

        @Override
        public final Builder sampledCount(Integer sampledCount) {
            this.sampledCount = sampledCount;
            return this;
        }

        public final void setSampledCount(Integer sampledCount) {
            this.sampledCount = sampledCount;
        }

        public final Integer getBorrowCount() {
            return this.borrowCount;
        }

        @Override
        public final Builder borrowCount(Integer borrowCount) {
            this.borrowCount = borrowCount;
            return this;
        }

        public final void setBorrowCount(Integer borrowCount) {
            this.borrowCount = borrowCount;
        }

        public SamplingStatisticsDocument build() {
            return new SamplingStatisticsDocument(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SamplingStatisticsDocument> {
        public Builder ruleName(String var1);

        public Builder clientID(String var1);

        public Builder timestamp(Instant var1);

        public Builder requestCount(Integer var1);

        public Builder sampledCount(Integer var1);

        public Builder borrowCount(Integer var1);
    }
}

