/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata generated from the segment documents in a trace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TraceSummary implements SdkPojo, Serializable, ToCopyableBuilder<TraceSummary.Builder, TraceSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(TraceSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(TraceSummary::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Double> DURATION_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Duration").getter(getter(TraceSummary::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<Double> RESPONSE_TIME_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ResponseTime").getter(getter(TraceSummary::responseTime)).setter(setter(Builder::responseTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseTime").build()).build();

    private static final SdkField<Boolean> HAS_FAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HasFault").getter(getter(TraceSummary::hasFault)).setter(setter(Builder::hasFault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasFault").build()).build();

    private static final SdkField<Boolean> HAS_ERROR_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HasError").getter(getter(TraceSummary::hasError)).setter(setter(Builder::hasError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasError").build()).build();

    private static final SdkField<Boolean> HAS_THROTTLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HasThrottle").getter(getter(TraceSummary::hasThrottle)).setter(setter(Builder::hasThrottle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasThrottle").build()).build();

    private static final SdkField<Boolean> IS_PARTIAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsPartial").getter(getter(TraceSummary::isPartial)).setter(setter(Builder::isPartial))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPartial").build()).build();

    private static final SdkField<Http> HTTP_FIELD = SdkField.<Http> builder(MarshallingType.SDK_POJO).memberName("Http")
            .getter(getter(TraceSummary::http)).setter(setter(Builder::http)).constructor(Http::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Http").build()).build();

    private static final SdkField<Map<String, List<ValueWithServiceIds>>> ANNOTATIONS_FIELD = SdkField
            .<Map<String, List<ValueWithServiceIds>>> builder(MarshallingType.MAP)
            .memberName("Annotations")
            .getter(getter(TraceSummary::annotations))
            .setter(setter(Builder::annotations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Annotations").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<ValueWithServiceIds>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<ValueWithServiceIds> builder(
                                                                            MarshallingType.SDK_POJO)
                                                                            .constructor(ValueWithServiceIds::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<TraceUser>> USERS_FIELD = SdkField
            .<List<TraceUser>> builder(MarshallingType.LIST)
            .memberName("Users")
            .getter(getter(TraceSummary::users))
            .setter(setter(Builder::users))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Users").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TraceUser> builder(MarshallingType.SDK_POJO)
                                            .constructor(TraceUser::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ServiceId>> SERVICE_IDS_FIELD = SdkField
            .<List<ServiceId>> builder(MarshallingType.LIST)
            .memberName("ServiceIds")
            .getter(getter(TraceSummary::serviceIds))
            .setter(setter(Builder::serviceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceId> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceId::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourceARNDetail>> RESOURCE_AR_NS_FIELD = SdkField
            .<List<ResourceARNDetail>> builder(MarshallingType.LIST)
            .memberName("ResourceARNs")
            .getter(getter(TraceSummary::resourceARNs))
            .setter(setter(Builder::resourceARNs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARNs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceARNDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceARNDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<InstanceIdDetail>> INSTANCE_IDS_FIELD = SdkField
            .<List<InstanceIdDetail>> builder(MarshallingType.LIST)
            .memberName("InstanceIds")
            .getter(getter(TraceSummary::instanceIds))
            .setter(setter(Builder::instanceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceIdDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceIdDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AvailabilityZoneDetail>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<AvailabilityZoneDetail>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(TraceSummary::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AvailabilityZoneDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(AvailabilityZoneDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ServiceId> ENTRY_POINT_FIELD = SdkField.<ServiceId> builder(MarshallingType.SDK_POJO)
            .memberName("EntryPoint").getter(getter(TraceSummary::entryPoint)).setter(setter(Builder::entryPoint))
            .constructor(ServiceId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntryPoint").build()).build();

    private static final SdkField<List<FaultRootCause>> FAULT_ROOT_CAUSES_FIELD = SdkField
            .<List<FaultRootCause>> builder(MarshallingType.LIST)
            .memberName("FaultRootCauses")
            .getter(getter(TraceSummary::faultRootCauses))
            .setter(setter(Builder::faultRootCauses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaultRootCauses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FaultRootCause> builder(MarshallingType.SDK_POJO)
                                            .constructor(FaultRootCause::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ErrorRootCause>> ERROR_ROOT_CAUSES_FIELD = SdkField
            .<List<ErrorRootCause>> builder(MarshallingType.LIST)
            .memberName("ErrorRootCauses")
            .getter(getter(TraceSummary::errorRootCauses))
            .setter(setter(Builder::errorRootCauses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorRootCauses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ErrorRootCause> builder(MarshallingType.SDK_POJO)
                                            .constructor(ErrorRootCause::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResponseTimeRootCause>> RESPONSE_TIME_ROOT_CAUSES_FIELD = SdkField
            .<List<ResponseTimeRootCause>> builder(MarshallingType.LIST)
            .memberName("ResponseTimeRootCauses")
            .getter(getter(TraceSummary::responseTimeRootCauses))
            .setter(setter(Builder::responseTimeRootCauses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseTimeRootCauses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResponseTimeRootCause> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResponseTimeRootCause::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> REVISION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Revision").getter(getter(TraceSummary::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Revision").build()).build();

    private static final SdkField<Instant> MATCHED_EVENT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("MatchedEventTime").getter(getter(TraceSummary::matchedEventTime))
            .setter(setter(Builder::matchedEventTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchedEventTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, START_TIME_FIELD,
            DURATION_FIELD, RESPONSE_TIME_FIELD, HAS_FAULT_FIELD, HAS_ERROR_FIELD, HAS_THROTTLE_FIELD, IS_PARTIAL_FIELD,
            HTTP_FIELD, ANNOTATIONS_FIELD, USERS_FIELD, SERVICE_IDS_FIELD, RESOURCE_AR_NS_FIELD, INSTANCE_IDS_FIELD,
            AVAILABILITY_ZONES_FIELD, ENTRY_POINT_FIELD, FAULT_ROOT_CAUSES_FIELD, ERROR_ROOT_CAUSES_FIELD,
            RESPONSE_TIME_ROOT_CAUSES_FIELD, REVISION_FIELD, MATCHED_EVENT_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Instant startTime;

    private final Double duration;

    private final Double responseTime;

    private final Boolean hasFault;

    private final Boolean hasError;

    private final Boolean hasThrottle;

    private final Boolean isPartial;

    private final Http http;

    private final Map<String, List<ValueWithServiceIds>> annotations;

    private final List<TraceUser> users;

    private final List<ServiceId> serviceIds;

    private final List<ResourceARNDetail> resourceARNs;

    private final List<InstanceIdDetail> instanceIds;

    private final List<AvailabilityZoneDetail> availabilityZones;

    private final ServiceId entryPoint;

    private final List<FaultRootCause> faultRootCauses;

    private final List<ErrorRootCause> errorRootCauses;

    private final List<ResponseTimeRootCause> responseTimeRootCauses;

    private final Integer revision;

    private final Instant matchedEventTime;

    private TraceSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.startTime = builder.startTime;
        this.duration = builder.duration;
        this.responseTime = builder.responseTime;
        this.hasFault = builder.hasFault;
        this.hasError = builder.hasError;
        this.hasThrottle = builder.hasThrottle;
        this.isPartial = builder.isPartial;
        this.http = builder.http;
        this.annotations = builder.annotations;
        this.users = builder.users;
        this.serviceIds = builder.serviceIds;
        this.resourceARNs = builder.resourceARNs;
        this.instanceIds = builder.instanceIds;
        this.availabilityZones = builder.availabilityZones;
        this.entryPoint = builder.entryPoint;
        this.faultRootCauses = builder.faultRootCauses;
        this.errorRootCauses = builder.errorRootCauses;
        this.responseTimeRootCauses = builder.responseTimeRootCauses;
        this.revision = builder.revision;
        this.matchedEventTime = builder.matchedEventTime;
    }

    /**
     * <p>
     * The unique identifier for the request that generated the trace's segments and subsegments.
     * </p>
     * 
     * @return The unique identifier for the request that generated the trace's segments and subsegments.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The start time of a trace, based on the earliest trace segment start time.
     * </p>
     * 
     * @return The start time of a trace, based on the earliest trace segment start time.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The length of time in seconds between the start time of the earliest segment that started and the end time of the
     * last segment that completed.
     * </p>
     * 
     * @return The length of time in seconds between the start time of the earliest segment that started and the end
     *         time of the last segment that completed.
     */
    public final Double duration() {
        return duration;
    }

    /**
     * <p>
     * The length of time in seconds between the start and end times of the root segment. If the service performs work
     * asynchronously, the response time measures the time before the response is sent to the user, while the duration
     * measures the amount of time before the last traced activity completes.
     * </p>
     * 
     * @return The length of time in seconds between the start and end times of the root segment. If the service
     *         performs work asynchronously, the response time measures the time before the response is sent to the
     *         user, while the duration measures the amount of time before the last traced activity completes.
     */
    public final Double responseTime() {
        return responseTime;
    }

    /**
     * <p>
     * The root segment document has a 500 series error.
     * </p>
     * 
     * @return The root segment document has a 500 series error.
     */
    public final Boolean hasFault() {
        return hasFault;
    }

    /**
     * <p>
     * The root segment document has a 400 series error.
     * </p>
     * 
     * @return The root segment document has a 400 series error.
     */
    public final Boolean hasError() {
        return hasError;
    }

    /**
     * <p>
     * One or more of the segment documents has a 429 throttling error.
     * </p>
     * 
     * @return One or more of the segment documents has a 429 throttling error.
     */
    public final Boolean hasThrottle() {
        return hasThrottle;
    }

    /**
     * <p>
     * One or more of the segment documents is in progress.
     * </p>
     * 
     * @return One or more of the segment documents is in progress.
     */
    public final Boolean isPartial() {
        return isPartial;
    }

    /**
     * <p>
     * Information about the HTTP request served by the trace.
     * </p>
     * 
     * @return Information about the HTTP request served by the trace.
     */
    public final Http http() {
        return http;
    }

    /**
     * For responses, this returns true if the service returned a value for the Annotations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnnotations() {
        return annotations != null && !(annotations instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Annotations from the trace's segment documents.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnnotations} method.
     * </p>
     * 
     * @return Annotations from the trace's segment documents.
     */
    public final Map<String, List<ValueWithServiceIds>> annotations() {
        return annotations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Users property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasUsers() {
        return users != null && !(users instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Users from the trace's segment documents.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsers} method.
     * </p>
     * 
     * @return Users from the trace's segment documents.
     */
    public final List<TraceUser> users() {
        return users;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasServiceIds() {
        return serviceIds != null && !(serviceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Service IDs from the trace's segment documents.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceIds} method.
     * </p>
     * 
     * @return Service IDs from the trace's segment documents.
     */
    public final List<ServiceId> serviceIds() {
        return serviceIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceARNs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceARNs() {
        return resourceARNs != null && !(resourceARNs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resource ARNs for any resource corresponding to the trace segments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceARNs} method.
     * </p>
     * 
     * @return A list of resource ARNs for any resource corresponding to the trace segments.
     */
    public final List<ResourceARNDetail> resourceARNs() {
        return resourceARNs;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceIds() {
        return instanceIds != null && !(instanceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of EC2 instance IDs for any instance corresponding to the trace segments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceIds} method.
     * </p>
     * 
     * @return A list of EC2 instance IDs for any instance corresponding to the trace segments.
     */
    public final List<InstanceIdDetail> instanceIds() {
        return instanceIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Availability Zones for any zone corresponding to the trace segments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return A list of Availability Zones for any zone corresponding to the trace segments.
     */
    public final List<AvailabilityZoneDetail> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * The root of a trace.
     * </p>
     * 
     * @return The root of a trace.
     */
    public final ServiceId entryPoint() {
        return entryPoint;
    }

    /**
     * For responses, this returns true if the service returned a value for the FaultRootCauses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFaultRootCauses() {
        return faultRootCauses != null && !(faultRootCauses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of FaultRootCause structures corresponding to the trace segments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFaultRootCauses} method.
     * </p>
     * 
     * @return A collection of FaultRootCause structures corresponding to the trace segments.
     */
    public final List<FaultRootCause> faultRootCauses() {
        return faultRootCauses;
    }

    /**
     * For responses, this returns true if the service returned a value for the ErrorRootCauses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasErrorRootCauses() {
        return errorRootCauses != null && !(errorRootCauses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of ErrorRootCause structures corresponding to the trace segments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrorRootCauses} method.
     * </p>
     * 
     * @return A collection of ErrorRootCause structures corresponding to the trace segments.
     */
    public final List<ErrorRootCause> errorRootCauses() {
        return errorRootCauses;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResponseTimeRootCauses property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasResponseTimeRootCauses() {
        return responseTimeRootCauses != null && !(responseTimeRootCauses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of ResponseTimeRootCause structures corresponding to the trace segments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResponseTimeRootCauses} method.
     * </p>
     * 
     * @return A collection of ResponseTimeRootCause structures corresponding to the trace segments.
     */
    public final List<ResponseTimeRootCause> responseTimeRootCauses() {
        return responseTimeRootCauses;
    }

    /**
     * <p>
     * The revision number of a trace.
     * </p>
     * 
     * @return The revision number of a trace.
     */
    public final Integer revision() {
        return revision;
    }

    /**
     * <p>
     * The matched time stamp of a defined event.
     * </p>
     * 
     * @return The matched time stamp of a defined event.
     */
    public final Instant matchedEventTime() {
        return matchedEventTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(responseTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasFault());
        hashCode = 31 * hashCode + Objects.hashCode(hasError());
        hashCode = 31 * hashCode + Objects.hashCode(hasThrottle());
        hashCode = 31 * hashCode + Objects.hashCode(isPartial());
        hashCode = 31 * hashCode + Objects.hashCode(http());
        hashCode = 31 * hashCode + Objects.hashCode(hasAnnotations() ? annotations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUsers() ? users() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceIds() ? serviceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceARNs() ? resourceARNs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceIds() ? instanceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(entryPoint());
        hashCode = 31 * hashCode + Objects.hashCode(hasFaultRootCauses() ? faultRootCauses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrorRootCauses() ? errorRootCauses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResponseTimeRootCauses() ? responseTimeRootCauses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        hashCode = 31 * hashCode + Objects.hashCode(matchedEventTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TraceSummary)) {
            return false;
        }
        TraceSummary other = (TraceSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(duration(), other.duration()) && Objects.equals(responseTime(), other.responseTime())
                && Objects.equals(hasFault(), other.hasFault()) && Objects.equals(hasError(), other.hasError())
                && Objects.equals(hasThrottle(), other.hasThrottle()) && Objects.equals(isPartial(), other.isPartial())
                && Objects.equals(http(), other.http()) && hasAnnotations() == other.hasAnnotations()
                && Objects.equals(annotations(), other.annotations()) && hasUsers() == other.hasUsers()
                && Objects.equals(users(), other.users()) && hasServiceIds() == other.hasServiceIds()
                && Objects.equals(serviceIds(), other.serviceIds()) && hasResourceARNs() == other.hasResourceARNs()
                && Objects.equals(resourceARNs(), other.resourceARNs()) && hasInstanceIds() == other.hasInstanceIds()
                && Objects.equals(instanceIds(), other.instanceIds()) && hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(entryPoint(), other.entryPoint()) && hasFaultRootCauses() == other.hasFaultRootCauses()
                && Objects.equals(faultRootCauses(), other.faultRootCauses())
                && hasErrorRootCauses() == other.hasErrorRootCauses()
                && Objects.equals(errorRootCauses(), other.errorRootCauses())
                && hasResponseTimeRootCauses() == other.hasResponseTimeRootCauses()
                && Objects.equals(responseTimeRootCauses(), other.responseTimeRootCauses())
                && Objects.equals(revision(), other.revision()) && Objects.equals(matchedEventTime(), other.matchedEventTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TraceSummary").add("Id", id()).add("StartTime", startTime()).add("Duration", duration())
                .add("ResponseTime", responseTime()).add("HasFault", hasFault()).add("HasError", hasError())
                .add("HasThrottle", hasThrottle()).add("IsPartial", isPartial()).add("Http", http())
                .add("Annotations", hasAnnotations() ? annotations() : null).add("Users", hasUsers() ? users() : null)
                .add("ServiceIds", hasServiceIds() ? serviceIds() : null)
                .add("ResourceARNs", hasResourceARNs() ? resourceARNs() : null)
                .add("InstanceIds", hasInstanceIds() ? instanceIds() : null)
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null).add("EntryPoint", entryPoint())
                .add("FaultRootCauses", hasFaultRootCauses() ? faultRootCauses() : null)
                .add("ErrorRootCauses", hasErrorRootCauses() ? errorRootCauses() : null)
                .add("ResponseTimeRootCauses", hasResponseTimeRootCauses() ? responseTimeRootCauses() : null)
                .add("Revision", revision()).add("MatchedEventTime", matchedEventTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "ResponseTime":
            return Optional.ofNullable(clazz.cast(responseTime()));
        case "HasFault":
            return Optional.ofNullable(clazz.cast(hasFault()));
        case "HasError":
            return Optional.ofNullable(clazz.cast(hasError()));
        case "HasThrottle":
            return Optional.ofNullable(clazz.cast(hasThrottle()));
        case "IsPartial":
            return Optional.ofNullable(clazz.cast(isPartial()));
        case "Http":
            return Optional.ofNullable(clazz.cast(http()));
        case "Annotations":
            return Optional.ofNullable(clazz.cast(annotations()));
        case "Users":
            return Optional.ofNullable(clazz.cast(users()));
        case "ServiceIds":
            return Optional.ofNullable(clazz.cast(serviceIds()));
        case "ResourceARNs":
            return Optional.ofNullable(clazz.cast(resourceARNs()));
        case "InstanceIds":
            return Optional.ofNullable(clazz.cast(instanceIds()));
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "EntryPoint":
            return Optional.ofNullable(clazz.cast(entryPoint()));
        case "FaultRootCauses":
            return Optional.ofNullable(clazz.cast(faultRootCauses()));
        case "ErrorRootCauses":
            return Optional.ofNullable(clazz.cast(errorRootCauses()));
        case "ResponseTimeRootCauses":
            return Optional.ofNullable(clazz.cast(responseTimeRootCauses()));
        case "Revision":
            return Optional.ofNullable(clazz.cast(revision()));
        case "MatchedEventTime":
            return Optional.ofNullable(clazz.cast(matchedEventTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("ResponseTime", RESPONSE_TIME_FIELD);
        map.put("HasFault", HAS_FAULT_FIELD);
        map.put("HasError", HAS_ERROR_FIELD);
        map.put("HasThrottle", HAS_THROTTLE_FIELD);
        map.put("IsPartial", IS_PARTIAL_FIELD);
        map.put("Http", HTTP_FIELD);
        map.put("Annotations", ANNOTATIONS_FIELD);
        map.put("Users", USERS_FIELD);
        map.put("ServiceIds", SERVICE_IDS_FIELD);
        map.put("ResourceARNs", RESOURCE_AR_NS_FIELD);
        map.put("InstanceIds", INSTANCE_IDS_FIELD);
        map.put("AvailabilityZones", AVAILABILITY_ZONES_FIELD);
        map.put("EntryPoint", ENTRY_POINT_FIELD);
        map.put("FaultRootCauses", FAULT_ROOT_CAUSES_FIELD);
        map.put("ErrorRootCauses", ERROR_ROOT_CAUSES_FIELD);
        map.put("ResponseTimeRootCauses", RESPONSE_TIME_ROOT_CAUSES_FIELD);
        map.put("Revision", REVISION_FIELD);
        map.put("MatchedEventTime", MATCHED_EVENT_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TraceSummary, T> g) {
        return obj -> g.apply((TraceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TraceSummary> {
        /**
         * <p>
         * The unique identifier for the request that generated the trace's segments and subsegments.
         * </p>
         * 
         * @param id
         *        The unique identifier for the request that generated the trace's segments and subsegments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The start time of a trace, based on the earliest trace segment start time.
         * </p>
         * 
         * @param startTime
         *        The start time of a trace, based on the earliest trace segment start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The length of time in seconds between the start time of the earliest segment that started and the end time of
         * the last segment that completed.
         * </p>
         * 
         * @param duration
         *        The length of time in seconds between the start time of the earliest segment that started and the end
         *        time of the last segment that completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Double duration);

        /**
         * <p>
         * The length of time in seconds between the start and end times of the root segment. If the service performs
         * work asynchronously, the response time measures the time before the response is sent to the user, while the
         * duration measures the amount of time before the last traced activity completes.
         * </p>
         * 
         * @param responseTime
         *        The length of time in seconds between the start and end times of the root segment. If the service
         *        performs work asynchronously, the response time measures the time before the response is sent to the
         *        user, while the duration measures the amount of time before the last traced activity completes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseTime(Double responseTime);

        /**
         * <p>
         * The root segment document has a 500 series error.
         * </p>
         * 
         * @param hasFault
         *        The root segment document has a 500 series error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasFault(Boolean hasFault);

        /**
         * <p>
         * The root segment document has a 400 series error.
         * </p>
         * 
         * @param hasError
         *        The root segment document has a 400 series error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasError(Boolean hasError);

        /**
         * <p>
         * One or more of the segment documents has a 429 throttling error.
         * </p>
         * 
         * @param hasThrottle
         *        One or more of the segment documents has a 429 throttling error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasThrottle(Boolean hasThrottle);

        /**
         * <p>
         * One or more of the segment documents is in progress.
         * </p>
         * 
         * @param isPartial
         *        One or more of the segment documents is in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPartial(Boolean isPartial);

        /**
         * <p>
         * Information about the HTTP request served by the trace.
         * </p>
         * 
         * @param http
         *        Information about the HTTP request served by the trace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder http(Http http);

        /**
         * <p>
         * Information about the HTTP request served by the trace.
         * </p>
         * This is a convenience method that creates an instance of the {@link Http.Builder} avoiding the need to create
         * one manually via {@link Http#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Http.Builder#build()} is called immediately and its result is
         * passed to {@link #http(Http)}.
         * 
         * @param http
         *        a consumer that will call methods on {@link Http.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #http(Http)
         */
        default Builder http(Consumer<Http.Builder> http) {
            return http(Http.builder().applyMutation(http).build());
        }

        /**
         * <p>
         * Annotations from the trace's segment documents.
         * </p>
         * 
         * @param annotations
         *        Annotations from the trace's segment documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotations(Map<String, ? extends Collection<ValueWithServiceIds>> annotations);

        /**
         * <p>
         * Users from the trace's segment documents.
         * </p>
         * 
         * @param users
         *        Users from the trace's segment documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(Collection<TraceUser> users);

        /**
         * <p>
         * Users from the trace's segment documents.
         * </p>
         * 
         * @param users
         *        Users from the trace's segment documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(TraceUser... users);

        /**
         * <p>
         * Users from the trace's segment documents.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.xray.model.TraceUser.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.xray.model.TraceUser#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.xray.model.TraceUser.Builder#build()} is called immediately and its
         * result is passed to {@link #users(List<TraceUser>)}.
         * 
         * @param users
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.xray.model.TraceUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #users(java.util.Collection<TraceUser>)
         */
        Builder users(Consumer<TraceUser.Builder>... users);

        /**
         * <p>
         * Service IDs from the trace's segment documents.
         * </p>
         * 
         * @param serviceIds
         *        Service IDs from the trace's segment documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIds(Collection<ServiceId> serviceIds);

        /**
         * <p>
         * Service IDs from the trace's segment documents.
         * </p>
         * 
         * @param serviceIds
         *        Service IDs from the trace's segment documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIds(ServiceId... serviceIds);

        /**
         * <p>
         * Service IDs from the trace's segment documents.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.xray.model.ServiceId.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.xray.model.ServiceId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.xray.model.ServiceId.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceIds(List<ServiceId>)}.
         * 
         * @param serviceIds
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.xray.model.ServiceId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceIds(java.util.Collection<ServiceId>)
         */
        Builder serviceIds(Consumer<ServiceId.Builder>... serviceIds);

        /**
         * <p>
         * A list of resource ARNs for any resource corresponding to the trace segments.
         * </p>
         * 
         * @param resourceARNs
         *        A list of resource ARNs for any resource corresponding to the trace segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceARNs(Collection<ResourceARNDetail> resourceARNs);

        /**
         * <p>
         * A list of resource ARNs for any resource corresponding to the trace segments.
         * </p>
         * 
         * @param resourceARNs
         *        A list of resource ARNs for any resource corresponding to the trace segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceARNs(ResourceARNDetail... resourceARNs);

        /**
         * <p>
         * A list of resource ARNs for any resource corresponding to the trace segments.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.xray.model.ResourceARNDetail.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.xray.model.ResourceARNDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.xray.model.ResourceARNDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceARNs(List<ResourceARNDetail>)}.
         * 
         * @param resourceARNs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.xray.model.ResourceARNDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceARNs(java.util.Collection<ResourceARNDetail>)
         */
        Builder resourceARNs(Consumer<ResourceARNDetail.Builder>... resourceARNs);

        /**
         * <p>
         * A list of EC2 instance IDs for any instance corresponding to the trace segments.
         * </p>
         * 
         * @param instanceIds
         *        A list of EC2 instance IDs for any instance corresponding to the trace segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<InstanceIdDetail> instanceIds);

        /**
         * <p>
         * A list of EC2 instance IDs for any instance corresponding to the trace segments.
         * </p>
         * 
         * @param instanceIds
         *        A list of EC2 instance IDs for any instance corresponding to the trace segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(InstanceIdDetail... instanceIds);

        /**
         * <p>
         * A list of EC2 instance IDs for any instance corresponding to the trace segments.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.xray.model.InstanceIdDetail.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.xray.model.InstanceIdDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.xray.model.InstanceIdDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceIds(List<InstanceIdDetail>)}.
         * 
         * @param instanceIds
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.xray.model.InstanceIdDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceIds(java.util.Collection<InstanceIdDetail>)
         */
        Builder instanceIds(Consumer<InstanceIdDetail.Builder>... instanceIds);

        /**
         * <p>
         * A list of Availability Zones for any zone corresponding to the trace segments.
         * </p>
         * 
         * @param availabilityZones
         *        A list of Availability Zones for any zone corresponding to the trace segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<AvailabilityZoneDetail> availabilityZones);

        /**
         * <p>
         * A list of Availability Zones for any zone corresponding to the trace segments.
         * </p>
         * 
         * @param availabilityZones
         *        A list of Availability Zones for any zone corresponding to the trace segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(AvailabilityZoneDetail... availabilityZones);

        /**
         * <p>
         * A list of Availability Zones for any zone corresponding to the trace segments.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.xray.model.AvailabilityZoneDetail.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.xray.model.AvailabilityZoneDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.xray.model.AvailabilityZoneDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #availabilityZones(List<AvailabilityZoneDetail>)}.
         * 
         * @param availabilityZones
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.xray.model.AvailabilityZoneDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availabilityZones(java.util.Collection<AvailabilityZoneDetail>)
         */
        Builder availabilityZones(Consumer<AvailabilityZoneDetail.Builder>... availabilityZones);

        /**
         * <p>
         * The root of a trace.
         * </p>
         * 
         * @param entryPoint
         *        The root of a trace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryPoint(ServiceId entryPoint);

        /**
         * <p>
         * The root of a trace.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceId.Builder} avoiding the need to
         * create one manually via {@link ServiceId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceId.Builder#build()} is called immediately and its result
         * is passed to {@link #entryPoint(ServiceId)}.
         * 
         * @param entryPoint
         *        a consumer that will call methods on {@link ServiceId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entryPoint(ServiceId)
         */
        default Builder entryPoint(Consumer<ServiceId.Builder> entryPoint) {
            return entryPoint(ServiceId.builder().applyMutation(entryPoint).build());
        }

        /**
         * <p>
         * A collection of FaultRootCause structures corresponding to the trace segments.
         * </p>
         * 
         * @param faultRootCauses
         *        A collection of FaultRootCause structures corresponding to the trace segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faultRootCauses(Collection<FaultRootCause> faultRootCauses);

        /**
         * <p>
         * A collection of FaultRootCause structures corresponding to the trace segments.
         * </p>
         * 
         * @param faultRootCauses
         *        A collection of FaultRootCause structures corresponding to the trace segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faultRootCauses(FaultRootCause... faultRootCauses);

        /**
         * <p>
         * A collection of FaultRootCause structures corresponding to the trace segments.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.xray.model.FaultRootCause.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.xray.model.FaultRootCause#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.xray.model.FaultRootCause.Builder#build()} is called immediately and
         * its result is passed to {@link #faultRootCauses(List<FaultRootCause>)}.
         * 
         * @param faultRootCauses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.xray.model.FaultRootCause.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #faultRootCauses(java.util.Collection<FaultRootCause>)
         */
        Builder faultRootCauses(Consumer<FaultRootCause.Builder>... faultRootCauses);

        /**
         * <p>
         * A collection of ErrorRootCause structures corresponding to the trace segments.
         * </p>
         * 
         * @param errorRootCauses
         *        A collection of ErrorRootCause structures corresponding to the trace segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorRootCauses(Collection<ErrorRootCause> errorRootCauses);

        /**
         * <p>
         * A collection of ErrorRootCause structures corresponding to the trace segments.
         * </p>
         * 
         * @param errorRootCauses
         *        A collection of ErrorRootCause structures corresponding to the trace segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorRootCauses(ErrorRootCause... errorRootCauses);

        /**
         * <p>
         * A collection of ErrorRootCause structures corresponding to the trace segments.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.xray.model.ErrorRootCause.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.xray.model.ErrorRootCause#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.xray.model.ErrorRootCause.Builder#build()} is called immediately and
         * its result is passed to {@link #errorRootCauses(List<ErrorRootCause>)}.
         * 
         * @param errorRootCauses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.xray.model.ErrorRootCause.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorRootCauses(java.util.Collection<ErrorRootCause>)
         */
        Builder errorRootCauses(Consumer<ErrorRootCause.Builder>... errorRootCauses);

        /**
         * <p>
         * A collection of ResponseTimeRootCause structures corresponding to the trace segments.
         * </p>
         * 
         * @param responseTimeRootCauses
         *        A collection of ResponseTimeRootCause structures corresponding to the trace segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseTimeRootCauses(Collection<ResponseTimeRootCause> responseTimeRootCauses);

        /**
         * <p>
         * A collection of ResponseTimeRootCause structures corresponding to the trace segments.
         * </p>
         * 
         * @param responseTimeRootCauses
         *        A collection of ResponseTimeRootCause structures corresponding to the trace segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseTimeRootCauses(ResponseTimeRootCause... responseTimeRootCauses);

        /**
         * <p>
         * A collection of ResponseTimeRootCause structures corresponding to the trace segments.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.xray.model.ResponseTimeRootCause.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.xray.model.ResponseTimeRootCause#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.xray.model.ResponseTimeRootCause.Builder#build()} is called
         * immediately and its result is passed to {@link #responseTimeRootCauses(List<ResponseTimeRootCause>)}.
         * 
         * @param responseTimeRootCauses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.xray.model.ResponseTimeRootCause.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #responseTimeRootCauses(java.util.Collection<ResponseTimeRootCause>)
         */
        Builder responseTimeRootCauses(Consumer<ResponseTimeRootCause.Builder>... responseTimeRootCauses);

        /**
         * <p>
         * The revision number of a trace.
         * </p>
         * 
         * @param revision
         *        The revision number of a trace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(Integer revision);

        /**
         * <p>
         * The matched time stamp of a defined event.
         * </p>
         * 
         * @param matchedEventTime
         *        The matched time stamp of a defined event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchedEventTime(Instant matchedEventTime);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Instant startTime;

        private Double duration;

        private Double responseTime;

        private Boolean hasFault;

        private Boolean hasError;

        private Boolean hasThrottle;

        private Boolean isPartial;

        private Http http;

        private Map<String, List<ValueWithServiceIds>> annotations = DefaultSdkAutoConstructMap.getInstance();

        private List<TraceUser> users = DefaultSdkAutoConstructList.getInstance();

        private List<ServiceId> serviceIds = DefaultSdkAutoConstructList.getInstance();

        private List<ResourceARNDetail> resourceARNs = DefaultSdkAutoConstructList.getInstance();

        private List<InstanceIdDetail> instanceIds = DefaultSdkAutoConstructList.getInstance();

        private List<AvailabilityZoneDetail> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private ServiceId entryPoint;

        private List<FaultRootCause> faultRootCauses = DefaultSdkAutoConstructList.getInstance();

        private List<ErrorRootCause> errorRootCauses = DefaultSdkAutoConstructList.getInstance();

        private List<ResponseTimeRootCause> responseTimeRootCauses = DefaultSdkAutoConstructList.getInstance();

        private Integer revision;

        private Instant matchedEventTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TraceSummary model) {
            id(model.id);
            startTime(model.startTime);
            duration(model.duration);
            responseTime(model.responseTime);
            hasFault(model.hasFault);
            hasError(model.hasError);
            hasThrottle(model.hasThrottle);
            isPartial(model.isPartial);
            http(model.http);
            annotations(model.annotations);
            users(model.users);
            serviceIds(model.serviceIds);
            resourceARNs(model.resourceARNs);
            instanceIds(model.instanceIds);
            availabilityZones(model.availabilityZones);
            entryPoint(model.entryPoint);
            faultRootCauses(model.faultRootCauses);
            errorRootCauses(model.errorRootCauses);
            responseTimeRootCauses(model.responseTimeRootCauses);
            revision(model.revision);
            matchedEventTime(model.matchedEventTime);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Double getDuration() {
            return duration;
        }

        public final void setDuration(Double duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Double duration) {
            this.duration = duration;
            return this;
        }

        public final Double getResponseTime() {
            return responseTime;
        }

        public final void setResponseTime(Double responseTime) {
            this.responseTime = responseTime;
        }

        @Override
        public final Builder responseTime(Double responseTime) {
            this.responseTime = responseTime;
            return this;
        }

        public final Boolean getHasFault() {
            return hasFault;
        }

        public final void setHasFault(Boolean hasFault) {
            this.hasFault = hasFault;
        }

        @Override
        public final Builder hasFault(Boolean hasFault) {
            this.hasFault = hasFault;
            return this;
        }

        public final Boolean getHasError() {
            return hasError;
        }

        public final void setHasError(Boolean hasError) {
            this.hasError = hasError;
        }

        @Override
        public final Builder hasError(Boolean hasError) {
            this.hasError = hasError;
            return this;
        }

        public final Boolean getHasThrottle() {
            return hasThrottle;
        }

        public final void setHasThrottle(Boolean hasThrottle) {
            this.hasThrottle = hasThrottle;
        }

        @Override
        public final Builder hasThrottle(Boolean hasThrottle) {
            this.hasThrottle = hasThrottle;
            return this;
        }

        public final Boolean getIsPartial() {
            return isPartial;
        }

        public final void setIsPartial(Boolean isPartial) {
            this.isPartial = isPartial;
        }

        @Override
        public final Builder isPartial(Boolean isPartial) {
            this.isPartial = isPartial;
            return this;
        }

        public final Http.Builder getHttp() {
            return http != null ? http.toBuilder() : null;
        }

        public final void setHttp(Http.BuilderImpl http) {
            this.http = http != null ? http.build() : null;
        }

        @Override
        public final Builder http(Http http) {
            this.http = http;
            return this;
        }

        public final Map<String, List<ValueWithServiceIds.Builder>> getAnnotations() {
            Map<String, List<ValueWithServiceIds.Builder>> result = AnnotationsCopier.copyToBuilder(this.annotations);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAnnotations(Map<String, ? extends Collection<ValueWithServiceIds.BuilderImpl>> annotations) {
            this.annotations = AnnotationsCopier.copyFromBuilder(annotations);
        }

        @Override
        public final Builder annotations(Map<String, ? extends Collection<ValueWithServiceIds>> annotations) {
            this.annotations = AnnotationsCopier.copy(annotations);
            return this;
        }

        public final List<TraceUser.Builder> getUsers() {
            List<TraceUser.Builder> result = TraceUsersCopier.copyToBuilder(this.users);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsers(Collection<TraceUser.BuilderImpl> users) {
            this.users = TraceUsersCopier.copyFromBuilder(users);
        }

        @Override
        public final Builder users(Collection<TraceUser> users) {
            this.users = TraceUsersCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(TraceUser... users) {
            users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<TraceUser.Builder>... users) {
            users(Stream.of(users).map(c -> TraceUser.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ServiceId.Builder> getServiceIds() {
            List<ServiceId.Builder> result = ServiceIdsCopier.copyToBuilder(this.serviceIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceIds(Collection<ServiceId.BuilderImpl> serviceIds) {
            this.serviceIds = ServiceIdsCopier.copyFromBuilder(serviceIds);
        }

        @Override
        public final Builder serviceIds(Collection<ServiceId> serviceIds) {
            this.serviceIds = ServiceIdsCopier.copy(serviceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIds(ServiceId... serviceIds) {
            serviceIds(Arrays.asList(serviceIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIds(Consumer<ServiceId.Builder>... serviceIds) {
            serviceIds(Stream.of(serviceIds).map(c -> ServiceId.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceARNDetail.Builder> getResourceARNs() {
            List<ResourceARNDetail.Builder> result = TraceResourceARNsCopier.copyToBuilder(this.resourceARNs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceARNs(Collection<ResourceARNDetail.BuilderImpl> resourceARNs) {
            this.resourceARNs = TraceResourceARNsCopier.copyFromBuilder(resourceARNs);
        }

        @Override
        public final Builder resourceARNs(Collection<ResourceARNDetail> resourceARNs) {
            this.resourceARNs = TraceResourceARNsCopier.copy(resourceARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceARNs(ResourceARNDetail... resourceARNs) {
            resourceARNs(Arrays.asList(resourceARNs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceARNs(Consumer<ResourceARNDetail.Builder>... resourceARNs) {
            resourceARNs(Stream.of(resourceARNs).map(c -> ResourceARNDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<InstanceIdDetail.Builder> getInstanceIds() {
            List<InstanceIdDetail.Builder> result = TraceInstanceIdsCopier.copyToBuilder(this.instanceIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceIds(Collection<InstanceIdDetail.BuilderImpl> instanceIds) {
            this.instanceIds = TraceInstanceIdsCopier.copyFromBuilder(instanceIds);
        }

        @Override
        public final Builder instanceIds(Collection<InstanceIdDetail> instanceIds) {
            this.instanceIds = TraceInstanceIdsCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(InstanceIdDetail... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(Consumer<InstanceIdDetail.Builder>... instanceIds) {
            instanceIds(Stream.of(instanceIds).map(c -> InstanceIdDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AvailabilityZoneDetail.Builder> getAvailabilityZones() {
            List<AvailabilityZoneDetail.Builder> result = TraceAvailabilityZonesCopier.copyToBuilder(this.availabilityZones);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailabilityZones(Collection<AvailabilityZoneDetail.BuilderImpl> availabilityZones) {
            this.availabilityZones = TraceAvailabilityZonesCopier.copyFromBuilder(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<AvailabilityZoneDetail> availabilityZones) {
            this.availabilityZones = TraceAvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(AvailabilityZoneDetail... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(Consumer<AvailabilityZoneDetail.Builder>... availabilityZones) {
            availabilityZones(Stream.of(availabilityZones).map(c -> AvailabilityZoneDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ServiceId.Builder getEntryPoint() {
            return entryPoint != null ? entryPoint.toBuilder() : null;
        }

        public final void setEntryPoint(ServiceId.BuilderImpl entryPoint) {
            this.entryPoint = entryPoint != null ? entryPoint.build() : null;
        }

        @Override
        public final Builder entryPoint(ServiceId entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        public final List<FaultRootCause.Builder> getFaultRootCauses() {
            List<FaultRootCause.Builder> result = FaultRootCausesCopier.copyToBuilder(this.faultRootCauses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFaultRootCauses(Collection<FaultRootCause.BuilderImpl> faultRootCauses) {
            this.faultRootCauses = FaultRootCausesCopier.copyFromBuilder(faultRootCauses);
        }

        @Override
        public final Builder faultRootCauses(Collection<FaultRootCause> faultRootCauses) {
            this.faultRootCauses = FaultRootCausesCopier.copy(faultRootCauses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faultRootCauses(FaultRootCause... faultRootCauses) {
            faultRootCauses(Arrays.asList(faultRootCauses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faultRootCauses(Consumer<FaultRootCause.Builder>... faultRootCauses) {
            faultRootCauses(Stream.of(faultRootCauses).map(c -> FaultRootCause.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ErrorRootCause.Builder> getErrorRootCauses() {
            List<ErrorRootCause.Builder> result = ErrorRootCausesCopier.copyToBuilder(this.errorRootCauses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorRootCauses(Collection<ErrorRootCause.BuilderImpl> errorRootCauses) {
            this.errorRootCauses = ErrorRootCausesCopier.copyFromBuilder(errorRootCauses);
        }

        @Override
        public final Builder errorRootCauses(Collection<ErrorRootCause> errorRootCauses) {
            this.errorRootCauses = ErrorRootCausesCopier.copy(errorRootCauses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorRootCauses(ErrorRootCause... errorRootCauses) {
            errorRootCauses(Arrays.asList(errorRootCauses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorRootCauses(Consumer<ErrorRootCause.Builder>... errorRootCauses) {
            errorRootCauses(Stream.of(errorRootCauses).map(c -> ErrorRootCause.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ResponseTimeRootCause.Builder> getResponseTimeRootCauses() {
            List<ResponseTimeRootCause.Builder> result = ResponseTimeRootCausesCopier.copyToBuilder(this.responseTimeRootCauses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResponseTimeRootCauses(Collection<ResponseTimeRootCause.BuilderImpl> responseTimeRootCauses) {
            this.responseTimeRootCauses = ResponseTimeRootCausesCopier.copyFromBuilder(responseTimeRootCauses);
        }

        @Override
        public final Builder responseTimeRootCauses(Collection<ResponseTimeRootCause> responseTimeRootCauses) {
            this.responseTimeRootCauses = ResponseTimeRootCausesCopier.copy(responseTimeRootCauses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseTimeRootCauses(ResponseTimeRootCause... responseTimeRootCauses) {
            responseTimeRootCauses(Arrays.asList(responseTimeRootCauses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseTimeRootCauses(Consumer<ResponseTimeRootCause.Builder>... responseTimeRootCauses) {
            responseTimeRootCauses(Stream.of(responseTimeRootCauses)
                    .map(c -> ResponseTimeRootCause.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getRevision() {
            return revision;
        }

        public final void setRevision(Integer revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(Integer revision) {
            this.revision = revision;
            return this;
        }

        public final Instant getMatchedEventTime() {
            return matchedEventTime;
        }

        public final void setMatchedEventTime(Instant matchedEventTime) {
            this.matchedEventTime = matchedEventTime;
        }

        @Override
        public final Builder matchedEventTime(Instant matchedEventTime) {
            this.matchedEventTime = matchedEventTime;
            return this;
        }

        @Override
        public TraceSummary build() {
            return new TraceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
