/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Retrieved information about an application that processed requests, users that made requests, or downstream services,
 * resources, and applications that an application used.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrievedService implements SdkPojo, Serializable,
        ToCopyableBuilder<RetrievedService.Builder, RetrievedService> {
    private static final SdkField<Service> SERVICE_FIELD = SdkField.<Service> builder(MarshallingType.SDK_POJO)
            .memberName("Service").getter(getter(RetrievedService::service)).setter(setter(Builder::service))
            .constructor(Service::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()).build();

    private static final SdkField<List<GraphLink>> LINKS_FIELD = SdkField
            .<List<GraphLink>> builder(MarshallingType.LIST)
            .memberName("Links")
            .getter(getter(RetrievedService::links))
            .setter(setter(Builder::links))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Links").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GraphLink> builder(MarshallingType.SDK_POJO)
                                            .constructor(GraphLink::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD, LINKS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Service service;

    private final List<GraphLink> links;

    private RetrievedService(BuilderImpl builder) {
        this.service = builder.service;
        this.links = builder.links;
    }

    /**
     * Returns the value of the Service property for this object.
     * 
     * @return The value of the Service property for this object.
     */
    public final Service service() {
        return service;
    }

    /**
     * For responses, this returns true if the service returned a value for the Links property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasLinks() {
        return links != null && !(links instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Relation between two 2 services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLinks} method.
     * </p>
     * 
     * @return Relation between two 2 services.
     */
    public final List<GraphLink> links() {
        return links;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(hasLinks() ? links() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrievedService)) {
            return false;
        }
        RetrievedService other = (RetrievedService) obj;
        return Objects.equals(service(), other.service()) && hasLinks() == other.hasLinks()
                && Objects.equals(links(), other.links());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrievedService").add("Service", service()).add("Links", hasLinks() ? links() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Service":
            return Optional.ofNullable(clazz.cast(service()));
        case "Links":
            return Optional.ofNullable(clazz.cast(links()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Service", SERVICE_FIELD);
        map.put("Links", LINKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrievedService, T> g) {
        return obj -> g.apply((RetrievedService) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetrievedService> {
        /**
         * Sets the value of the Service property for this object.
         *
         * @param service
         *        The new value for the Service property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(Service service);

        /**
         * Sets the value of the Service property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Service.Builder} avoiding the need to
         * create one manually via {@link Service#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Service.Builder#build()} is called immediately and its result is
         * passed to {@link #service(Service)}.
         * 
         * @param service
         *        a consumer that will call methods on {@link Service.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #service(Service)
         */
        default Builder service(Consumer<Service.Builder> service) {
            return service(Service.builder().applyMutation(service).build());
        }

        /**
         * <p>
         * Relation between two 2 services.
         * </p>
         * 
         * @param links
         *        Relation between two 2 services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder links(Collection<GraphLink> links);

        /**
         * <p>
         * Relation between two 2 services.
         * </p>
         * 
         * @param links
         *        Relation between two 2 services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder links(GraphLink... links);

        /**
         * <p>
         * Relation between two 2 services.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.xray.model.GraphLink.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.xray.model.GraphLink#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.xray.model.GraphLink.Builder#build()} is called immediately and its
         * result is passed to {@link #links(List<GraphLink>)}.
         * 
         * @param links
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.xray.model.GraphLink.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #links(java.util.Collection<GraphLink>)
         */
        Builder links(Consumer<GraphLink.Builder>... links);
    }

    static final class BuilderImpl implements Builder {
        private Service service;

        private List<GraphLink> links = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RetrievedService model) {
            service(model.service);
            links(model.links);
        }

        public final Service.Builder getService() {
            return service != null ? service.toBuilder() : null;
        }

        public final void setService(Service.BuilderImpl service) {
            this.service = service != null ? service.build() : null;
        }

        @Override
        public final Builder service(Service service) {
            this.service = service;
            return this;
        }

        public final List<GraphLink.Builder> getLinks() {
            List<GraphLink.Builder> result = LinksListCopier.copyToBuilder(this.links);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLinks(Collection<GraphLink.BuilderImpl> links) {
            this.links = LinksListCopier.copyFromBuilder(links);
        }

        @Override
        public final Builder links(Collection<GraphLink> links) {
            this.links = LinksListCopier.copy(links);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder links(GraphLink... links) {
            links(Arrays.asList(links));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder links(Consumer<GraphLink.Builder>... links) {
            links(Stream.of(links).map(c -> GraphLink.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RetrievedService build() {
            return new RetrievedService(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
