/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure containing configurations related to insights.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InsightsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<InsightsConfiguration.Builder, InsightsConfiguration> {
    private static final SdkField<Boolean> INSIGHTS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("InsightsEnabled").getter(getter(InsightsConfiguration::insightsEnabled))
            .setter(setter(Builder::insightsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightsEnabled").build()).build();

    private static final SdkField<Boolean> NOTIFICATIONS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NotificationsEnabled").getter(getter(InsightsConfiguration::notificationsEnabled))
            .setter(setter(Builder::notificationsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationsEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHTS_ENABLED_FIELD,
            NOTIFICATIONS_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean insightsEnabled;

    private final Boolean notificationsEnabled;

    private InsightsConfiguration(BuilderImpl builder) {
        this.insightsEnabled = builder.insightsEnabled;
        this.notificationsEnabled = builder.notificationsEnabled;
    }

    /**
     * <p>
     * Set the InsightsEnabled value to true to enable insights or false to disable insights.
     * </p>
     * 
     * @return Set the InsightsEnabled value to true to enable insights or false to disable insights.
     */
    public final Boolean insightsEnabled() {
        return insightsEnabled;
    }

    /**
     * <p>
     * Set the NotificationsEnabled value to true to enable insights notifications. Notifications can only be enabled on
     * a group with InsightsEnabled set to true.
     * </p>
     * 
     * @return Set the NotificationsEnabled value to true to enable insights notifications. Notifications can only be
     *         enabled on a group with InsightsEnabled set to true.
     */
    public final Boolean notificationsEnabled() {
        return notificationsEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(insightsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(notificationsEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightsConfiguration)) {
            return false;
        }
        InsightsConfiguration other = (InsightsConfiguration) obj;
        return Objects.equals(insightsEnabled(), other.insightsEnabled())
                && Objects.equals(notificationsEnabled(), other.notificationsEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InsightsConfiguration").add("InsightsEnabled", insightsEnabled())
                .add("NotificationsEnabled", notificationsEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InsightsEnabled":
            return Optional.ofNullable(clazz.cast(insightsEnabled()));
        case "NotificationsEnabled":
            return Optional.ofNullable(clazz.cast(notificationsEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InsightsEnabled", INSIGHTS_ENABLED_FIELD);
        map.put("NotificationsEnabled", NOTIFICATIONS_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InsightsConfiguration, T> g) {
        return obj -> g.apply((InsightsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InsightsConfiguration> {
        /**
         * <p>
         * Set the InsightsEnabled value to true to enable insights or false to disable insights.
         * </p>
         * 
         * @param insightsEnabled
         *        Set the InsightsEnabled value to true to enable insights or false to disable insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightsEnabled(Boolean insightsEnabled);

        /**
         * <p>
         * Set the NotificationsEnabled value to true to enable insights notifications. Notifications can only be
         * enabled on a group with InsightsEnabled set to true.
         * </p>
         * 
         * @param notificationsEnabled
         *        Set the NotificationsEnabled value to true to enable insights notifications. Notifications can only be
         *        enabled on a group with InsightsEnabled set to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationsEnabled(Boolean notificationsEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean insightsEnabled;

        private Boolean notificationsEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(InsightsConfiguration model) {
            insightsEnabled(model.insightsEnabled);
            notificationsEnabled(model.notificationsEnabled);
        }

        public final Boolean getInsightsEnabled() {
            return insightsEnabled;
        }

        public final void setInsightsEnabled(Boolean insightsEnabled) {
            this.insightsEnabled = insightsEnabled;
        }

        @Override
        public final Builder insightsEnabled(Boolean insightsEnabled) {
            this.insightsEnabled = insightsEnabled;
            return this;
        }

        public final Boolean getNotificationsEnabled() {
            return notificationsEnabled;
        }

        public final void setNotificationsEnabled(Boolean notificationsEnabled) {
            this.notificationsEnabled = notificationsEnabled;
        }

        @Override
        public final Builder notificationsEnabled(Boolean notificationsEnabled) {
            this.notificationsEnabled = notificationsEnabled;
            return this;
        }

        @Override
        public InsightsConfiguration build() {
            return new InsightsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
