/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an application that processed requests, users that made requests, or downstream services,
 * resources, and applications that an application used.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InsightImpactGraphService implements SdkPojo, Serializable,
        ToCopyableBuilder<InsightImpactGraphService.Builder, InsightImpactGraphService> {
    private static final SdkField<Integer> REFERENCE_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReferenceId").getter(getter(InsightImpactGraphService::referenceId))
            .setter(setter(Builder::referenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(InsightImpactGraphService::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(InsightImpactGraphService::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Names")
            .getter(getter(InsightImpactGraphService::names))
            .setter(setter(Builder::names))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Names").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(InsightImpactGraphService::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<List<InsightImpactGraphEdge>> EDGES_FIELD = SdkField
            .<List<InsightImpactGraphEdge>> builder(MarshallingType.LIST)
            .memberName("Edges")
            .getter(getter(InsightImpactGraphService::edges))
            .setter(setter(Builder::edges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InsightImpactGraphEdge> builder(MarshallingType.SDK_POJO)
                                            .constructor(InsightImpactGraphEdge::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_ID_FIELD,
            TYPE_FIELD, NAME_FIELD, NAMES_FIELD, ACCOUNT_ID_FIELD, EDGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer referenceId;

    private final String type;

    private final String name;

    private final List<String> names;

    private final String accountId;

    private final List<InsightImpactGraphEdge> edges;

    private InsightImpactGraphService(BuilderImpl builder) {
        this.referenceId = builder.referenceId;
        this.type = builder.type;
        this.name = builder.name;
        this.names = builder.names;
        this.accountId = builder.accountId;
        this.edges = builder.edges;
    }

    /**
     * <p>
     * Identifier for the service. Unique within the service map.
     * </p>
     * 
     * @return Identifier for the service. Unique within the service map.
     */
    public final Integer referenceId() {
        return referenceId;
    }

    /**
     * <p>
     * Identifier for the service. Unique within the service map.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Web Services Resource - The type of an Amazon Web Services resource. For example, AWS::EC2::Instance for
     * an application running on Amazon EC2 or AWS::DynamoDB::Table for an Amazon DynamoDB table that the application
     * used.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Service - The type of an Amazon Web Services service. For example, AWS::DynamoDB for
     * downstream calls to Amazon DynamoDB that didn't target a specific table.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Service - The type of an Amazon Web Services service. For example, AWS::DynamoDB for
     * downstream calls to Amazon DynamoDB that didn't target a specific table.
     * </p>
     * </li>
     * <li>
     * <p>
     * remote - A downstream service of indeterminate type.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Identifier for the service. Unique within the service map.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Amazon Web Services Resource - The type of an Amazon Web Services resource. For example,
     *         AWS::EC2::Instance for an application running on Amazon EC2 or AWS::DynamoDB::Table for an Amazon
     *         DynamoDB table that the application used.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Service - The type of an Amazon Web Services service. For example, AWS::DynamoDB for
     *         downstream calls to Amazon DynamoDB that didn't target a specific table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Service - The type of an Amazon Web Services service. For example, AWS::DynamoDB for
     *         downstream calls to Amazon DynamoDB that didn't target a specific table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         remote - A downstream service of indeterminate type.
     *         </p>
     *         </li>
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The canonical name of the service.
     * </p>
     * 
     * @return The canonical name of the service.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Names property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasNames() {
        return names != null && !(names instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of names for the service, including the canonical name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNames} method.
     * </p>
     * 
     * @return A list of names for the service, including the canonical name.
     */
    public final List<String> names() {
        return names;
    }

    /**
     * <p>
     * Identifier of the Amazon Web Services account in which the service runs.
     * </p>
     * 
     * @return Identifier of the Amazon Web Services account in which the service runs.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Edges property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasEdges() {
        return edges != null && !(edges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Connections to downstream services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEdges} method.
     * </p>
     * 
     * @return Connections to downstream services.
     */
    public final List<InsightImpactGraphEdge> edges() {
        return edges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasNames() ? names() : null);
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasEdges() ? edges() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightImpactGraphService)) {
            return false;
        }
        InsightImpactGraphService other = (InsightImpactGraphService) obj;
        return Objects.equals(referenceId(), other.referenceId()) && Objects.equals(type(), other.type())
                && Objects.equals(name(), other.name()) && hasNames() == other.hasNames()
                && Objects.equals(names(), other.names()) && Objects.equals(accountId(), other.accountId())
                && hasEdges() == other.hasEdges() && Objects.equals(edges(), other.edges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InsightImpactGraphService").add("ReferenceId", referenceId()).add("Type", type())
                .add("Name", name()).add("Names", hasNames() ? names() : null).add("AccountId", accountId())
                .add("Edges", hasEdges() ? edges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReferenceId":
            return Optional.ofNullable(clazz.cast(referenceId()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Names":
            return Optional.ofNullable(clazz.cast(names()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Edges":
            return Optional.ofNullable(clazz.cast(edges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReferenceId", REFERENCE_ID_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Names", NAMES_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("Edges", EDGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InsightImpactGraphService, T> g) {
        return obj -> g.apply((InsightImpactGraphService) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InsightImpactGraphService> {
        /**
         * <p>
         * Identifier for the service. Unique within the service map.
         * </p>
         * 
         * @param referenceId
         *        Identifier for the service. Unique within the service map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceId(Integer referenceId);

        /**
         * <p>
         * Identifier for the service. Unique within the service map.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Amazon Web Services Resource - The type of an Amazon Web Services resource. For example, AWS::EC2::Instance
         * for an application running on Amazon EC2 or AWS::DynamoDB::Table for an Amazon DynamoDB table that the
         * application used.
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Web Services Service - The type of an Amazon Web Services service. For example, AWS::DynamoDB for
         * downstream calls to Amazon DynamoDB that didn't target a specific table.
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Web Services Service - The type of an Amazon Web Services service. For example, AWS::DynamoDB for
         * downstream calls to Amazon DynamoDB that didn't target a specific table.
         * </p>
         * </li>
         * <li>
         * <p>
         * remote - A downstream service of indeterminate type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        Identifier for the service. Unique within the service map.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Amazon Web Services Resource - The type of an Amazon Web Services resource. For example,
         *        AWS::EC2::Instance for an application running on Amazon EC2 or AWS::DynamoDB::Table for an Amazon
         *        DynamoDB table that the application used.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Web Services Service - The type of an Amazon Web Services service. For example, AWS::DynamoDB
         *        for downstream calls to Amazon DynamoDB that didn't target a specific table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Web Services Service - The type of an Amazon Web Services service. For example, AWS::DynamoDB
         *        for downstream calls to Amazon DynamoDB that didn't target a specific table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        remote - A downstream service of indeterminate type.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The canonical name of the service.
         * </p>
         * 
         * @param name
         *        The canonical name of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list of names for the service, including the canonical name.
         * </p>
         * 
         * @param names
         *        A list of names for the service, including the canonical name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(Collection<String> names);

        /**
         * <p>
         * A list of names for the service, including the canonical name.
         * </p>
         * 
         * @param names
         *        A list of names for the service, including the canonical name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(String... names);

        /**
         * <p>
         * Identifier of the Amazon Web Services account in which the service runs.
         * </p>
         * 
         * @param accountId
         *        Identifier of the Amazon Web Services account in which the service runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Connections to downstream services.
         * </p>
         * 
         * @param edges
         *        Connections to downstream services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edges(Collection<InsightImpactGraphEdge> edges);

        /**
         * <p>
         * Connections to downstream services.
         * </p>
         * 
         * @param edges
         *        Connections to downstream services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edges(InsightImpactGraphEdge... edges);

        /**
         * <p>
         * Connections to downstream services.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.xray.model.InsightImpactGraphEdge.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.xray.model.InsightImpactGraphEdge#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.xray.model.InsightImpactGraphEdge.Builder#build()} is called
         * immediately and its result is passed to {@link #edges(List<InsightImpactGraphEdge>)}.
         * 
         * @param edges
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.xray.model.InsightImpactGraphEdge.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #edges(java.util.Collection<InsightImpactGraphEdge>)
         */
        Builder edges(Consumer<InsightImpactGraphEdge.Builder>... edges);
    }

    static final class BuilderImpl implements Builder {
        private Integer referenceId;

        private String type;

        private String name;

        private List<String> names = DefaultSdkAutoConstructList.getInstance();

        private String accountId;

        private List<InsightImpactGraphEdge> edges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InsightImpactGraphService model) {
            referenceId(model.referenceId);
            type(model.type);
            name(model.name);
            names(model.names);
            accountId(model.accountId);
            edges(model.edges);
        }

        public final Integer getReferenceId() {
            return referenceId;
        }

        public final void setReferenceId(Integer referenceId) {
            this.referenceId = referenceId;
        }

        @Override
        public final Builder referenceId(Integer referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getNames() {
            if (names instanceof SdkAutoConstructList) {
                return null;
            }
            return names;
        }

        public final void setNames(Collection<String> names) {
            this.names = ServiceNamesCopier.copy(names);
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = ServiceNamesCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String... names) {
            names(Arrays.asList(names));
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final List<InsightImpactGraphEdge.Builder> getEdges() {
            List<InsightImpactGraphEdge.Builder> result = InsightImpactGraphEdgeListCopier.copyToBuilder(this.edges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEdges(Collection<InsightImpactGraphEdge.BuilderImpl> edges) {
            this.edges = InsightImpactGraphEdgeListCopier.copyFromBuilder(edges);
        }

        @Override
        public final Builder edges(Collection<InsightImpactGraphEdge> edges) {
            this.edges = InsightImpactGraphEdgeListCopier.copy(edges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edges(InsightImpactGraphEdge... edges) {
            edges(Arrays.asList(edges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edges(Consumer<InsightImpactGraphEdge.Builder>... edges) {
            edges(Stream.of(edges).map(c -> InsightImpactGraphEdge.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public InsightImpactGraphService build() {
            return new InsightImpactGraphService(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
