/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The predicted high and low fault count. This is used to determine if a service has become anomalous and if an insight
 * should be created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ForecastStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<ForecastStatistics.Builder, ForecastStatistics> {
    private static final SdkField<Long> FAULT_COUNT_HIGH_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FaultCountHigh").getter(getter(ForecastStatistics::faultCountHigh))
            .setter(setter(Builder::faultCountHigh))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaultCountHigh").build()).build();

    private static final SdkField<Long> FAULT_COUNT_LOW_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FaultCountLow").getter(getter(ForecastStatistics::faultCountLow)).setter(setter(Builder::faultCountLow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaultCountLow").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAULT_COUNT_HIGH_FIELD,
            FAULT_COUNT_LOW_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long faultCountHigh;

    private final Long faultCountLow;

    private ForecastStatistics(BuilderImpl builder) {
        this.faultCountHigh = builder.faultCountHigh;
        this.faultCountLow = builder.faultCountLow;
    }

    /**
     * <p>
     * The upper limit of fault counts for a service.
     * </p>
     * 
     * @return The upper limit of fault counts for a service.
     */
    public final Long faultCountHigh() {
        return faultCountHigh;
    }

    /**
     * <p>
     * The lower limit of fault counts for a service.
     * </p>
     * 
     * @return The lower limit of fault counts for a service.
     */
    public final Long faultCountLow() {
        return faultCountLow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(faultCountHigh());
        hashCode = 31 * hashCode + Objects.hashCode(faultCountLow());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForecastStatistics)) {
            return false;
        }
        ForecastStatistics other = (ForecastStatistics) obj;
        return Objects.equals(faultCountHigh(), other.faultCountHigh()) && Objects.equals(faultCountLow(), other.faultCountLow());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ForecastStatistics").add("FaultCountHigh", faultCountHigh())
                .add("FaultCountLow", faultCountLow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FaultCountHigh":
            return Optional.ofNullable(clazz.cast(faultCountHigh()));
        case "FaultCountLow":
            return Optional.ofNullable(clazz.cast(faultCountLow()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FaultCountHigh", FAULT_COUNT_HIGH_FIELD);
        map.put("FaultCountLow", FAULT_COUNT_LOW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ForecastStatistics, T> g) {
        return obj -> g.apply((ForecastStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ForecastStatistics> {
        /**
         * <p>
         * The upper limit of fault counts for a service.
         * </p>
         * 
         * @param faultCountHigh
         *        The upper limit of fault counts for a service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faultCountHigh(Long faultCountHigh);

        /**
         * <p>
         * The lower limit of fault counts for a service.
         * </p>
         * 
         * @param faultCountLow
         *        The lower limit of fault counts for a service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faultCountLow(Long faultCountLow);
    }

    static final class BuilderImpl implements Builder {
        private Long faultCountHigh;

        private Long faultCountLow;

        private BuilderImpl() {
        }

        private BuilderImpl(ForecastStatistics model) {
            faultCountHigh(model.faultCountHigh);
            faultCountLow(model.faultCountLow);
        }

        public final Long getFaultCountHigh() {
            return faultCountHigh;
        }

        public final void setFaultCountHigh(Long faultCountHigh) {
            this.faultCountHigh = faultCountHigh;
        }

        @Override
        public final Builder faultCountHigh(Long faultCountHigh) {
            this.faultCountHigh = faultCountHigh;
            return this;
        }

        public final Long getFaultCountLow() {
            return faultCountLow;
        }

        public final void setFaultCountLow(Long faultCountLow) {
            this.faultCountLow = faultCountLow;
        }

        @Override
        public final Builder faultCountLow(Long faultCountLow) {
            this.faultCountLow = faultCountLow;
            return this;
        }

        @Override
        public ForecastStatistics build() {
            return new ForecastStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
