/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SamplingRateBoost
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SamplingRateBoost> {
    private static final SdkField<Double> MAX_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MaxRate").getter(SamplingRateBoost.getter(SamplingRateBoost::maxRate)).setter(SamplingRateBoost.setter(Builder::maxRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRate").build()}).build();
    private static final SdkField<Integer> COOLDOWN_WINDOW_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CooldownWindowMinutes").getter(SamplingRateBoost.getter(SamplingRateBoost::cooldownWindowMinutes)).setter(SamplingRateBoost.setter(Builder::cooldownWindowMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CooldownWindowMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RATE_FIELD, COOLDOWN_WINDOW_MINUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SamplingRateBoost.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double maxRate;
    private final Integer cooldownWindowMinutes;

    private SamplingRateBoost(BuilderImpl builder) {
        this.maxRate = builder.maxRate;
        this.cooldownWindowMinutes = builder.cooldownWindowMinutes;
    }

    public final Double maxRate() {
        return this.maxRate;
    }

    public final Integer cooldownWindowMinutes() {
        return this.cooldownWindowMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.cooldownWindowMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamplingRateBoost)) {
            return false;
        }
        SamplingRateBoost other = (SamplingRateBoost)obj;
        return Objects.equals(this.maxRate(), other.maxRate()) && Objects.equals(this.cooldownWindowMinutes(), other.cooldownWindowMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"SamplingRateBoost").add("MaxRate", (Object)this.maxRate()).add("CooldownWindowMinutes", (Object)this.cooldownWindowMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxRate": {
                return Optional.ofNullable(clazz.cast(this.maxRate()));
            }
            case "CooldownWindowMinutes": {
                return Optional.ofNullable(clazz.cast(this.cooldownWindowMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MaxRate", MAX_RATE_FIELD);
        map.put("CooldownWindowMinutes", COOLDOWN_WINDOW_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SamplingRateBoost, T> g) {
        return obj -> g.apply((SamplingRateBoost)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double maxRate;
        private Integer cooldownWindowMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(SamplingRateBoost model) {
            this.maxRate(model.maxRate);
            this.cooldownWindowMinutes(model.cooldownWindowMinutes);
        }

        public final Double getMaxRate() {
            return this.maxRate;
        }

        public final void setMaxRate(Double maxRate) {
            this.maxRate = maxRate;
        }

        @Override
        public final Builder maxRate(Double maxRate) {
            this.maxRate = maxRate;
            return this;
        }

        public final Integer getCooldownWindowMinutes() {
            return this.cooldownWindowMinutes;
        }

        public final void setCooldownWindowMinutes(Integer cooldownWindowMinutes) {
            this.cooldownWindowMinutes = cooldownWindowMinutes;
        }

        @Override
        public final Builder cooldownWindowMinutes(Integer cooldownWindowMinutes) {
            this.cooldownWindowMinutes = cooldownWindowMinutes;
            return this;
        }

        public SamplingRateBoost build() {
            return new SamplingRateBoost(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SamplingRateBoost> {
        public Builder maxRate(Double var1);

        public Builder cooldownWindowMinutes(Integer var1);
    }
}

