/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.Span;
import software.amazon.awssdk.services.xray.model.SpanListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetrievedTrace
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetrievedTrace> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(RetrievedTrace.getter(RetrievedTrace::id)).setter(RetrievedTrace.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Double> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Duration").getter(RetrievedTrace.getter(RetrievedTrace::duration)).setter(RetrievedTrace.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<List<Span>> SPANS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Spans").getter(RetrievedTrace.getter(RetrievedTrace::spans)).setter(RetrievedTrace.setter(Builder::spans)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Spans").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Span::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DURATION_FIELD, SPANS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RetrievedTrace.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Double duration;
    private final List<Span> spans;

    private RetrievedTrace(BuilderImpl builder) {
        this.id = builder.id;
        this.duration = builder.duration;
        this.spans = builder.spans;
    }

    public final String id() {
        return this.id;
    }

    public final Double duration() {
        return this.duration;
    }

    public final boolean hasSpans() {
        return this.spans != null && !(this.spans instanceof SdkAutoConstructList);
    }

    public final List<Span> spans() {
        return this.spans;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpans() ? this.spans() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrievedTrace)) {
            return false;
        }
        RetrievedTrace other = (RetrievedTrace)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.duration(), other.duration()) && this.hasSpans() == other.hasSpans() && Objects.equals(this.spans(), other.spans());
    }

    public final String toString() {
        return ToString.builder((String)"RetrievedTrace").add("Id", (Object)this.id()).add("Duration", (Object)this.duration()).add("Spans", this.hasSpans() ? this.spans() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "Spans": {
                return Optional.ofNullable(clazz.cast(this.spans()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("Spans", SPANS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrievedTrace, T> g) {
        return obj -> g.apply((RetrievedTrace)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Double duration;
        private List<Span> spans = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RetrievedTrace model) {
            this.id(model.id);
            this.duration(model.duration);
            this.spans(model.spans);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Double getDuration() {
            return this.duration;
        }

        public final void setDuration(Double duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Double duration) {
            this.duration = duration;
            return this;
        }

        public final List<Span.Builder> getSpans() {
            List<Span.Builder> result = SpanListCopier.copyToBuilder(this.spans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSpans(Collection<Span.BuilderImpl> spans) {
            this.spans = SpanListCopier.copyFromBuilder(spans);
        }

        @Override
        public final Builder spans(Collection<Span> spans) {
            this.spans = SpanListCopier.copy(spans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spans(Span ... spans) {
            this.spans(Arrays.asList(spans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spans(Consumer<Span.Builder> ... spans) {
            this.spans(Stream.of(spans).map(c -> (Span)((Span.Builder)Span.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RetrievedTrace build() {
            return new RetrievedTrace(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetrievedTrace> {
        public Builder id(String var1);

        public Builder duration(Double var1);

        public Builder spans(Collection<Span> var1);

        public Builder spans(Span ... var1);

        public Builder spans(Consumer<Span.Builder> ... var1);
    }
}

