/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnnotationValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnnotationValue> {
    private static final SdkField<Double> NUMBER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("NumberValue").getter(AnnotationValue.getter(AnnotationValue::numberValue)).setter(AnnotationValue.setter(Builder::numberValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberValue").build()}).build();
    private static final SdkField<Boolean> BOOLEAN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("BooleanValue").getter(AnnotationValue.getter(AnnotationValue::booleanValue)).setter(AnnotationValue.setter(Builder::booleanValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BooleanValue").build()}).build();
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StringValue").getter(AnnotationValue.getter(AnnotationValue::stringValue)).setter(AnnotationValue.setter(Builder::stringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_VALUE_FIELD, BOOLEAN_VALUE_FIELD, STRING_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnnotationValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double numberValue;
    private final Boolean booleanValue;
    private final String stringValue;
    private final Type type;

    private AnnotationValue(BuilderImpl builder) {
        this.numberValue = builder.numberValue;
        this.booleanValue = builder.booleanValue;
        this.stringValue = builder.stringValue;
        this.type = builder.type;
    }

    public final Double numberValue() {
        return this.numberValue;
    }

    public final Boolean booleanValue() {
        return this.booleanValue;
    }

    public final String stringValue() {
        return this.stringValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numberValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnnotationValue)) {
            return false;
        }
        AnnotationValue other = (AnnotationValue)obj;
        return Objects.equals(this.numberValue(), other.numberValue()) && Objects.equals(this.booleanValue(), other.booleanValue()) && Objects.equals(this.stringValue(), other.stringValue());
    }

    public final String toString() {
        return ToString.builder((String)"AnnotationValue").add("NumberValue", (Object)this.numberValue()).add("BooleanValue", (Object)this.booleanValue()).add("StringValue", (Object)this.stringValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumberValue": {
                return Optional.ofNullable(clazz.cast(this.numberValue()));
            }
            case "BooleanValue": {
                return Optional.ofNullable(clazz.cast(this.booleanValue()));
            }
            case "StringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
        }
        return Optional.empty();
    }

    public static AnnotationValue fromNumberValue(Double numberValue) {
        return (AnnotationValue)AnnotationValue.builder().numberValue(numberValue).build();
    }

    public static AnnotationValue fromBooleanValue(Boolean booleanValue) {
        return (AnnotationValue)AnnotationValue.builder().booleanValue(booleanValue).build();
    }

    public static AnnotationValue fromStringValue(String stringValue) {
        return (AnnotationValue)AnnotationValue.builder().stringValue(stringValue).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NumberValue", NUMBER_VALUE_FIELD);
        map.put("BooleanValue", BOOLEAN_VALUE_FIELD);
        map.put("StringValue", STRING_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnnotationValue, T> g) {
        return obj -> g.apply((AnnotationValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        NUMBER_VALUE,
        BOOLEAN_VALUE,
        STRING_VALUE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Double numberValue;
        private Boolean booleanValue;
        private String stringValue;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AnnotationValue model) {
            this.numberValue(model.numberValue);
            this.booleanValue(model.booleanValue);
            this.stringValue(model.stringValue);
        }

        public final Double getNumberValue() {
            return this.numberValue;
        }

        public final void setNumberValue(Double numberValue) {
            Double oldValue = this.numberValue;
            this.numberValue = numberValue;
            this.handleUnionValueChange(Type.NUMBER_VALUE, oldValue, this.numberValue);
        }

        @Override
        public final Builder numberValue(Double numberValue) {
            Double oldValue = this.numberValue;
            this.numberValue = numberValue;
            this.handleUnionValueChange(Type.NUMBER_VALUE, oldValue, this.numberValue);
            return this;
        }

        public final Boolean getBooleanValue() {
            return this.booleanValue;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            Boolean oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            this.handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            Boolean oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            this.handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
            return this;
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        public final void setStringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public AnnotationValue build() {
            return new AnnotationValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnnotationValue> {
        public Builder numberValue(Double var1);

        public Builder booleanValue(Boolean var1);

        public Builder stringValue(String var1);
    }
}

