/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.UnprocessedTraceSegment;
import software.amazon.awssdk.services.xray.model.UnprocessedTraceSegmentListCopier;
import software.amazon.awssdk.services.xray.model.XRayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutTraceSegmentsResponse
extends XRayResponse
implements ToCopyableBuilder<Builder, PutTraceSegmentsResponse> {
    private static final SdkField<List<UnprocessedTraceSegment>> UNPROCESSED_TRACE_SEGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PutTraceSegmentsResponse.getter(PutTraceSegmentsResponse::unprocessedTraceSegments)).setter(PutTraceSegmentsResponse.setter(Builder::unprocessedTraceSegments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedTraceSegments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnprocessedTraceSegment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNPROCESSED_TRACE_SEGMENTS_FIELD));
    private final List<UnprocessedTraceSegment> unprocessedTraceSegments;

    private PutTraceSegmentsResponse(BuilderImpl builder) {
        super(builder);
        this.unprocessedTraceSegments = builder.unprocessedTraceSegments;
    }

    public List<UnprocessedTraceSegment> unprocessedTraceSegments() {
        return this.unprocessedTraceSegments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.unprocessedTraceSegments());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTraceSegmentsResponse)) {
            return false;
        }
        PutTraceSegmentsResponse other = (PutTraceSegmentsResponse)((Object)obj);
        return Objects.equals(this.unprocessedTraceSegments(), other.unprocessedTraceSegments());
    }

    public String toString() {
        return ToString.builder((String)"PutTraceSegmentsResponse").add("UnprocessedTraceSegments", this.unprocessedTraceSegments()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UnprocessedTraceSegments": {
                return Optional.ofNullable(clazz.cast(this.unprocessedTraceSegments()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutTraceSegmentsResponse, T> g) {
        return obj -> g.apply((PutTraceSegmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends XRayResponse.BuilderImpl
    implements Builder {
        private List<UnprocessedTraceSegment> unprocessedTraceSegments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutTraceSegmentsResponse model) {
            super(model);
            this.unprocessedTraceSegments(model.unprocessedTraceSegments);
        }

        public final Collection<UnprocessedTraceSegment.Builder> getUnprocessedTraceSegments() {
            return this.unprocessedTraceSegments != null ? (Collection)this.unprocessedTraceSegments.stream().map(UnprocessedTraceSegment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unprocessedTraceSegments(Collection<UnprocessedTraceSegment> unprocessedTraceSegments) {
            this.unprocessedTraceSegments = UnprocessedTraceSegmentListCopier.copy(unprocessedTraceSegments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedTraceSegments(UnprocessedTraceSegment ... unprocessedTraceSegments) {
            this.unprocessedTraceSegments(Arrays.asList(unprocessedTraceSegments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedTraceSegments(Consumer<UnprocessedTraceSegment.Builder> ... unprocessedTraceSegments) {
            this.unprocessedTraceSegments(Stream.of(unprocessedTraceSegments).map(c -> (UnprocessedTraceSegment)((UnprocessedTraceSegment.Builder)UnprocessedTraceSegment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnprocessedTraceSegments(Collection<UnprocessedTraceSegment.BuilderImpl> unprocessedTraceSegments) {
            this.unprocessedTraceSegments = UnprocessedTraceSegmentListCopier.copyFromBuilder(unprocessedTraceSegments);
        }

        @Override
        public PutTraceSegmentsResponse build() {
            return new PutTraceSegmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends XRayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutTraceSegmentsResponse> {
        public Builder unprocessedTraceSegments(Collection<UnprocessedTraceSegment> var1);

        public Builder unprocessedTraceSegments(UnprocessedTraceSegment ... var1);

        public Builder unprocessedTraceSegments(Consumer<UnprocessedTraceSegment.Builder> ... var1);
    }
}

