/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TraceSegmentDestination {
    X_RAY("XRay"),
    CLOUD_WATCH_LOGS("CloudWatchLogs"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TraceSegmentDestination> VALUE_MAP;
    private final String value;

    private TraceSegmentDestination(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TraceSegmentDestination fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TraceSegmentDestination> knownValues() {
        EnumSet<TraceSegmentDestination> knownValues = EnumSet.allOf(TraceSegmentDestination.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TraceSegmentDestination.class, TraceSegmentDestination::toString);
    }
}

