/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SamplingTargetDocument
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SamplingTargetDocument> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleName").getter(SamplingTargetDocument.getter(SamplingTargetDocument::ruleName)).setter(SamplingTargetDocument.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()}).build();
    private static final SdkField<Double> FIXED_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("FixedRate").getter(SamplingTargetDocument.getter(SamplingTargetDocument::fixedRate)).setter(SamplingTargetDocument.setter(Builder::fixedRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedRate").build()}).build();
    private static final SdkField<Integer> RESERVOIR_QUOTA_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReservoirQuota").getter(SamplingTargetDocument.getter(SamplingTargetDocument::reservoirQuota)).setter(SamplingTargetDocument.setter(Builder::reservoirQuota)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservoirQuota").build()}).build();
    private static final SdkField<Instant> RESERVOIR_QUOTA_TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReservoirQuotaTTL").getter(SamplingTargetDocument.getter(SamplingTargetDocument::reservoirQuotaTTL)).setter(SamplingTargetDocument.setter(Builder::reservoirQuotaTTL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservoirQuotaTTL").build()}).build();
    private static final SdkField<Integer> INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Interval").getter(SamplingTargetDocument.getter(SamplingTargetDocument::interval)).setter(SamplingTargetDocument.setter(Builder::interval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD, FIXED_RATE_FIELD, RESERVOIR_QUOTA_FIELD, RESERVOIR_QUOTA_TTL_FIELD, INTERVAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RuleName", RULE_NAME_FIELD);
            this.put("FixedRate", FIXED_RATE_FIELD);
            this.put("ReservoirQuota", RESERVOIR_QUOTA_FIELD);
            this.put("ReservoirQuotaTTL", RESERVOIR_QUOTA_TTL_FIELD);
            this.put("Interval", INTERVAL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String ruleName;
    private final Double fixedRate;
    private final Integer reservoirQuota;
    private final Instant reservoirQuotaTTL;
    private final Integer interval;

    private SamplingTargetDocument(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.fixedRate = builder.fixedRate;
        this.reservoirQuota = builder.reservoirQuota;
        this.reservoirQuotaTTL = builder.reservoirQuotaTTL;
        this.interval = builder.interval;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    public final Double fixedRate() {
        return this.fixedRate;
    }

    public final Integer reservoirQuota() {
        return this.reservoirQuota;
    }

    public final Instant reservoirQuotaTTL() {
        return this.reservoirQuotaTTL;
    }

    public final Integer interval() {
        return this.interval;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservoirQuota());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservoirQuotaTTL());
        hashCode = 31 * hashCode + Objects.hashCode(this.interval());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamplingTargetDocument)) {
            return false;
        }
        SamplingTargetDocument other = (SamplingTargetDocument)obj;
        return Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.fixedRate(), other.fixedRate()) && Objects.equals(this.reservoirQuota(), other.reservoirQuota()) && Objects.equals(this.reservoirQuotaTTL(), other.reservoirQuotaTTL()) && Objects.equals(this.interval(), other.interval());
    }

    public final String toString() {
        return ToString.builder((String)"SamplingTargetDocument").add("RuleName", (Object)this.ruleName()).add("FixedRate", (Object)this.fixedRate()).add("ReservoirQuota", (Object)this.reservoirQuota()).add("ReservoirQuotaTTL", (Object)this.reservoirQuotaTTL()).add("Interval", (Object)this.interval()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "FixedRate": {
                return Optional.ofNullable(clazz.cast(this.fixedRate()));
            }
            case "ReservoirQuota": {
                return Optional.ofNullable(clazz.cast(this.reservoirQuota()));
            }
            case "ReservoirQuotaTTL": {
                return Optional.ofNullable(clazz.cast(this.reservoirQuotaTTL()));
            }
            case "Interval": {
                return Optional.ofNullable(clazz.cast(this.interval()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SamplingTargetDocument, T> g) {
        return obj -> g.apply((SamplingTargetDocument)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleName;
        private Double fixedRate;
        private Integer reservoirQuota;
        private Instant reservoirQuotaTTL;
        private Integer interval;

        private BuilderImpl() {
        }

        private BuilderImpl(SamplingTargetDocument model) {
            this.ruleName(model.ruleName);
            this.fixedRate(model.fixedRate);
            this.reservoirQuota(model.reservoirQuota);
            this.reservoirQuotaTTL(model.reservoirQuotaTTL);
            this.interval(model.interval);
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final Double getFixedRate() {
            return this.fixedRate;
        }

        public final void setFixedRate(Double fixedRate) {
            this.fixedRate = fixedRate;
        }

        @Override
        public final Builder fixedRate(Double fixedRate) {
            this.fixedRate = fixedRate;
            return this;
        }

        public final Integer getReservoirQuota() {
            return this.reservoirQuota;
        }

        public final void setReservoirQuota(Integer reservoirQuota) {
            this.reservoirQuota = reservoirQuota;
        }

        @Override
        public final Builder reservoirQuota(Integer reservoirQuota) {
            this.reservoirQuota = reservoirQuota;
            return this;
        }

        public final Instant getReservoirQuotaTTL() {
            return this.reservoirQuotaTTL;
        }

        public final void setReservoirQuotaTTL(Instant reservoirQuotaTTL) {
            this.reservoirQuotaTTL = reservoirQuotaTTL;
        }

        @Override
        public final Builder reservoirQuotaTTL(Instant reservoirQuotaTTL) {
            this.reservoirQuotaTTL = reservoirQuotaTTL;
            return this;
        }

        public final Integer getInterval() {
            return this.interval;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        @Override
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public SamplingTargetDocument build() {
            return new SamplingTargetDocument(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SamplingTargetDocument> {
        public Builder ruleName(String var1);

        public Builder fixedRate(Double var1);

        public Builder reservoirQuota(Integer var1);

        public Builder reservoirQuotaTTL(Instant var1);

        public Builder interval(Integer var1);
    }
}

