/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The service within the service graph that has anomalously high fault rates.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnomalousService implements SdkPojo, Serializable,
        ToCopyableBuilder<AnomalousService.Builder, AnomalousService> {
    private static final SdkField<ServiceId> SERVICE_ID_FIELD = SdkField.<ServiceId> builder(MarshallingType.SDK_POJO)
            .memberName("ServiceId").getter(getter(AnomalousService::serviceId)).setter(setter(Builder::serviceId))
            .constructor(ServiceId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final ServiceId serviceId;

    private AnomalousService(BuilderImpl builder) {
        this.serviceId = builder.serviceId;
    }

    /**
     * Returns the value of the ServiceId property for this object.
     * 
     * @return The value of the ServiceId property for this object.
     */
    public final ServiceId serviceId() {
        return serviceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalousService)) {
            return false;
        }
        AnomalousService other = (AnomalousService) obj;
        return Objects.equals(serviceId(), other.serviceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnomalousService").add("ServiceId", serviceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceId":
            return Optional.ofNullable(clazz.cast(serviceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnomalousService, T> g) {
        return obj -> g.apply((AnomalousService) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnomalousService> {
        /**
         * Sets the value of the ServiceId property for this object.
         *
         * @param serviceId
         *        The new value for the ServiceId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceId(ServiceId serviceId);

        /**
         * Sets the value of the ServiceId property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ServiceId.Builder} avoiding the need to
         * create one manually via {@link ServiceId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceId.Builder#build()} is called immediately and its result
         * is passed to {@link #serviceId(ServiceId)}.
         * 
         * @param serviceId
         *        a consumer that will call methods on {@link ServiceId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceId(ServiceId)
         */
        default Builder serviceId(Consumer<ServiceId.Builder> serviceId) {
            return serviceId(ServiceId.builder().applyMutation(serviceId).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ServiceId serviceId;

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalousService model) {
            serviceId(model.serviceId);
        }

        public final ServiceId.Builder getServiceId() {
            return serviceId != null ? serviceId.toBuilder() : null;
        }

        public final void setServiceId(ServiceId.BuilderImpl serviceId) {
            this.serviceId = serviceId != null ? serviceId.build() : null;
        }

        @Override
        public final Builder serviceId(ServiceId serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        @Override
        public AnomalousService build() {
            return new AnomalousService(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
