/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.xray.XRayAsyncClient;
import software.amazon.awssdk.services.xray.internal.UserAgentUtils;
import software.amazon.awssdk.services.xray.model.BatchGetTracesRequest;
import software.amazon.awssdk.services.xray.model.BatchGetTracesResponse;
import software.amazon.awssdk.services.xray.model.Trace;

public class BatchGetTracesPublisher
implements SdkPublisher<BatchGetTracesResponse> {
    private final XRayAsyncClient client;
    private final BatchGetTracesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public BatchGetTracesPublisher(XRayAsyncClient client, BatchGetTracesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private BatchGetTracesPublisher(XRayAsyncClient client, BatchGetTracesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new BatchGetTracesResponseFetcher();
    }

    public void subscribe(Subscriber<? super BatchGetTracesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Trace> traces() {
        Function<BatchGetTracesResponse, Iterator> getIterator = response -> {
            if (response != null && response.traces() != null) {
                return response.traces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new BatchGetTracesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class BatchGetTracesResponseFetcher
    implements AsyncPageFetcher<BatchGetTracesResponse> {
        private BatchGetTracesResponseFetcher() {
        }

        public boolean hasNextPage(BatchGetTracesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<BatchGetTracesResponse> nextPage(BatchGetTracesResponse previousPage) {
            if (previousPage == null) {
                return BatchGetTracesPublisher.this.client.batchGetTraces(BatchGetTracesPublisher.this.firstRequest);
            }
            return BatchGetTracesPublisher.this.client.batchGetTraces((BatchGetTracesRequest)((Object)BatchGetTracesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

