/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.xray.model.AnnotationsCopier;
import software.amazon.awssdk.services.xray.model.AvailabilityZoneDetail;
import software.amazon.awssdk.services.xray.model.ErrorRootCause;
import software.amazon.awssdk.services.xray.model.ErrorRootCausesCopier;
import software.amazon.awssdk.services.xray.model.FaultRootCause;
import software.amazon.awssdk.services.xray.model.FaultRootCausesCopier;
import software.amazon.awssdk.services.xray.model.Http;
import software.amazon.awssdk.services.xray.model.InstanceIdDetail;
import software.amazon.awssdk.services.xray.model.ResourceARNDetail;
import software.amazon.awssdk.services.xray.model.ResponseTimeRootCause;
import software.amazon.awssdk.services.xray.model.ResponseTimeRootCausesCopier;
import software.amazon.awssdk.services.xray.model.ServiceId;
import software.amazon.awssdk.services.xray.model.ServiceIdsCopier;
import software.amazon.awssdk.services.xray.model.TraceAvailabilityZonesCopier;
import software.amazon.awssdk.services.xray.model.TraceInstanceIdsCopier;
import software.amazon.awssdk.services.xray.model.TraceResourceARNsCopier;
import software.amazon.awssdk.services.xray.model.TraceUser;
import software.amazon.awssdk.services.xray.model.TraceUsersCopier;
import software.amazon.awssdk.services.xray.model.ValueWithServiceIds;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TraceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TraceSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(TraceSummary.getter(TraceSummary::id)).setter(TraceSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Double> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Duration").getter(TraceSummary.getter(TraceSummary::duration)).setter(TraceSummary.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<Double> RESPONSE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ResponseTime").getter(TraceSummary.getter(TraceSummary::responseTime)).setter(TraceSummary.setter(Builder::responseTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseTime").build()}).build();
    private static final SdkField<Boolean> HAS_FAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HasFault").getter(TraceSummary.getter(TraceSummary::hasFault)).setter(TraceSummary.setter(Builder::hasFault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasFault").build()}).build();
    private static final SdkField<Boolean> HAS_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HasError").getter(TraceSummary.getter(TraceSummary::hasError)).setter(TraceSummary.setter(Builder::hasError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasError").build()}).build();
    private static final SdkField<Boolean> HAS_THROTTLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HasThrottle").getter(TraceSummary.getter(TraceSummary::hasThrottle)).setter(TraceSummary.setter(Builder::hasThrottle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasThrottle").build()}).build();
    private static final SdkField<Boolean> IS_PARTIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsPartial").getter(TraceSummary.getter(TraceSummary::isPartial)).setter(TraceSummary.setter(Builder::isPartial)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPartial").build()}).build();
    private static final SdkField<Http> HTTP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Http").getter(TraceSummary.getter(TraceSummary::http)).setter(TraceSummary.setter(Builder::http)).constructor(Http::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Http").build()}).build();
    private static final SdkField<Map<String, List<ValueWithServiceIds>>> ANNOTATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Annotations").getter(TraceSummary.getter(TraceSummary::annotations)).setter(TraceSummary.setter(Builder::annotations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Annotations").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValueWithServiceIds::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<TraceUser>> USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Users").getter(TraceSummary.getter(TraceSummary::users)).setter(TraceSummary.setter(Builder::users)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Users").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TraceUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ServiceId>> SERVICE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceIds").getter(TraceSummary.getter(TraceSummary::serviceIds)).setter(TraceSummary.setter(Builder::serviceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceARNDetail>> RESOURCE_AR_NS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceARNs").getter(TraceSummary.getter(TraceSummary::resourceARNs)).setter(TraceSummary.setter(Builder::resourceARNs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARNs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceARNDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<InstanceIdDetail>> INSTANCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceIds").getter(TraceSummary.getter(TraceSummary::instanceIds)).setter(TraceSummary.setter(Builder::instanceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceIdDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AvailabilityZoneDetail>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(TraceSummary.getter(TraceSummary::availabilityZones)).setter(TraceSummary.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AvailabilityZoneDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ServiceId> ENTRY_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EntryPoint").getter(TraceSummary.getter(TraceSummary::entryPoint)).setter(TraceSummary.setter(Builder::entryPoint)).constructor(ServiceId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntryPoint").build()}).build();
    private static final SdkField<List<FaultRootCause>> FAULT_ROOT_CAUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FaultRootCauses").getter(TraceSummary.getter(TraceSummary::faultRootCauses)).setter(TraceSummary.setter(Builder::faultRootCauses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaultRootCauses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FaultRootCause::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ErrorRootCause>> ERROR_ROOT_CAUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ErrorRootCauses").getter(TraceSummary.getter(TraceSummary::errorRootCauses)).setter(TraceSummary.setter(Builder::errorRootCauses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorRootCauses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ErrorRootCause::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResponseTimeRootCause>> RESPONSE_TIME_ROOT_CAUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResponseTimeRootCauses").getter(TraceSummary.getter(TraceSummary::responseTimeRootCauses)).setter(TraceSummary.setter(Builder::responseTimeRootCauses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseTimeRootCauses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResponseTimeRootCause::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Revision").getter(TraceSummary.getter(TraceSummary::revision)).setter(TraceSummary.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Revision").build()}).build();
    private static final SdkField<Instant> MATCHED_EVENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("MatchedEventTime").getter(TraceSummary.getter(TraceSummary::matchedEventTime)).setter(TraceSummary.setter(Builder::matchedEventTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchedEventTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DURATION_FIELD, RESPONSE_TIME_FIELD, HAS_FAULT_FIELD, HAS_ERROR_FIELD, HAS_THROTTLE_FIELD, IS_PARTIAL_FIELD, HTTP_FIELD, ANNOTATIONS_FIELD, USERS_FIELD, SERVICE_IDS_FIELD, RESOURCE_AR_NS_FIELD, INSTANCE_IDS_FIELD, AVAILABILITY_ZONES_FIELD, ENTRY_POINT_FIELD, FAULT_ROOT_CAUSES_FIELD, ERROR_ROOT_CAUSES_FIELD, RESPONSE_TIME_ROOT_CAUSES_FIELD, REVISION_FIELD, MATCHED_EVENT_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Double duration;
    private final Double responseTime;
    private final Boolean hasFault;
    private final Boolean hasError;
    private final Boolean hasThrottle;
    private final Boolean isPartial;
    private final Http http;
    private final Map<String, List<ValueWithServiceIds>> annotations;
    private final List<TraceUser> users;
    private final List<ServiceId> serviceIds;
    private final List<ResourceARNDetail> resourceARNs;
    private final List<InstanceIdDetail> instanceIds;
    private final List<AvailabilityZoneDetail> availabilityZones;
    private final ServiceId entryPoint;
    private final List<FaultRootCause> faultRootCauses;
    private final List<ErrorRootCause> errorRootCauses;
    private final List<ResponseTimeRootCause> responseTimeRootCauses;
    private final Integer revision;
    private final Instant matchedEventTime;

    private TraceSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.duration = builder.duration;
        this.responseTime = builder.responseTime;
        this.hasFault = builder.hasFault;
        this.hasError = builder.hasError;
        this.hasThrottle = builder.hasThrottle;
        this.isPartial = builder.isPartial;
        this.http = builder.http;
        this.annotations = builder.annotations;
        this.users = builder.users;
        this.serviceIds = builder.serviceIds;
        this.resourceARNs = builder.resourceARNs;
        this.instanceIds = builder.instanceIds;
        this.availabilityZones = builder.availabilityZones;
        this.entryPoint = builder.entryPoint;
        this.faultRootCauses = builder.faultRootCauses;
        this.errorRootCauses = builder.errorRootCauses;
        this.responseTimeRootCauses = builder.responseTimeRootCauses;
        this.revision = builder.revision;
        this.matchedEventTime = builder.matchedEventTime;
    }

    public final String id() {
        return this.id;
    }

    public final Double duration() {
        return this.duration;
    }

    public final Double responseTime() {
        return this.responseTime;
    }

    public final Boolean hasFault() {
        return this.hasFault;
    }

    public final Boolean hasError() {
        return this.hasError;
    }

    public final Boolean hasThrottle() {
        return this.hasThrottle;
    }

    public final Boolean isPartial() {
        return this.isPartial;
    }

    public final Http http() {
        return this.http;
    }

    public final boolean hasAnnotations() {
        return this.annotations != null && !(this.annotations instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<ValueWithServiceIds>> annotations() {
        return this.annotations;
    }

    public final boolean hasUsers() {
        return this.users != null && !(this.users instanceof SdkAutoConstructList);
    }

    public final List<TraceUser> users() {
        return this.users;
    }

    public final boolean hasServiceIds() {
        return this.serviceIds != null && !(this.serviceIds instanceof SdkAutoConstructList);
    }

    public final List<ServiceId> serviceIds() {
        return this.serviceIds;
    }

    public final boolean hasResourceARNs() {
        return this.resourceARNs != null && !(this.resourceARNs instanceof SdkAutoConstructList);
    }

    public final List<ResourceARNDetail> resourceARNs() {
        return this.resourceARNs;
    }

    public final boolean hasInstanceIds() {
        return this.instanceIds != null && !(this.instanceIds instanceof SdkAutoConstructList);
    }

    public final List<InstanceIdDetail> instanceIds() {
        return this.instanceIds;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<AvailabilityZoneDetail> availabilityZones() {
        return this.availabilityZones;
    }

    public final ServiceId entryPoint() {
        return this.entryPoint;
    }

    public final boolean hasFaultRootCauses() {
        return this.faultRootCauses != null && !(this.faultRootCauses instanceof SdkAutoConstructList);
    }

    public final List<FaultRootCause> faultRootCauses() {
        return this.faultRootCauses;
    }

    public final boolean hasErrorRootCauses() {
        return this.errorRootCauses != null && !(this.errorRootCauses instanceof SdkAutoConstructList);
    }

    public final List<ErrorRootCause> errorRootCauses() {
        return this.errorRootCauses;
    }

    public final boolean hasResponseTimeRootCauses() {
        return this.responseTimeRootCauses != null && !(this.responseTimeRootCauses instanceof SdkAutoConstructList);
    }

    public final List<ResponseTimeRootCause> responseTimeRootCauses() {
        return this.responseTimeRootCauses;
    }

    public final Integer revision() {
        return this.revision;
    }

    public final Instant matchedEventTime() {
        return this.matchedEventTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFault());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasError());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThrottle());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPartial());
        hashCode = 31 * hashCode + Objects.hashCode(this.http());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnnotations() ? this.annotations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsers() ? this.users() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceIds() ? this.serviceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceARNs() ? this.resourceARNs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceIds() ? this.instanceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.entryPoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFaultRootCauses() ? this.faultRootCauses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorRootCauses() ? this.errorRootCauses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseTimeRootCauses() ? this.responseTimeRootCauses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchedEventTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TraceSummary)) {
            return false;
        }
        TraceSummary other = (TraceSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.responseTime(), other.responseTime()) && Objects.equals(this.hasFault(), other.hasFault()) && Objects.equals(this.hasError(), other.hasError()) && Objects.equals(this.hasThrottle(), other.hasThrottle()) && Objects.equals(this.isPartial(), other.isPartial()) && Objects.equals(this.http(), other.http()) && this.hasAnnotations() == other.hasAnnotations() && Objects.equals(this.annotations(), other.annotations()) && this.hasUsers() == other.hasUsers() && Objects.equals(this.users(), other.users()) && this.hasServiceIds() == other.hasServiceIds() && Objects.equals(this.serviceIds(), other.serviceIds()) && this.hasResourceARNs() == other.hasResourceARNs() && Objects.equals(this.resourceARNs(), other.resourceARNs()) && this.hasInstanceIds() == other.hasInstanceIds() && Objects.equals(this.instanceIds(), other.instanceIds()) && this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.entryPoint(), other.entryPoint()) && this.hasFaultRootCauses() == other.hasFaultRootCauses() && Objects.equals(this.faultRootCauses(), other.faultRootCauses()) && this.hasErrorRootCauses() == other.hasErrorRootCauses() && Objects.equals(this.errorRootCauses(), other.errorRootCauses()) && this.hasResponseTimeRootCauses() == other.hasResponseTimeRootCauses() && Objects.equals(this.responseTimeRootCauses(), other.responseTimeRootCauses()) && Objects.equals(this.revision(), other.revision()) && Objects.equals(this.matchedEventTime(), other.matchedEventTime());
    }

    public final String toString() {
        return ToString.builder((String)"TraceSummary").add("Id", (Object)this.id()).add("Duration", (Object)this.duration()).add("ResponseTime", (Object)this.responseTime()).add("HasFault", (Object)this.hasFault()).add("HasError", (Object)this.hasError()).add("HasThrottle", (Object)this.hasThrottle()).add("IsPartial", (Object)this.isPartial()).add("Http", (Object)this.http()).add("Annotations", this.hasAnnotations() ? this.annotations() : null).add("Users", this.hasUsers() ? this.users() : null).add("ServiceIds", this.hasServiceIds() ? this.serviceIds() : null).add("ResourceARNs", this.hasResourceARNs() ? this.resourceARNs() : null).add("InstanceIds", this.hasInstanceIds() ? this.instanceIds() : null).add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("EntryPoint", (Object)this.entryPoint()).add("FaultRootCauses", this.hasFaultRootCauses() ? this.faultRootCauses() : null).add("ErrorRootCauses", this.hasErrorRootCauses() ? this.errorRootCauses() : null).add("ResponseTimeRootCauses", this.hasResponseTimeRootCauses() ? this.responseTimeRootCauses() : null).add("Revision", (Object)this.revision()).add("MatchedEventTime", (Object)this.matchedEventTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "ResponseTime": {
                return Optional.ofNullable(clazz.cast(this.responseTime()));
            }
            case "HasFault": {
                return Optional.ofNullable(clazz.cast(this.hasFault()));
            }
            case "HasError": {
                return Optional.ofNullable(clazz.cast(this.hasError()));
            }
            case "HasThrottle": {
                return Optional.ofNullable(clazz.cast(this.hasThrottle()));
            }
            case "IsPartial": {
                return Optional.ofNullable(clazz.cast(this.isPartial()));
            }
            case "Http": {
                return Optional.ofNullable(clazz.cast(this.http()));
            }
            case "Annotations": {
                return Optional.ofNullable(clazz.cast(this.annotations()));
            }
            case "Users": {
                return Optional.ofNullable(clazz.cast(this.users()));
            }
            case "ServiceIds": {
                return Optional.ofNullable(clazz.cast(this.serviceIds()));
            }
            case "ResourceARNs": {
                return Optional.ofNullable(clazz.cast(this.resourceARNs()));
            }
            case "InstanceIds": {
                return Optional.ofNullable(clazz.cast(this.instanceIds()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "EntryPoint": {
                return Optional.ofNullable(clazz.cast(this.entryPoint()));
            }
            case "FaultRootCauses": {
                return Optional.ofNullable(clazz.cast(this.faultRootCauses()));
            }
            case "ErrorRootCauses": {
                return Optional.ofNullable(clazz.cast(this.errorRootCauses()));
            }
            case "ResponseTimeRootCauses": {
                return Optional.ofNullable(clazz.cast(this.responseTimeRootCauses()));
            }
            case "Revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "MatchedEventTime": {
                return Optional.ofNullable(clazz.cast(this.matchedEventTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TraceSummary, T> g) {
        return obj -> g.apply((TraceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Double duration;
        private Double responseTime;
        private Boolean hasFault;
        private Boolean hasError;
        private Boolean hasThrottle;
        private Boolean isPartial;
        private Http http;
        private Map<String, List<ValueWithServiceIds>> annotations = DefaultSdkAutoConstructMap.getInstance();
        private List<TraceUser> users = DefaultSdkAutoConstructList.getInstance();
        private List<ServiceId> serviceIds = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceARNDetail> resourceARNs = DefaultSdkAutoConstructList.getInstance();
        private List<InstanceIdDetail> instanceIds = DefaultSdkAutoConstructList.getInstance();
        private List<AvailabilityZoneDetail> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private ServiceId entryPoint;
        private List<FaultRootCause> faultRootCauses = DefaultSdkAutoConstructList.getInstance();
        private List<ErrorRootCause> errorRootCauses = DefaultSdkAutoConstructList.getInstance();
        private List<ResponseTimeRootCause> responseTimeRootCauses = DefaultSdkAutoConstructList.getInstance();
        private Integer revision;
        private Instant matchedEventTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TraceSummary model) {
            this.id(model.id);
            this.duration(model.duration);
            this.responseTime(model.responseTime);
            this.hasFault(model.hasFault);
            this.hasError(model.hasError);
            this.hasThrottle(model.hasThrottle);
            this.isPartial(model.isPartial);
            this.http(model.http);
            this.annotations(model.annotations);
            this.users(model.users);
            this.serviceIds(model.serviceIds);
            this.resourceARNs(model.resourceARNs);
            this.instanceIds(model.instanceIds);
            this.availabilityZones(model.availabilityZones);
            this.entryPoint(model.entryPoint);
            this.faultRootCauses(model.faultRootCauses);
            this.errorRootCauses(model.errorRootCauses);
            this.responseTimeRootCauses(model.responseTimeRootCauses);
            this.revision(model.revision);
            this.matchedEventTime(model.matchedEventTime);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Double getDuration() {
            return this.duration;
        }

        public final void setDuration(Double duration) {
            this.duration = duration;
        }

        @Override
        @Transient
        public final Builder duration(Double duration) {
            this.duration = duration;
            return this;
        }

        public final Double getResponseTime() {
            return this.responseTime;
        }

        public final void setResponseTime(Double responseTime) {
            this.responseTime = responseTime;
        }

        @Override
        @Transient
        public final Builder responseTime(Double responseTime) {
            this.responseTime = responseTime;
            return this;
        }

        public final Boolean getHasFault() {
            return this.hasFault;
        }

        public final void setHasFault(Boolean hasFault) {
            this.hasFault = hasFault;
        }

        @Override
        @Transient
        public final Builder hasFault(Boolean hasFault) {
            this.hasFault = hasFault;
            return this;
        }

        public final Boolean getHasError() {
            return this.hasError;
        }

        public final void setHasError(Boolean hasError) {
            this.hasError = hasError;
        }

        @Override
        @Transient
        public final Builder hasError(Boolean hasError) {
            this.hasError = hasError;
            return this;
        }

        public final Boolean getHasThrottle() {
            return this.hasThrottle;
        }

        public final void setHasThrottle(Boolean hasThrottle) {
            this.hasThrottle = hasThrottle;
        }

        @Override
        @Transient
        public final Builder hasThrottle(Boolean hasThrottle) {
            this.hasThrottle = hasThrottle;
            return this;
        }

        public final Boolean getIsPartial() {
            return this.isPartial;
        }

        public final void setIsPartial(Boolean isPartial) {
            this.isPartial = isPartial;
        }

        @Override
        @Transient
        public final Builder isPartial(Boolean isPartial) {
            this.isPartial = isPartial;
            return this;
        }

        public final Http.Builder getHttp() {
            return this.http != null ? this.http.toBuilder() : null;
        }

        public final void setHttp(Http.BuilderImpl http) {
            this.http = http != null ? http.build() : null;
        }

        @Override
        @Transient
        public final Builder http(Http http) {
            this.http = http;
            return this;
        }

        public final Map<String, List<ValueWithServiceIds.Builder>> getAnnotations() {
            Map<String, List<ValueWithServiceIds.Builder>> result = AnnotationsCopier.copyToBuilder(this.annotations);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAnnotations(Map<String, ? extends Collection<ValueWithServiceIds.BuilderImpl>> annotations) {
            this.annotations = AnnotationsCopier.copyFromBuilder(annotations);
        }

        @Override
        @Transient
        public final Builder annotations(Map<String, ? extends Collection<ValueWithServiceIds>> annotations) {
            this.annotations = AnnotationsCopier.copy(annotations);
            return this;
        }

        public final List<TraceUser.Builder> getUsers() {
            List<TraceUser.Builder> result = TraceUsersCopier.copyToBuilder(this.users);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsers(Collection<TraceUser.BuilderImpl> users) {
            this.users = TraceUsersCopier.copyFromBuilder(users);
        }

        @Override
        @Transient
        public final Builder users(Collection<TraceUser> users) {
            this.users = TraceUsersCopier.copy(users);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder users(TraceUser ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder users(Consumer<TraceUser.Builder> ... users) {
            this.users(Stream.of(users).map(c -> (TraceUser)((TraceUser.Builder)TraceUser.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ServiceId.Builder> getServiceIds() {
            List<ServiceId.Builder> result = ServiceIdsCopier.copyToBuilder(this.serviceIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceIds(Collection<ServiceId.BuilderImpl> serviceIds) {
            this.serviceIds = ServiceIdsCopier.copyFromBuilder(serviceIds);
        }

        @Override
        @Transient
        public final Builder serviceIds(Collection<ServiceId> serviceIds) {
            this.serviceIds = ServiceIdsCopier.copy(serviceIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder serviceIds(ServiceId ... serviceIds) {
            this.serviceIds(Arrays.asList(serviceIds));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder serviceIds(Consumer<ServiceId.Builder> ... serviceIds) {
            this.serviceIds(Stream.of(serviceIds).map(c -> (ServiceId)((ServiceId.Builder)ServiceId.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceARNDetail.Builder> getResourceARNs() {
            List<ResourceARNDetail.Builder> result = TraceResourceARNsCopier.copyToBuilder(this.resourceARNs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceARNs(Collection<ResourceARNDetail.BuilderImpl> resourceARNs) {
            this.resourceARNs = TraceResourceARNsCopier.copyFromBuilder(resourceARNs);
        }

        @Override
        @Transient
        public final Builder resourceARNs(Collection<ResourceARNDetail> resourceARNs) {
            this.resourceARNs = TraceResourceARNsCopier.copy(resourceARNs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resourceARNs(ResourceARNDetail ... resourceARNs) {
            this.resourceARNs(Arrays.asList(resourceARNs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resourceARNs(Consumer<ResourceARNDetail.Builder> ... resourceARNs) {
            this.resourceARNs(Stream.of(resourceARNs).map(c -> (ResourceARNDetail)((ResourceARNDetail.Builder)ResourceARNDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<InstanceIdDetail.Builder> getInstanceIds() {
            List<InstanceIdDetail.Builder> result = TraceInstanceIdsCopier.copyToBuilder(this.instanceIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceIds(Collection<InstanceIdDetail.BuilderImpl> instanceIds) {
            this.instanceIds = TraceInstanceIdsCopier.copyFromBuilder(instanceIds);
        }

        @Override
        @Transient
        public final Builder instanceIds(Collection<InstanceIdDetail> instanceIds) {
            this.instanceIds = TraceInstanceIdsCopier.copy(instanceIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder instanceIds(InstanceIdDetail ... instanceIds) {
            this.instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder instanceIds(Consumer<InstanceIdDetail.Builder> ... instanceIds) {
            this.instanceIds(Stream.of(instanceIds).map(c -> (InstanceIdDetail)((InstanceIdDetail.Builder)InstanceIdDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AvailabilityZoneDetail.Builder> getAvailabilityZones() {
            List<AvailabilityZoneDetail.Builder> result = TraceAvailabilityZonesCopier.copyToBuilder(this.availabilityZones);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailabilityZones(Collection<AvailabilityZoneDetail.BuilderImpl> availabilityZones) {
            this.availabilityZones = TraceAvailabilityZonesCopier.copyFromBuilder(availabilityZones);
        }

        @Override
        @Transient
        public final Builder availabilityZones(Collection<AvailabilityZoneDetail> availabilityZones) {
            this.availabilityZones = TraceAvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder availabilityZones(AvailabilityZoneDetail ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder availabilityZones(Consumer<AvailabilityZoneDetail.Builder> ... availabilityZones) {
            this.availabilityZones(Stream.of(availabilityZones).map(c -> (AvailabilityZoneDetail)((AvailabilityZoneDetail.Builder)AvailabilityZoneDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ServiceId.Builder getEntryPoint() {
            return this.entryPoint != null ? this.entryPoint.toBuilder() : null;
        }

        public final void setEntryPoint(ServiceId.BuilderImpl entryPoint) {
            this.entryPoint = entryPoint != null ? entryPoint.build() : null;
        }

        @Override
        @Transient
        public final Builder entryPoint(ServiceId entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        public final List<FaultRootCause.Builder> getFaultRootCauses() {
            List<FaultRootCause.Builder> result = FaultRootCausesCopier.copyToBuilder(this.faultRootCauses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFaultRootCauses(Collection<FaultRootCause.BuilderImpl> faultRootCauses) {
            this.faultRootCauses = FaultRootCausesCopier.copyFromBuilder(faultRootCauses);
        }

        @Override
        @Transient
        public final Builder faultRootCauses(Collection<FaultRootCause> faultRootCauses) {
            this.faultRootCauses = FaultRootCausesCopier.copy(faultRootCauses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder faultRootCauses(FaultRootCause ... faultRootCauses) {
            this.faultRootCauses(Arrays.asList(faultRootCauses));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder faultRootCauses(Consumer<FaultRootCause.Builder> ... faultRootCauses) {
            this.faultRootCauses(Stream.of(faultRootCauses).map(c -> (FaultRootCause)((FaultRootCause.Builder)FaultRootCause.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ErrorRootCause.Builder> getErrorRootCauses() {
            List<ErrorRootCause.Builder> result = ErrorRootCausesCopier.copyToBuilder(this.errorRootCauses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorRootCauses(Collection<ErrorRootCause.BuilderImpl> errorRootCauses) {
            this.errorRootCauses = ErrorRootCausesCopier.copyFromBuilder(errorRootCauses);
        }

        @Override
        @Transient
        public final Builder errorRootCauses(Collection<ErrorRootCause> errorRootCauses) {
            this.errorRootCauses = ErrorRootCausesCopier.copy(errorRootCauses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder errorRootCauses(ErrorRootCause ... errorRootCauses) {
            this.errorRootCauses(Arrays.asList(errorRootCauses));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder errorRootCauses(Consumer<ErrorRootCause.Builder> ... errorRootCauses) {
            this.errorRootCauses(Stream.of(errorRootCauses).map(c -> (ErrorRootCause)((ErrorRootCause.Builder)ErrorRootCause.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResponseTimeRootCause.Builder> getResponseTimeRootCauses() {
            List<ResponseTimeRootCause.Builder> result = ResponseTimeRootCausesCopier.copyToBuilder(this.responseTimeRootCauses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResponseTimeRootCauses(Collection<ResponseTimeRootCause.BuilderImpl> responseTimeRootCauses) {
            this.responseTimeRootCauses = ResponseTimeRootCausesCopier.copyFromBuilder(responseTimeRootCauses);
        }

        @Override
        @Transient
        public final Builder responseTimeRootCauses(Collection<ResponseTimeRootCause> responseTimeRootCauses) {
            this.responseTimeRootCauses = ResponseTimeRootCausesCopier.copy(responseTimeRootCauses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder responseTimeRootCauses(ResponseTimeRootCause ... responseTimeRootCauses) {
            this.responseTimeRootCauses(Arrays.asList(responseTimeRootCauses));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder responseTimeRootCauses(Consumer<ResponseTimeRootCause.Builder> ... responseTimeRootCauses) {
            this.responseTimeRootCauses(Stream.of(responseTimeRootCauses).map(c -> (ResponseTimeRootCause)((ResponseTimeRootCause.Builder)ResponseTimeRootCause.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getRevision() {
            return this.revision;
        }

        public final void setRevision(Integer revision) {
            this.revision = revision;
        }

        @Override
        @Transient
        public final Builder revision(Integer revision) {
            this.revision = revision;
            return this;
        }

        public final Instant getMatchedEventTime() {
            return this.matchedEventTime;
        }

        public final void setMatchedEventTime(Instant matchedEventTime) {
            this.matchedEventTime = matchedEventTime;
        }

        @Override
        @Transient
        public final Builder matchedEventTime(Instant matchedEventTime) {
            this.matchedEventTime = matchedEventTime;
            return this;
        }

        public TraceSummary build() {
            return new TraceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TraceSummary> {
        public Builder id(String var1);

        public Builder duration(Double var1);

        public Builder responseTime(Double var1);

        public Builder hasFault(Boolean var1);

        public Builder hasError(Boolean var1);

        public Builder hasThrottle(Boolean var1);

        public Builder isPartial(Boolean var1);

        public Builder http(Http var1);

        default public Builder http(Consumer<Http.Builder> http) {
            return this.http((Http)((Http.Builder)Http.builder().applyMutation(http)).build());
        }

        public Builder annotations(Map<String, ? extends Collection<ValueWithServiceIds>> var1);

        public Builder users(Collection<TraceUser> var1);

        public Builder users(TraceUser ... var1);

        public Builder users(Consumer<TraceUser.Builder> ... var1);

        public Builder serviceIds(Collection<ServiceId> var1);

        public Builder serviceIds(ServiceId ... var1);

        public Builder serviceIds(Consumer<ServiceId.Builder> ... var1);

        public Builder resourceARNs(Collection<ResourceARNDetail> var1);

        public Builder resourceARNs(ResourceARNDetail ... var1);

        public Builder resourceARNs(Consumer<ResourceARNDetail.Builder> ... var1);

        public Builder instanceIds(Collection<InstanceIdDetail> var1);

        public Builder instanceIds(InstanceIdDetail ... var1);

        public Builder instanceIds(Consumer<InstanceIdDetail.Builder> ... var1);

        public Builder availabilityZones(Collection<AvailabilityZoneDetail> var1);

        public Builder availabilityZones(AvailabilityZoneDetail ... var1);

        public Builder availabilityZones(Consumer<AvailabilityZoneDetail.Builder> ... var1);

        public Builder entryPoint(ServiceId var1);

        default public Builder entryPoint(Consumer<ServiceId.Builder> entryPoint) {
            return this.entryPoint((ServiceId)((ServiceId.Builder)ServiceId.builder().applyMutation(entryPoint)).build());
        }

        public Builder faultRootCauses(Collection<FaultRootCause> var1);

        public Builder faultRootCauses(FaultRootCause ... var1);

        public Builder faultRootCauses(Consumer<FaultRootCause.Builder> ... var1);

        public Builder errorRootCauses(Collection<ErrorRootCause> var1);

        public Builder errorRootCauses(ErrorRootCause ... var1);

        public Builder errorRootCauses(Consumer<ErrorRootCause.Builder> ... var1);

        public Builder responseTimeRootCauses(Collection<ResponseTimeRootCause> var1);

        public Builder responseTimeRootCauses(ResponseTimeRootCause ... var1);

        public Builder responseTimeRootCauses(Consumer<ResponseTimeRootCause.Builder> ... var1);

        public Builder revision(Integer var1);

        public Builder matchedEventTime(Instant var1);
    }
}

