/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.AnomalousService;
import software.amazon.awssdk.services.xray.model.AnomalousServiceListCopier;
import software.amazon.awssdk.services.xray.model.RequestImpactStatistics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InsightEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InsightEvent> {
    private static final SdkField<String> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Summary").getter(InsightEvent.getter(InsightEvent::summary)).setter(InsightEvent.setter(Builder::summary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()}).build();
    private static final SdkField<Instant> EVENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EventTime").getter(InsightEvent.getter(InsightEvent::eventTime)).setter(InsightEvent.setter(Builder::eventTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTime").build()}).build();
    private static final SdkField<RequestImpactStatistics> CLIENT_REQUEST_IMPACT_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClientRequestImpactStatistics").getter(InsightEvent.getter(InsightEvent::clientRequestImpactStatistics)).setter(InsightEvent.setter(Builder::clientRequestImpactStatistics)).constructor(RequestImpactStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestImpactStatistics").build()}).build();
    private static final SdkField<RequestImpactStatistics> ROOT_CAUSE_SERVICE_REQUEST_IMPACT_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RootCauseServiceRequestImpactStatistics").getter(InsightEvent.getter(InsightEvent::rootCauseServiceRequestImpactStatistics)).setter(InsightEvent.setter(Builder::rootCauseServiceRequestImpactStatistics)).constructor(RequestImpactStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootCauseServiceRequestImpactStatistics").build()}).build();
    private static final SdkField<List<AnomalousService>> TOP_ANOMALOUS_SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TopAnomalousServices").getter(InsightEvent.getter(InsightEvent::topAnomalousServices)).setter(InsightEvent.setter(Builder::topAnomalousServices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopAnomalousServices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnomalousService::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_FIELD, EVENT_TIME_FIELD, CLIENT_REQUEST_IMPACT_STATISTICS_FIELD, ROOT_CAUSE_SERVICE_REQUEST_IMPACT_STATISTICS_FIELD, TOP_ANOMALOUS_SERVICES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String summary;
    private final Instant eventTime;
    private final RequestImpactStatistics clientRequestImpactStatistics;
    private final RequestImpactStatistics rootCauseServiceRequestImpactStatistics;
    private final List<AnomalousService> topAnomalousServices;

    private InsightEvent(BuilderImpl builder) {
        this.summary = builder.summary;
        this.eventTime = builder.eventTime;
        this.clientRequestImpactStatistics = builder.clientRequestImpactStatistics;
        this.rootCauseServiceRequestImpactStatistics = builder.rootCauseServiceRequestImpactStatistics;
        this.topAnomalousServices = builder.topAnomalousServices;
    }

    public final String summary() {
        return this.summary;
    }

    public final Instant eventTime() {
        return this.eventTime;
    }

    public final RequestImpactStatistics clientRequestImpactStatistics() {
        return this.clientRequestImpactStatistics;
    }

    public final RequestImpactStatistics rootCauseServiceRequestImpactStatistics() {
        return this.rootCauseServiceRequestImpactStatistics;
    }

    public final boolean hasTopAnomalousServices() {
        return this.topAnomalousServices != null && !(this.topAnomalousServices instanceof SdkAutoConstructList);
    }

    public final List<AnomalousService> topAnomalousServices() {
        return this.topAnomalousServices;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestImpactStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootCauseServiceRequestImpactStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopAnomalousServices() ? this.topAnomalousServices() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightEvent)) {
            return false;
        }
        InsightEvent other = (InsightEvent)obj;
        return Objects.equals(this.summary(), other.summary()) && Objects.equals(this.eventTime(), other.eventTime()) && Objects.equals(this.clientRequestImpactStatistics(), other.clientRequestImpactStatistics()) && Objects.equals(this.rootCauseServiceRequestImpactStatistics(), other.rootCauseServiceRequestImpactStatistics()) && this.hasTopAnomalousServices() == other.hasTopAnomalousServices() && Objects.equals(this.topAnomalousServices(), other.topAnomalousServices());
    }

    public final String toString() {
        return ToString.builder((String)"InsightEvent").add("Summary", (Object)this.summary()).add("EventTime", (Object)this.eventTime()).add("ClientRequestImpactStatistics", (Object)this.clientRequestImpactStatistics()).add("RootCauseServiceRequestImpactStatistics", (Object)this.rootCauseServiceRequestImpactStatistics()).add("TopAnomalousServices", this.hasTopAnomalousServices() ? this.topAnomalousServices() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
            case "EventTime": {
                return Optional.ofNullable(clazz.cast(this.eventTime()));
            }
            case "ClientRequestImpactStatistics": {
                return Optional.ofNullable(clazz.cast(this.clientRequestImpactStatistics()));
            }
            case "RootCauseServiceRequestImpactStatistics": {
                return Optional.ofNullable(clazz.cast(this.rootCauseServiceRequestImpactStatistics()));
            }
            case "TopAnomalousServices": {
                return Optional.ofNullable(clazz.cast(this.topAnomalousServices()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InsightEvent, T> g) {
        return obj -> g.apply((InsightEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String summary;
        private Instant eventTime;
        private RequestImpactStatistics clientRequestImpactStatistics;
        private RequestImpactStatistics rootCauseServiceRequestImpactStatistics;
        private List<AnomalousService> topAnomalousServices = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InsightEvent model) {
            this.summary(model.summary);
            this.eventTime(model.eventTime);
            this.clientRequestImpactStatistics(model.clientRequestImpactStatistics);
            this.rootCauseServiceRequestImpactStatistics(model.rootCauseServiceRequestImpactStatistics);
            this.topAnomalousServices(model.topAnomalousServices);
        }

        public final String getSummary() {
            return this.summary;
        }

        @Override
        public final Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public final void setSummary(String summary) {
            this.summary = summary;
        }

        public final Instant getEventTime() {
            return this.eventTime;
        }

        @Override
        public final Builder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final void setEventTime(Instant eventTime) {
            this.eventTime = eventTime;
        }

        public final RequestImpactStatistics.Builder getClientRequestImpactStatistics() {
            return this.clientRequestImpactStatistics != null ? this.clientRequestImpactStatistics.toBuilder() : null;
        }

        @Override
        public final Builder clientRequestImpactStatistics(RequestImpactStatistics clientRequestImpactStatistics) {
            this.clientRequestImpactStatistics = clientRequestImpactStatistics;
            return this;
        }

        public final void setClientRequestImpactStatistics(RequestImpactStatistics.BuilderImpl clientRequestImpactStatistics) {
            this.clientRequestImpactStatistics = clientRequestImpactStatistics != null ? clientRequestImpactStatistics.build() : null;
        }

        public final RequestImpactStatistics.Builder getRootCauseServiceRequestImpactStatistics() {
            return this.rootCauseServiceRequestImpactStatistics != null ? this.rootCauseServiceRequestImpactStatistics.toBuilder() : null;
        }

        @Override
        public final Builder rootCauseServiceRequestImpactStatistics(RequestImpactStatistics rootCauseServiceRequestImpactStatistics) {
            this.rootCauseServiceRequestImpactStatistics = rootCauseServiceRequestImpactStatistics;
            return this;
        }

        public final void setRootCauseServiceRequestImpactStatistics(RequestImpactStatistics.BuilderImpl rootCauseServiceRequestImpactStatistics) {
            this.rootCauseServiceRequestImpactStatistics = rootCauseServiceRequestImpactStatistics != null ? rootCauseServiceRequestImpactStatistics.build() : null;
        }

        public final List<AnomalousService.Builder> getTopAnomalousServices() {
            List<AnomalousService.Builder> result = AnomalousServiceListCopier.copyToBuilder(this.topAnomalousServices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder topAnomalousServices(Collection<AnomalousService> topAnomalousServices) {
            this.topAnomalousServices = AnomalousServiceListCopier.copy(topAnomalousServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topAnomalousServices(AnomalousService ... topAnomalousServices) {
            this.topAnomalousServices(Arrays.asList(topAnomalousServices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topAnomalousServices(Consumer<AnomalousService.Builder> ... topAnomalousServices) {
            this.topAnomalousServices(Stream.of(topAnomalousServices).map(c -> (AnomalousService)((AnomalousService.Builder)AnomalousService.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTopAnomalousServices(Collection<AnomalousService.BuilderImpl> topAnomalousServices) {
            this.topAnomalousServices = AnomalousServiceListCopier.copyFromBuilder(topAnomalousServices);
        }

        public InsightEvent build() {
            return new InsightEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InsightEvent> {
        public Builder summary(String var1);

        public Builder eventTime(Instant var1);

        public Builder clientRequestImpactStatistics(RequestImpactStatistics var1);

        default public Builder clientRequestImpactStatistics(Consumer<RequestImpactStatistics.Builder> clientRequestImpactStatistics) {
            return this.clientRequestImpactStatistics((RequestImpactStatistics)((RequestImpactStatistics.Builder)RequestImpactStatistics.builder().applyMutation(clientRequestImpactStatistics)).build());
        }

        public Builder rootCauseServiceRequestImpactStatistics(RequestImpactStatistics var1);

        default public Builder rootCauseServiceRequestImpactStatistics(Consumer<RequestImpactStatistics.Builder> rootCauseServiceRequestImpactStatistics) {
            return this.rootCauseServiceRequestImpactStatistics((RequestImpactStatistics)((RequestImpactStatistics.Builder)RequestImpactStatistics.builder().applyMutation(rootCauseServiceRequestImpactStatistics)).build());
        }

        public Builder topAnomalousServices(Collection<AnomalousService> var1);

        public Builder topAnomalousServices(AnomalousService ... var1);

        public Builder topAnomalousServices(Consumer<AnomalousService.Builder> ... var1);
    }
}

